/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.as.monitoring.collector.jmx.clients;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.as.monitoring.collector.jmx.clients.Result;

public abstract class MBeanClient {
    private static final Log LOG = LogFactory.getLog(MBeanClient.class);
    private static MBeanServer server;

    public MBeanClient() {
        server = ManagementFactory.getPlatformMBeanServer();
    }

    protected abstract String getObjectNameQuery();

    protected abstract String[] getAttributeNames();

    protected abstract AttributeList getPropertiesFromKey(ObjectName var1);

    protected abstract String getCorrelationKey(ObjectName var1);

    public List<Result> readPossibleAttributeValues() throws MalformedObjectNameException {
        ObjectName name = new ObjectName(this.getObjectNameQuery());
        Set<ObjectInstance> instances = server.queryMBeans(name, null);
        ArrayList<Result> results = new ArrayList<Result>();
        for (ObjectInstance instance : instances) {
            AttributeList attributes;
            ObjectName objectName;
            block6: {
                objectName = instance.getObjectName();
                attributes = null;
                try {
                    attributes = server.getAttributes(objectName, this.getAttributeNames());
                }
                catch (InstanceNotFoundException ignored) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(objectName + " MBean not found : " + ignored.getMessage()), (Throwable)ignored);
                    }
                }
                catch (ReflectionException ignored) {
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug((Object)("Exception occurred while reading the attributes from " + objectName), (Throwable)ignored);
                }
            }
            if (attributes != null) {
                attributes.addAll(this.getPropertiesFromKey(objectName));
            }
            Result result = new Result(this.getCorrelationKey(objectName), attributes);
            results.add(result);
        }
        return results;
    }
}

