/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.as.monitoring.publisher;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.as.monitoring.config.BAMPublisherConfigurationException;
import org.wso2.carbon.as.monitoring.config.StreamConfigContext;
import org.wso2.carbon.as.monitoring.config.StreamConfigurationReader;
import org.wso2.carbon.as.monitoring.publisher.MonitoringPublisherException;
import org.wso2.carbon.databridge.agent.DataPublisher;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAgentConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAuthenticationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.TransportException;

public abstract class PublisherBase {
    private static final Log LOG = LogFactory.getLog(PublisherBase.class);
    protected StreamConfigContext configContext;
    protected volatile DataPublisher publisher;

    public PublisherBase() throws BAMPublisherConfigurationException {
        String streamName = this.getDataStreamName();
        this.configContext = StreamConfigurationReader.getInstance().getStreamConfiguration(streamName);
    }

    public boolean isPublishable() {
        return this.configContext.isEnabled();
    }

    protected abstract void addPayloadDataAttributes(StreamDefinition var1);

    protected abstract void addMetaDataAttributes(StreamDefinition var1);

    protected abstract String getDataStreamName();

    protected StreamDefinition createStreamDefinition() throws BAMPublisherConfigurationException {
        StreamDefinition definition;
        try {
            definition = new StreamDefinition(this.configContext.getStreamName(), this.configContext.getStreamVersion());
            definition.setDescription(this.configContext.getDescription());
            definition.setNickName(this.configContext.getNickName());
            this.addMetaDataAttributes(definition);
            this.addPayloadDataAttributes(definition);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Stream definition created : " + definition));
            }
        }
        catch (MalformedStreamDefinitionException e) {
            throw new BAMPublisherConfigurationException("The values in bam-publisher.xml are malformed for " + this.configContext.getStreamName(), e);
        }
        return definition;
    }

    protected void publish(Event event) throws MonitoringPublisherException {
        if (!this.configContext.isEnabled()) {
            return;
        }
        try {
            this.loadPublisher();
            this.publisher.tryPublish(event.getStreamId(), System.currentTimeMillis(), event.getMetaData(), event.getCorrelationData(), event.getPayloadData());
        }
        catch (BAMPublisherConfigurationException | DataEndpointAgentConfigurationException | DataEndpointAuthenticationException | DataEndpointConfigurationException | DataEndpointException | TransportException e) {
            throw new MonitoringPublisherException("Exception occurred while connecting to BAM.", e);
        }
    }

    protected Integer mapNull(Integer value) {
        return value == null ? 0 : value;
    }

    protected Long mapNull(Long value) {
        return value == null ? 0L : value;
    }

    protected String mapNull(String value) {
        return value == null ? "-" : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPublisher() throws BAMPublisherConfigurationException, DataEndpointAuthenticationException, DataEndpointAgentConfigurationException, DataEndpointException, DataEndpointConfigurationException, TransportException {
        if (this.publisher == null) {
            PublisherBase publisherBase = this;
            synchronized (publisherBase) {
                if (this.publisher == null) {
                    this.publisher = this.createPublisher();
                }
            }
        }
    }

    private DataPublisher createPublisher() throws DataEndpointAuthenticationException, DataEndpointAgentConfigurationException, TransportException, DataEndpointException, DataEndpointConfigurationException {
        DataPublisher dataPublisher = new DataPublisher(this.configContext.getReceiverUrl(), this.configContext.getUsername(), this.configContext.getPassword());
        return dataPublisher;
    }
}

