/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.as.monitoring.publisher.webappresource;

import java.util.ArrayList;
import org.wso2.carbon.as.monitoring.config.BAMPublisherConfigurationException;
import org.wso2.carbon.as.monitoring.publisher.MonitoringPublisherException;
import org.wso2.carbon.as.monitoring.publisher.PublisherBase;
import org.wso2.carbon.as.monitoring.publisher.webappresource.WebappResourceMonitoringEvent;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;

public class WebappResourcePublisher
extends PublisherBase {
    public void publish(WebappResourceMonitoringEvent e) throws MonitoringPublisherException {
        ArrayList<String> metaData = new ArrayList<String>();
        metaData.add(this.mapNull(e.getServerAddress()));
        metaData.add(this.mapNull(e.getServerName()));
        metaData.add(this.mapNull(e.getClusterDomain()));
        metaData.add(this.mapNull(e.getClusterSubDomain()));
        metaData.add(this.mapNull(e.getHost()));
        metaData.add(this.mapNull(e.getContext()));
        ArrayList<Number> payloadData = new ArrayList<Number>();
        payloadData.add(this.mapNull(e.getProcessingTime()));
        payloadData.add(this.mapNull(e.getActiveSessions()));
        payloadData.add(this.mapNull(e.getRejectedSessions()));
        payloadData.add(this.mapNull(e.getExpiredSessions()));
        payloadData.add(this.mapNull(e.getJspCount()));
        payloadData.add(this.mapNull(e.getJspReloadCount()));
        payloadData.add(this.mapNull(e.getJspErrorCount()));
        payloadData.add(this.mapNull(e.getAccessCount()));
        payloadData.add(this.mapNull(e.getHitsCount()));
        payloadData.add(this.mapNull(e.getCacheSize()));
        Event event = new Event();
        event.setMetaData(metaData.toArray());
        event.setPayloadData(payloadData.toArray());
        event.setCorrelationData(new Object[0]);
        this.publish(event);
    }

    @Override
    protected void addPayloadDataAttributes(StreamDefinition definition) {
        definition.addPayloadData("processingTime", AttributeType.LONG);
        definition.addPayloadData("activeSessions", AttributeType.INT);
        definition.addPayloadData("rejectedSessions", AttributeType.INT);
        definition.addPayloadData("expiredSessions", AttributeType.LONG);
        definition.addPayloadData("jspCount", AttributeType.INT);
        definition.addPayloadData("jspReloadCount", AttributeType.INT);
        definition.addPayloadData("jspErrorCount", AttributeType.INT);
        definition.addPayloadData("cacheAccessCount", AttributeType.LONG);
        definition.addPayloadData("cacheHitsCount", AttributeType.LONG);
        definition.addPayloadData("cacheSize", AttributeType.INT);
    }

    @Override
    protected void addMetaDataAttributes(StreamDefinition definition) {
        definition.addMetaData("serverAddress", AttributeType.STRING);
        definition.addMetaData("serverName", AttributeType.STRING);
        definition.addMetaData("clusterDomain", AttributeType.STRING);
        definition.addMetaData("clusterSubDomain", AttributeType.STRING);
        definition.addMetaData("host", AttributeType.STRING);
        definition.addMetaData("context", AttributeType.STRING);
    }

    @Override
    protected String getDataStreamName() {
        return "monitoring.webapp.resource";
    }
}

