/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.ext.cxf.lifecycle;

import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.interceptor.Interceptor;
import org.wso2.carbon.webapp.ext.cxf.Constants;
import org.wso2.carbon.webapp.ext.cxf.interceptor.HostNameSupportedWSDLGetInterceptor;
import org.wso2.carbon.webapp.ext.cxf.lifecycle.CarbonConfiguration;
import org.wso2.carbon.webapp.ext.cxf.lifecycle.CarbonConfigurationFactory;
import org.wso2.carbon.webapp.ext.cxf.lifecycle.CarbonServerLifeCycleUtil;

public class CarbonServerLifeCycleListener
implements ServerLifeCycleListener {
    public void startServer(Server server) {
        CarbonConfiguration configuration = CarbonConfigurationFactory.getCurrentCarbonConfiguration();
        this.setCarbonHostName(server, configuration);
    }

    public void stopServer(Server server) {
    }

    protected void setCarbonHostName(Server server, CarbonConfiguration configuration) {
        String hostName = (String)configuration.getParameterValue(Constants.CARBON_HOSTNAME_PARAMETER);
        if (hostName != null && !"".equals(hostName)) {
            HostNameSupportedWSDLGetInterceptor getInterceptor = new HostNameSupportedWSDLGetInterceptor(hostName);
            CarbonServerLifeCycleUtil.replaceInInterceptor(server, Constants.CXF_WSDLGET_INTERCEPTOR_NAME, (Interceptor)getInterceptor);
        }
    }
}

