/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.ext.cxf.interceptor;

import java.util.Map;
import org.apache.cxf.frontend.WSDLGetInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.webapp.ext.cxf.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostNameSupportedWSDLGetInterceptor
extends WSDLGetInterceptor {
    private String hostName;

    public HostNameSupportedWSDLGetInterceptor() {
    }

    public HostNameSupportedWSDLGetInterceptor(String hostName) {
        this.hostName = hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public Document getDocument(Message message, String base, Map<String, String> params, String ctxUri, EndpointInfo endpointInfo) {
        Element rootEle;
        NodeList serviceEles;
        Document document = super.getDocument(message, base, params, ctxUri, endpointInfo);
        Node rootNode = document.getFirstChild();
        if (rootNode != null && rootNode instanceof Element && (serviceEles = (rootEle = (Element)rootNode).getElementsByTagNameNS(Constants.WSDL_NS, Constants.WSDL_SERVICE)).getLength() > 0) {
            for (int i = 0; i < serviceEles.getLength(); ++i) {
                Element service = (Element)serviceEles.item(i);
                NodeList portEles = service.getElementsByTagNameNS(Constants.WSDL_NS, Constants.WSDL_PORT);
                if (portEles.getLength() <= 0) continue;
                for (int j = 0; j < portEles.getLength(); ++j) {
                    Element port = (Element)portEles.item(j);
                    Element address = (Element)port.getElementsByTagNameNS(Constants.NO_NS, Constants.WSDL_ADDRESS).item(0);
                    String location = this.getLocation(address.getAttribute(Constants.WSDL_LOCATION));
                    if (location == null || "".equals(location)) continue;
                    address.setAttribute(Constants.WSDL_LOCATION, location);
                }
            }
        }
        return document;
    }

    private String getLocation(String locationAttr) {
        String host;
        if (!locationAttr.startsWith("http://") && !locationAttr.startsWith("https://")) {
            return null;
        }
        String part = locationAttr.substring(locationAttr.indexOf("://") + 3);
        int idx = part.indexOf(":");
        if (idx != -1) {
            host = part.substring(0, idx);
            String port = part.substring(idx, part.indexOf("/"));
        } else {
            host = part.substring(0, part.indexOf("/"));
        }
        String location = locationAttr.replace(host, this.hostName);
        return location;
    }
}

