/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.ext.cxf.crypto;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.Merlin;
import org.apache.ws.security.components.crypto.X509NameTokenizer;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.security.SecurityConfigException;
import org.wso2.carbon.security.keystore.KeyStoreAdmin;

public class CXFServerCrypto
extends Merlin {
    private static Log log = LogFactory.getLog(CXFServerCrypto.class);
    public static final String PROP_ID_TRUST_STORES = "org.wso2.carbon.security.crypto.truststores";
    public static final String PROP_ID_CERT_PROVIDER = "org.wso2.carbon.security.crypto.cert.provider";
    public static final String PROP_ID_DEFAULT_ALIAS = "org.wso2.carbon.security.crypto.alias";
    public static final String PROP_ID_CACERT_PASS = "org.wso2.carbon.security.crypto.cacert.pass";
    public static final String PROP_ID_XKMS_SERVICE_PASS_PHRASE = "org.wso2.wsas.security.wso2wsas.crypto.xkms.pass";
    public static final String PROP_ID_TENANT_ID = "org.wso2.stratos.tenant.id";
    public static final String PROP_ID_TENANT_DOMAIN = "org.wso2.stratos.tenant.domain";
    public static final String PROP_ID_XKMS_SERVICE_URL = "org.wso2.carbon.security.crypto.xkms.url";
    private static final String SKI_OID = "2.5.29.14";
    private Properties properties;
    private int tenantId;
    private String tenantDomain;
    private KeyStore cacerts;
    private List<KeyStore> trustStores;
    private static CertificateFactory certFact = null;
    private Registry registry;
    private KeyStoreManager keyMan;
    private KeyStoreAdmin keyAdmin;

    public CXFServerCrypto(Properties prop) throws CredentialException, IOException {
        this(prop, CXFServerCrypto.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CXFServerCrypto(Properties prop, ClassLoader loader) throws CredentialException, IOException {
        block11: {
            super(prop);
            this.properties = null;
            this.cacerts = null;
            this.trustStores = new ArrayList<KeyStore>();
            this.registry = null;
            try {
                String tenantIdString = (String)prop.get(PROP_ID_TENANT_ID);
                this.tenantDomain = (String)prop.get(PROP_ID_TENANT_DOMAIN);
                if (tenantIdString == null || tenantIdString.trim().length() == 0) {
                    this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
                    this.tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                }
                this.registry = ((RegistryService)PrivilegedCarbonContext.getThreadLocalCarbonContext().getOSGiService(RegistryService.class)).getGovernanceSystemRegistry(this.tenantId);
                this.keyAdmin = new KeyStoreAdmin(this.tenantId, this.registry);
                this.properties = prop;
                this.keyMan = KeyStoreManager.getInstance((int)this.tenantId);
                this.keystore = this.tenantId == -1234 ? this.keyMan.getPrimaryKeyStore() : this.keyMan.getKeyStore(this.generateKSNameFromDomainName(this.tenantDomain));
                String trustStoreIds = this.properties.getProperty(PROP_ID_TRUST_STORES);
                if (trustStoreIds != null && trustStoreIds.trim().length() != 0) {
                    String[] ids = trustStoreIds.trim().split(",");
                    this.trustStores = new ArrayList<KeyStore>(ids.length);
                    for (int i = 0; i < ids.length; ++i) {
                        String id = ids[i];
                        KeyStore tstks = this.keyMan.getKeyStore(id);
                        this.trustStores.add(i, tstks);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)"error creating CXFServerCryto", (Throwable)e);
                throw new CredentialException(3, "secError00", (Throwable)e);
            }
            String cacertsPath = System.getProperty("java.home") + "/lib/security/cacerts";
            FileInputStream cacertsIs = new FileInputStream(cacertsPath);
            try {
                String cacertsPasswd = this.properties.getProperty(PROP_ID_CACERT_PASS, "changeit");
                this.cacerts = KeyStore.getInstance(KeyStore.getDefaultType());
                this.cacerts.load(cacertsIs, cacertsPasswd.toCharArray());
            }
            catch (GeneralSecurityException e) {
                log.warn((Object)"Unable load to cacerts from the JDK.");
                if (this.trustStores != null && this.trustStores.size() > 0) {
                    this.cacerts = this.trustStores.get(0);
                    break block11;
                }
                throw new CredentialException(3, "secError00", (Throwable)e);
            }
            finally {
                ((InputStream)cacertsIs).close();
            }
        }
    }

    public X509Certificate loadCertificate(InputStream in) throws WSSecurityException {
        X509Certificate cert;
        try {
            cert = (X509Certificate)this.getCertificateFactory().generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError");
        }
        return cert;
    }

    public X509Certificate[] getX509Certificates(byte[] data, boolean reverse) throws WSSecurityException {
        CertPath path;
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            path = this.getCertificateFactory().generateCertPath(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError");
        }
        List<? extends Certificate> l = path.getCertificates();
        X509Certificate[] certs = new X509Certificate[l.size()];
        Iterator<? extends Certificate> iterator = l.iterator();
        for (int i = 0; i < l.size(); ++i) {
            certs[reverse ? l.size() - 1 - i : i] = (X509Certificate)iterator.next();
        }
        return certs;
    }

    public byte[] getCertificateData(boolean reverse, X509Certificate[] certs) throws WSSecurityException {
        Vector<X509Certificate> list = new Vector<X509Certificate>();
        for (int i = 0; i < certs.length; ++i) {
            if (reverse) {
                list.insertElementAt(certs[i], 0);
                continue;
            }
            list.add(certs[i]);
        }
        try {
            CertPath path = this.getCertificateFactory().generateCertPath(list);
            return path.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(7, "encodeError");
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError");
        }
    }

    public X509Certificate[] getCertificates(String alias) throws WSSecurityException {
        Certificate[] certs = new Certificate[]{};
        Certificate cert = null;
        try {
            if (this.keystore != null && ((certs = this.keystore.getCertificateChain(alias)) == null || certs.length == 0)) {
                cert = this.keystore.getCertificate(alias);
            }
            if (certs == null && cert == null && this.trustStores != null) {
                KeyStore store;
                Iterator<KeyStore> trustStoreIter = this.trustStores.iterator();
                while (trustStoreIter.hasNext() && (certs = (store = trustStoreIter.next()).getCertificateChain(alias)) == null) {
                    cert = store.getCertificate(alias);
                }
            }
            if (certs == null && cert == null && this.cacerts != null && ((certs = this.cacerts.getCertificateChain(alias)) == null || certs.length == 0)) {
                cert = this.cacerts.getCertificate(alias);
            }
            if (cert != null) {
                certs = new Certificate[]{cert};
            } else if (certs == null) {
                return null;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        X509Certificate[] x509certs = new X509Certificate[]{};
        if (certs != null) {
            x509certs = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                x509certs[i] = (X509Certificate)certs[i];
            }
        }
        return x509certs;
    }

    public String getAliasForX509Cert(Certificate cert) throws WSSecurityException {
        try {
            KeyStore store;
            Iterator<KeyStore> trustStoreIter;
            String alias = null;
            if (this.keystore != null && (alias = this.keystore.getCertificateAlias(cert)) == null) {
                alias = this.findAliasForCert(this.keystore, cert);
            }
            if (alias == null && this.trustStores != null) {
                trustStoreIter = this.trustStores.iterator();
                while (trustStoreIter.hasNext() && (alias = (store = trustStoreIter.next()).getCertificateAlias(cert)) == null) {
                }
            }
            if (alias == null && this.trustStores != null) {
                trustStoreIter = this.trustStores.iterator();
                while (trustStoreIter.hasNext() && (alias = this.findAliasForCert(store = trustStoreIter.next(), cert)) == null) {
                }
            }
            if (alias == null && this.cacerts != null && (alias = this.cacerts.getCertificateAlias(cert)) == null) {
                alias = this.findAliasForCert(this.cacerts, cert);
            }
            if (alias != null) {
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    private String findAliasForCert(KeyStore ks, Certificate cert) throws KeyStoreException {
        Enumeration<String> e = ks.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            X509Certificate cert2 = (X509Certificate)ks.getCertificate(alias);
            if (!cert2.equals(cert)) continue;
            return alias;
        }
        return null;
    }

    public String getAliasForX509Cert(String issuer) throws WSSecurityException {
        String alias;
        block1: {
            KeyStore ks;
            alias = this.getAliasForX509Cert(issuer, null, false, this.keystore);
            if (alias != null) break block1;
            Iterator<KeyStore> ite = this.trustStores.iterator();
            while (ite.hasNext() && (alias = this.getAliasForX509Cert(issuer, null, false, ks = ite.next())) == null) {
            }
        }
        return alias;
    }

    public String getAliasForX509Cert(String issuer, BigInteger serialNumber) throws WSSecurityException {
        String alias;
        block1: {
            KeyStore ks;
            alias = this.getAliasForX509Cert(issuer, serialNumber, true, this.keystore);
            if (alias != null) break block1;
            Iterator<KeyStore> ite = this.trustStores.iterator();
            while (ite.hasNext() && (alias = this.getAliasForX509Cert(issuer, serialNumber, true, ks = ite.next())) == null) {
            }
        }
        return alias;
    }

    public String getAliasForX509Cert(byte[] skiBytes) throws WSSecurityException {
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                byte[] data;
                String alias = e.nextElement();
                X509Certificate[] certs = this.getCertificates(alias);
                if (certs == null || certs.length == 0) {
                    return null;
                }
                X509Certificate cert = certs[0];
                if (!(cert instanceof X509Certificate) || (data = this.getSKIBytesFromCert(cert)).length != skiBytes.length || !Arrays.equals(data, skiBytes)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    public String getDefaultX509Alias() {
        return this.properties.getProperty(PROP_ID_DEFAULT_ALIAS);
    }

    public byte[] getSKIBytesFromCert(X509Certificate cert) throws WSSecurityException {
        byte[] derEncodedValue = cert.getExtensionValue(SKI_OID);
        if (cert.getVersion() < 3 || derEncodedValue == null) {
            MessageDigest sha;
            PublicKey key = cert.getPublicKey();
            if (!(key instanceof RSAPublicKey)) {
                throw new WSSecurityException(1, "noSKIHandling", new Object[]{"Support for RSA key only"});
            }
            byte[] encoded = key.getEncoded();
            byte[] value = new byte[encoded.length - 22];
            System.arraycopy(encoded, 22, value, 0, value.length);
            try {
                sha = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new WSSecurityException(1, "noSKIHandling", new Object[]{"Wrong certificate version (<3) and no SHA1 message digest availabe"});
            }
            sha.reset();
            sha.update(value);
            return sha.digest();
        }
        byte[] abyte0 = new byte[derEncodedValue.length - 4];
        System.arraycopy(derEncodedValue, 4, abyte0, 0, abyte0.length);
        return abyte0;
    }

    public String getAliasForX509CertThumb(byte[] thumb) throws WSSecurityException {
        MessageDigest sha;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e1) {
            throw new WSSecurityException(0, "noSHA1availabe");
        }
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                X509Certificate[] certs = this.getCertificates(alias);
                if (certs == null || certs.length == 0) {
                    return null;
                }
                X509Certificate cert = certs[0];
                if (!(cert instanceof X509Certificate)) continue;
                sha.reset();
                try {
                    sha.update(cert.getEncoded());
                }
                catch (CertificateEncodingException e1) {
                    throw new WSSecurityException(7, "encodeError");
                }
                byte[] data = sha.digest();
                if (!Arrays.equals(data, thumb)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    public KeyStore getKeyStore() {
        return this.keystore;
    }

    public CertificateFactory getCertificateFactory() throws WSSecurityException {
        if (certFact == null) {
            try {
                String provider = this.properties.getProperty(PROP_ID_CERT_PROVIDER);
                certFact = provider == null || provider.length() == 0 ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", provider);
            }
            catch (CertificateException e) {
                throw new WSSecurityException(7, "unsupportedCertType");
            }
            catch (NoSuchProviderException e) {
                throw new WSSecurityException(7, "noSecProvider");
            }
        }
        return certFact;
    }

    public boolean validateCertPath(X509Certificate[] certs) throws WSSecurityException {
        boolean result = this.validateCertPath(this.keystore, certs);
        if (!result) {
            Iterator<KeyStore> trustStoreIter = this.trustStores.iterator();
            while (!result) {
                result = this.validateCertPath(trustStoreIter.next(), certs);
            }
        }
        if (!result && this.cacerts != null) {
            result = this.validateCertPath(this.cacerts, certs);
        }
        return result;
    }

    public String[] getAliasesForDN(String subjectDN) throws WSSecurityException {
        Vector<String> aliases = new Vector<String>();
        Vector subjectRDN = this.splitAndTrim(subjectDN);
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                Vector foundRDN;
                String alias = e.nextElement();
                X509Certificate[] certs = this.getCertificates(alias);
                if (certs == null || certs.length == 0) {
                    return null;
                }
                X509Certificate cert = certs[0];
                if (!(cert instanceof X509Certificate) || !subjectRDN.equals(foundRDN = this.splitAndTrim(cert.getSubjectDN().getName()))) continue;
                aliases.add(alias);
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        String[] result = new String[aliases.size()];
        for (int i = 0; i < aliases.size(); ++i) {
            result[i] = (String)aliases.elementAt(i);
        }
        return result;
    }

    private String getAliasForX509Cert(String issuer, BigInteger serialNumber, boolean useSerialNumber, KeyStore ks) throws WSSecurityException {
        Vector issuerRDN = this.splitAndTrim(issuer);
        try {
            Enumeration<String> e = ks.aliases();
            while (e.hasMoreElements()) {
                Vector certRDN;
                String alias = e.nextElement();
                X509Certificate[] certs = this.getCertificates(alias);
                if (certs == null || certs.length == 0) {
                    return null;
                }
                X509Certificate cert = certs[0];
                if (!(cert instanceof X509Certificate)) continue;
                X509Certificate x509cert = cert;
                if (!useSerialNumber || x509cert.getSerialNumber().compareTo(serialNumber) != 0 || !(certRDN = this.splitAndTrim(x509cert.getIssuerDN().getName())).equals(issuerRDN)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    private Vector splitAndTrim(String inString) {
        X509NameTokenizer nmTokens = new X509NameTokenizer(inString);
        Vector<String> vr = new Vector<String>();
        while (nmTokens.hasMoreTokens()) {
            vr.add(nmTokens.nextToken());
        }
        Collections.sort(vr);
        return vr;
    }

    private boolean validateCertPath(KeyStore ks, Certificate[] certs) throws WSSecurityException {
        try {
            List<Certificate> certList = Arrays.asList(certs);
            CertPath path = this.getCertificateFactory().generateCertPath(certList);
            PKIXParameters param = new PKIXParameters(ks);
            param.setRevocationEnabled(false);
            String provider = this.properties.getProperty("org.apache.ws.security.crypto.merlin.cert.provider");
            CertPathValidator certPathValidator = provider == null || provider.length() == 0 ? CertPathValidator.getInstance("PKIX") : CertPathValidator.getInstance("PKIX", provider);
            certPathValidator.validate(path, param);
        }
        catch (NoSuchProviderException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        catch (CertificateException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        catch (CertPathValidatorException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        catch (KeyStoreException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        return true;
    }

    private String getKeyStoreType(String ksId) throws Exception {
        String path = "/repository/security/key-stores/" + ksId;
        Resource resource = this.registry.get(path);
        return resource.getProperty("type");
    }

    private String getKeyStoreProvider(String ksId) throws Exception {
        String path = "/repository/security/key-stores/" + ksId;
        Resource resource = this.registry.get(path);
        return resource.getProperty("provider");
    }

    private String generateKSNameFromDomainName(String tenantDomain) {
        String ksName = tenantDomain.trim().replace(".", "-");
        return ksName + ".jks";
    }

    private String getIdentifier(X509Certificate cert, KeyStore store) throws WSSecurityException {
        try {
            Enumeration<String> e = store.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate[] certs = store.getCertificateChain(alias);
                Certificate retrievedCert = null;
                if (certs == null || certs.length == 0) {
                    retrievedCert = store.getCertificate(alias);
                    if (retrievedCert == null) {
                        continue;
                    }
                } else {
                    retrievedCert = certs[0];
                }
                if (!(retrievedCert instanceof X509Certificate) || !retrievedCert.equals(cert)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore", null, (Throwable)e);
        }
        return null;
    }

    private String createKeyStoreErrorMessage(KeyStore keystore) throws KeyStoreException {
        Enumeration<String> aliases = keystore.aliases();
        StringBuilder sb = new StringBuilder(keystore.size() * 7);
        boolean firstAlias = true;
        while (aliases.hasMoreElements()) {
            if (!firstAlias) {
                sb.append(", ");
            }
            sb.append(aliases.nextElement());
            firstAlias = false;
        }
        String msg = " in keystore of type [" + keystore.getType() + "] from provider [" + keystore.getProvider() + "] with size [" + keystore.size() + "] and aliases: {" + sb.toString() + "}";
        return msg;
    }

    public PrivateKey getPrivateKey(String identifier, String password) throws WSSecurityException {
        Key keyTmp = null;
        try {
            if (identifier == null || !this.keystore.isKeyEntry(identifier)) {
                String msg = "Cannot find key for alias: [" + identifier + "]";
                String logMsg = this.createKeyStoreErrorMessage(this.keystore);
                log.error((Object)(msg + logMsg));
                throw new WSSecurityException(msg);
            }
            keyTmp = this.tenantId != -1234 ? this.keyMan.getPrivateKey(this.generateKSNameFromDomainName(this.tenantDomain), identifier) : this.keyAdmin.getPrivateKey(identifier, true);
        }
        catch (SecurityConfigException ex) {
            throw new WSSecurityException(0, "noPrivateKey", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        catch (KeyStoreException ex) {
            throw new WSSecurityException(0, "noPrivateKey", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        return (PrivateKey)keyTmp;
    }

    public PrivateKey getPrivateKey(X509Certificate certificate, CallbackHandler callbackHandler) throws WSSecurityException {
        if (this.keystore == null) {
            throw new WSSecurityException("The keystore is null");
        }
        String identifier = this.getIdentifier(certificate, this.keystore);
        PrivateKey keyTmp = null;
        try {
            keyTmp = this.getPrivateKey(identifier, null);
            return keyTmp;
        }
        catch (Exception ex) {
            throw new WSSecurityException(0, "noPrivateKey", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
    }
}

