/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.ext.cxf.lifecycle;

import java.io.File;
import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.webapp.ext.cxf.Constants;
import org.wso2.carbon.webapp.ext.cxf.lifecycle.CarbonConfiguration;

public class CarbonConfigurationFactory {
    private static CarbonConfiguration carbonConfiguration = null;

    public static CarbonConfiguration getCurrentCarbonConfiguration() {
        if (carbonConfiguration == null) {
            try {
                CarbonConfigurationFactory.initCarbonConfiguration();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return carbonConfiguration;
    }

    private static void initCarbonConfiguration() throws Exception {
        String carbonHome = System.getProperty(Constants.CARBON_CONFIG_DIR_PATH);
        if (carbonHome != null) {
            String expression;
            File carbonXml = new File(carbonHome, Constants.CARBON_CONFIG_FILE_NAME);
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(new FileInputStream(carbonXml));
            carbonConfiguration = new CarbonConfiguration();
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.compile(expression = Constants.CARBON_HOSTNAME_ENTRY_XPATH).evaluate(xmlDocument, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                Element hostName = (Element)nodeList.item(0);
                carbonConfiguration.getParameters().put(Constants.CARBON_HOSTNAME_PARAMETER, hostName.getTextContent());
            }
        }
    }
}

