/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.notifier;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.deployment.engine.Artifact;
import org.wso2.carbon.deployment.engine.DeploymentConfigurationProvider;
import org.wso2.carbon.deployment.engine.LifecycleEvent;
import org.wso2.carbon.deployment.engine.LifecycleListener;
import org.wso2.carbon.deployment.engine.config.DeploymentNotifierConfig;
import org.wso2.carbon.deployment.notifier.internal.DataHolder;
import org.wso2.carbon.deployment.notifier.internal.DeploymentNotificationMessage;
import org.wso2.carbon.deployment.notifier.internal.JMSConnectionFactory;

public class DeploymentNotifierLifecycleListener
implements LifecycleListener {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentNotifierLifecycleListener.class);
    private Optional<JMSConnectionFactory> jmsConnectionFactory = Optional.empty();
    private DeploymentNotifierConfig config = DeploymentConfigurationProvider.getDeploymentConfiguration().getDeploymentNotifier();
    String serverId = DataHolder.getInstance().getCarbonRuntime().getConfiguration().getId();

    public DeploymentNotifierLifecycleListener() {
        if (this.config.isJmsPublishingEnabled()) {
            this.jmsConnectionFactory = Optional.of(this.getConnectionFactory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lifecycleEvent(LifecycleEvent event) {
        if (!this.config.isJmsPublishingEnabled()) {
            return;
        }
        JMSConnectionFactory.JMSPooledConnectionHolder pooledConnectionHolder = null;
        try {
            logger.debug("Invoked DeploymentNotifierLifecycleListener");
            if (LifecycleEvent.STATE.AFTER_START_EVENT.equals((Object)event.getState()) || LifecycleEvent.STATE.AFTER_UPDATE_EVENT.equals((Object)event.getState())) {
                String deploymentStatusMessage = this.createDeploymentStatusMessage(event);
                pooledConnectionHolder = this.jmsConnectionFactory.get().getConnectionFromPool();
                MessageProducer producer = pooledConnectionHolder.getProducer();
                Session session = pooledConnectionHolder.getSession();
                TextMessage jmsMessage = session.createTextMessage(deploymentStatusMessage);
                producer.send((Message)jmsMessage);
            }
            if (pooledConnectionHolder != null) {
                this.jmsConnectionFactory.get().returnPooledConnection(pooledConnectionHolder);
            }
        }
        catch (JMSException | JAXBException e) {
            logger.error("Error while publishing deployment status via JMS.", e);
        }
        finally {
            if (pooledConnectionHolder != null) {
                this.jmsConnectionFactory.get().returnPooledConnection(pooledConnectionHolder);
            }
        }
    }

    private String createDeploymentStatusMessage(LifecycleEvent event) throws JAXBException {
        Artifact artifact = event.getArtifact();
        DeploymentNotificationMessage message = new DeploymentNotificationMessage(artifact, event.getTimestamp());
        message.setArtifactKey(artifact.getKey());
        message.setArtifactType(artifact.getType().get().toString());
        message.setLifecycleState(event.getState());
        message.setCurrentDeploymentResult(event.getDeploymentResult());
        message.setServerId(this.serverId);
        message.setTraceContent(event.getTraceContent());
        event.getProperties().putAll((Map<?, ?>)this.config.getStaticMessageContent());
        message.setProperties(event.getProperties());
        return this.convertToXml(message, DeploymentNotificationMessage.class);
    }

    private JMSConnectionFactory getConnectionFactory() {
        DeploymentNotifierConfig config = DeploymentConfigurationProvider.getDeploymentConfiguration().getDeploymentNotifier();
        String destinationJNDIName = config.getDestinationJNDIName();
        String destinationType = config.getDestinationType();
        String javaNamingProviderUrl = config.getJavaNamingProviderURL();
        String javaNamingFactoryInitial = config.getJavaNamingFactoryInitial();
        String connectionFactoryJNDIName = config.getConnectionFactoryJNDIName();
        Optional username = config.getJmsUsername();
        Optional password = config.getJmsPassword();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("java.naming.factory.initial", javaNamingFactoryInitial);
        properties.put("java.naming.provider.url", javaNamingProviderUrl);
        properties.put("destinationJNDIName", destinationJNDIName);
        properties.put("destinationType", destinationType);
        properties.put("connectionFactoryJNDIName", connectionFactoryJNDIName);
        if (username.isPresent() && password.isPresent()) {
            properties.put("jmsUserName", (String)username.get());
            properties.put("jmsPassword", (String)password.get());
        }
        return new JMSConnectionFactory(properties, connectionFactoryJNDIName, destinationJNDIName);
    }

    public String convertToXml(Object source, Class ... type) throws JAXBException {
        StringWriter sw = new StringWriter();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])type);
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.marshal(source, (Writer)sw);
        String result = sw.toString();
        return result;
    }
}

