/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.notifier.internal;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSUtils {
    private static final Log log = LogFactory.getLog(JMSUtils.class);

    public static <T> T lookup(Context context, Class<T> clazz, String name) throws NamingException {
        Object object = context.lookup(name);
        try {
            return clazz.cast(object);
        }
        catch (ClassCastException ex) {
            if (object instanceof Reference) {
                Reference ref = (Reference)object;
                throw new NamingException("JNDI failed to de-reference Reference with name " + name + "; is the factory " + ref.getFactoryClassName() + " in your classpath?");
            }
            throw new NamingException("JNDI lookup of name " + name + " returned a " + object.getClass().getName() + " while a " + clazz + " was expected");
        }
    }

    public static Destination lookupDestination(Context context, String destinationName, String destinationType) throws NamingException {
        try {
            return JMSUtils.lookup(context, Destination.class, destinationName);
        }
        catch (NameNotFoundException e) {
            Properties initialContextProperties = new Properties();
            if (context.getEnvironment() != null) {
                if (context.getEnvironment().get("java.naming.factory.initial") != null) {
                    initialContextProperties.put("java.naming.factory.initial", context.getEnvironment().get("java.naming.factory.initial"));
                }
                if (context.getEnvironment().get("java.naming.provider.url") != null) {
                    initialContextProperties.put("java.naming.provider.url", context.getEnvironment().get("java.naming.provider.url"));
                }
            }
            if ("topic".equalsIgnoreCase(destinationType)) {
                initialContextProperties.put("topic." + destinationName, destinationName);
            } else {
                initialContextProperties.put("queue." + destinationName, destinationName);
            }
            InitialContext initialContext = new InitialContext(initialContextProperties);
            try {
                return JMSUtils.lookup(initialContext, Destination.class, destinationName);
            }
            catch (NamingException e1) {
                return JMSUtils.lookup(context, Destination.class, ("topic".equalsIgnoreCase(destinationType) ? "dynamicTopics/" : "dynamicQueues/") + destinationName);
            }
        }
    }

    public static Session createSession(Connection connection, boolean transacted, int ackMode, boolean jmsSpec11, Boolean isQueue) throws JMSException {
        if (jmsSpec11 || isQueue == null) {
            return connection.createSession(transacted, ackMode);
        }
        if (isQueue.booleanValue()) {
            return ((QueueConnection)connection).createQueueSession(transacted, ackMode);
        }
        return ((TopicConnection)connection).createTopicSession(transacted, ackMode);
    }

    public static Connection createConnection(ConnectionFactory conFac, String user, String pass, boolean jmsSpec11, Boolean isQueue, boolean isDurable, String clientID) throws JMSException {
        Connection connection = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating a " + (isQueue != false ? "Queue" : "Topic") + "Connection using credentials : (" + user + "/" + pass + ")"));
        }
        if (jmsSpec11 || isQueue == null) {
            connection = user != null && pass != null ? conFac.createConnection(user, pass) : conFac.createConnection();
            if (isDurable) {
                connection.setClientID(clientID);
            }
        } else {
            QueueConnectionFactory qConFac = null;
            TopicConnectionFactory tConFac = null;
            if (isQueue.booleanValue()) {
                qConFac = (QueueConnectionFactory)conFac;
            } else {
                tConFac = (TopicConnectionFactory)conFac;
            }
            if (user != null && pass != null) {
                if (qConFac != null) {
                    connection = qConFac.createQueueConnection(user, pass);
                } else if (tConFac != null) {
                    connection = tConFac.createTopicConnection(user, pass);
                }
            } else if (qConFac != null) {
                connection = qConFac.createQueueConnection();
            } else if (tConFac != null) {
                connection = tConFac.createTopicConnection();
            }
            if (isDurable) {
                connection.setClientID(clientID);
            }
        }
        return connection;
    }

    public static MessageProducer createProducer(Session session, Destination destination, Boolean isQueue, boolean jmsSpec11) throws JMSException {
        if (jmsSpec11 || isQueue == null) {
            return session.createProducer(destination);
        }
        if (isQueue.booleanValue()) {
            return ((QueueSession)session).createSender((Queue)destination);
        }
        return ((TopicSession)session).createPublisher((Topic)destination);
    }
}

