/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.notifier.internal;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.deployment.engine.LifecycleListener;
import org.wso2.carbon.deployment.notifier.DeploymentNotifierLifecycleListener;
import org.wso2.carbon.deployment.notifier.internal.DataHolder;
import org.wso2.carbon.kernel.CarbonRuntime;

@Component(name="DeploymentNotifierListenerComponent", immediate=true)
public class DeploymentNotifierListenerComponent {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentNotifierListenerComponent.class);

    @Activate
    public void start(BundleContext bundleContext) throws Exception {
        DeploymentNotifierLifecycleListener deploymentCoordinationLifecycleListener = new DeploymentNotifierLifecycleListener();
        bundleContext.registerService(LifecycleListener.class, (Object)deploymentCoordinationLifecycleListener, null);
        logger.debug("Registered DeploymentNotifierLifecycleListener.");
    }

    @Deactivate
    public void stop() throws Exception {
    }

    @Reference(name="carbon.runtime.service", service=CarbonRuntime.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterCarbonRuntime")
    protected void registerCarbonRuntime(CarbonRuntime carbonRuntime) {
        DataHolder.getInstance().setCarbonRuntime(carbonRuntime);
    }

    protected void unregisterCarbonRuntime(CarbonRuntime carbonRuntime) {
        DataHolder.getInstance().setCarbonRuntime(null);
    }

    @Reference(name="carbon.config.provider", service=ConfigProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterConfigProvider")
    protected void registerConfigProvider(ConfigProvider configProvider) {
        DataHolder.getInstance().setConfigProvider(configProvider);
    }

    protected void unregisterConfigProvider(ConfigProvider configProvider) {
        DataHolder.getInstance().setConfigProvider(null);
    }
}

