/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.notifier.internal;

import java.util.Date;
import java.util.Optional;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.wso2.carbon.deployment.engine.Artifact;
import org.wso2.carbon.deployment.engine.LifecycleEvent;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DeploymentNotificationMessage {
    @XmlElement
    private Object artifactKey;
    @XmlElement
    private String artifactType;
    @XmlElement
    private String serverId;
    @XmlElement
    private Date timestamp;
    @XmlElement
    private LifecycleEvent.RESULT currentDeploymentResult;
    @XmlElement
    private LifecycleEvent.STATE lifecycleState;
    @XmlElement
    private String message;
    @XmlElement
    public Properties properties;

    public DeploymentNotificationMessage(Artifact artifact) {
        this(artifact, null);
    }

    public DeploymentNotificationMessage() {
    }

    public DeploymentNotificationMessage(Artifact artifact, Date timestamp) {
        this.artifactKey = artifact.getKey();
        this.artifactType = artifact.getType().get().toString();
        this.timestamp = Optional.ofNullable(timestamp).map(tstamp -> new Date(timestamp.getTime())).orElse(new Date());
    }

    public Object getArtifactKey() {
        return this.artifactKey;
    }

    public void setArtifactKey(Object artifactKey) {
        this.artifactKey = artifactKey;
    }

    public String getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(String artifactType) {
        this.artifactType = artifactType;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String host) {
        this.serverId = host;
    }

    public Date getTimestamp() {
        return new Date(this.timestamp.getTime());
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = new Date(timestamp.getTime());
    }

    public LifecycleEvent.STATE getLifecycleState() {
        return this.lifecycleState;
    }

    public void setLifecycleState(LifecycleEvent.STATE lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    public LifecycleEvent.RESULT getCurrentDeploymentResult() {
        return this.currentDeploymentResult;
    }

    public void setCurrentDeploymentResult(LifecycleEvent.RESULT currentDeploymentResult) {
        this.currentDeploymentResult = currentDeploymentResult;
    }

    public String getMessage() {
        return this.message;
    }

    public void setTraceContent(String message) {
        this.message = message;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String toString() {
        return String.format("%1$s - %2$s - %3$s ", this.artifactKey, this.artifactType, this.lifecycleState);
    }
}

