/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.discovery.cxf.listeners;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scannotation.AnnotationDB;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.discovery.DiscoveryException;
import org.wso2.carbon.discovery.cxf.CXFServiceInfo;
import org.wso2.carbon.discovery.cxf.CxfMessageSender;
import org.wso2.carbon.discovery.cxf.util.ClassAnnotationScanner;
import org.xml.sax.SAXException;

public class TomcatCxfDiscoveryListener
implements LifecycleListener {
    private static final String cxfServletClass = "org.apache.cxf.transport.servlet.CXFServlet";
    private static final String httpPort = "mgt.transport.http.port";
    private static final String httpsPort = "mgt.transport.https.port";
    private static final String hostName = "carbon.local.ip";
    private CxfMessageSender cxfMessageSender = new CxfMessageSender();
    private static final Log log = LogFactory.getLog(TomcatCxfDiscoveryListener.class);

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        try {
            String type = lifecycleEvent.getType();
            if ("after_start".equals(type) || "before_stop".equals(type)) {
                StandardContext context = (StandardContext)lifecycleEvent.getLifecycle();
                String jaxServletMapping = null;
                boolean isJaxWebapp = false;
                Map servletRegs = context.getServletContext().getServletRegistrations();
                for (ServletRegistration servletReg : servletRegs.values()) {
                    if (!cxfServletClass.equals(servletReg.getClassName())) continue;
                    Object[] mappings = servletReg.getMappings().toArray();
                    jaxServletMapping = mappings.length > 0 ? this.getServletContextPath((String)mappings[0]) : null;
                    isJaxWebapp = true;
                    break;
                }
                if (isJaxWebapp) {
                    CXFServiceInfo serviceBean = this.getServiceInfo(context, jaxServletMapping);
                    if (serviceBean == null) {
                        return;
                    }
                    if ("after_start".equals(type)) {
                        this.cxfMessageSender.sendHello(serviceBean, null);
                    } else if ("before_stop".equals(type)) {
                        this.cxfMessageSender.sendBye(serviceBean, null);
                    }
                }
            }
        }
        catch (DiscoveryException e) {
            log.warn((Object)"Error while publishing the services to the discovery service ", (Throwable)e);
        }
        catch (Throwable e) {
            log.warn((Object)"Error while publishing the services to the discovery service ", e);
        }
    }

    private String getServletContextPath(String jaxServletPattern) {
        if (!"".equals(jaxServletPattern) && jaxServletPattern != null) {
            if (jaxServletPattern.endsWith("/*")) {
                jaxServletPattern = jaxServletPattern.substring(0, jaxServletPattern.length() - 2);
            }
            if (jaxServletPattern.startsWith("/")) {
                jaxServletPattern = jaxServletPattern.substring(1);
            }
        } else {
            jaxServletPattern = "services";
        }
        return jaxServletPattern;
    }

    private CXFServiceInfo getServiceInfo(StandardContext context, String jaxServletMapping) throws DiscoveryException {
        CXFServiceInfo serviceInfo = new CXFServiceInfo();
        String contextPath = context.getServletContext().getContextPath();
        contextPath = contextPath.startsWith("/") ? contextPath.substring(1, contextPath.length()) : contextPath;
        serviceInfo.setServiceName(contextPath);
        serviceInfo.setType(this.getPortType(context));
        serviceInfo.setTenantDomain(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true));
        ArrayList<String> endpoints = new ArrayList<String>(5);
        try {
            String cxfEndpoint;
            Node node;
            int i;
            InputStream configStream = this.getConfigLocation(context.getServletContext());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder b = dbf.newDocumentBuilder();
            Document doc = b.parse(configStream);
            NodeList endpointElements = doc.getElementsByTagNameNS("http://cxf.apache.org/jaxws", "endpoint");
            NodeList serverElements = doc.getElementsByTagNameNS("http://cxf.apache.org/jaxws", "server");
            for (i = 0; i < endpointElements.getLength(); ++i) {
                node = endpointElements.item(i);
                if (!(node instanceof Element)) continue;
                Element endpointElement = (Element)node;
                cxfEndpoint = endpointElement.getAttribute("address");
                endpoints.add(cxfEndpoint);
            }
            for (i = 0; i < serverElements.getLength(); ++i) {
                node = serverElements.item(i);
                if (!(node instanceof Element)) continue;
                Element serverElement = (Element)node;
                cxfEndpoint = serverElement.getAttribute("address");
                endpoints.add(cxfEndpoint);
            }
        }
        catch (ParserConfigurationException e) {
            log.error((Object)("Error processing CXF config file of " + contextPath), (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)("Error processing CXF config file of " + contextPath), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error processing CXF config file of " + contextPath), (Throwable)e);
        }
        if (endpoints.isEmpty()) {
            return null;
        }
        serviceInfo.setWsdlURI(this.getWsdlUri(context, jaxServletMapping, endpoints));
        serviceInfo.setxAddrs(this.getxAddrs(context, jaxServletMapping, endpoints));
        return serviceInfo;
    }

    private QName getPortType(StandardContext context) throws DiscoveryException {
        QName seiInfo = null;
        try {
            AnnotationDB annotations = ClassAnnotationScanner.getAnnotatedClasses(context);
            Set set = (Set)annotations.getAnnotationIndex().get(WebService.class.getName());
            annotations.crossReferenceImplementedInterfaces();
            if (set == null || set.isEmpty()) {
                return null;
            }
            for (String clazzName : set) {
                Class<?> clazz = context.getServletContext().getClassLoader().loadClass(clazzName);
                if (clazz.isInterface()) continue;
                seiInfo = this.processClazz(clazz, context);
                break;
            }
        }
        catch (AnnotationDB.CrossReferenceException e) {
            throw new DiscoveryException(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new DiscoveryException(e.getMessage(), (Throwable)e);
        }
        return seiInfo;
    }

    private QName processClazz(Class<?> clazz, StandardContext context) throws DiscoveryException, ClassNotFoundException {
        Class<?> endpointInterface;
        WebService jwsAnnotation = clazz.getAnnotation(WebService.class);
        String targetNamespace = jwsAnnotation.targetNamespace();
        String name = jwsAnnotation.name();
        String endpointInterfaceName = jwsAnnotation.endpointInterface();
        if (endpointInterfaceName != null && !endpointInterfaceName.trim().isEmpty()) {
            endpointInterface = context.getServletContext().getClassLoader().loadClass(endpointInterfaceName);
        } else {
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces.length > 0) {
                endpointInterface = interfaces[0];
            } else {
                String msg = "The endpointInterfaceName is not defined and the resource class does not implement one - " + clazz.getName();
                log.error((Object)msg);
                throw new DiscoveryException(msg);
            }
        }
        WebService eiJwsAnnotation = endpointInterface.getAnnotation(WebService.class);
        if (targetNamespace == null || targetNamespace.trim().isEmpty()) {
            targetNamespace = eiJwsAnnotation.targetNamespace();
        }
        if (name == null || name.trim().isEmpty()) {
            name = eiJwsAnnotation.name();
        }
        if (targetNamespace == null || targetNamespace.trim().isEmpty()) {
            targetNamespace = this.generateTargetNsFromInterfaceName(endpointInterface.getName());
        }
        if (name == null || name.trim().isEmpty()) {
            String tmpInterfaceName = endpointInterface.getName();
            name = tmpInterfaceName.substring(tmpInterfaceName.lastIndexOf(46) + 1);
        }
        return new QName(targetNamespace, name);
    }

    private String generateTargetNsFromInterfaceName(String sei) {
        String[] arr = sei.substring(0, sei.lastIndexOf(46)).split("\\.");
        StringBuilder sb = new StringBuilder();
        sb.append("http://");
        for (int i = arr.length - 1; i >= 0; --i) {
            sb.append(arr[i]).append(".");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("/");
        return sb.toString();
    }

    private String getWsdlUri(StandardContext context, String jaxServletMapping, List<String> endpoints) {
        String wsdlEndpoint = "http://" + System.getProperty(hostName) + ":" + System.getProperty(httpPort) + context.getServletContext().getContextPath() + "/" + jaxServletMapping + endpoints.get(0) + "?wsdl";
        return wsdlEndpoint;
    }

    private List getxAddrs(StandardContext context, String jaxServletMapping, List<String> endpoints) {
        ArrayList<String> xAddrs = new ArrayList<String>();
        String httpEndpoint = "http://" + System.getProperty(hostName) + ":" + System.getProperty(httpPort) + context.getServletContext().getContextPath() + "/" + jaxServletMapping + endpoints.get(0);
        String httpsEndpoint = "https://" + System.getProperty(hostName) + ":" + System.getProperty(httpsPort) + context.getServletContext().getContextPath() + "/" + jaxServletMapping + endpoints.get(0);
        xAddrs.add(httpEndpoint);
        xAddrs.add(httpsEndpoint);
        return xAddrs;
    }

    private InputStream getConfigLocation(ServletContext context) {
        String configLocation = context.getInitParameter("config-location");
        if (configLocation == null) {
            try {
                InputStream is = context.getResourceAsStream("/WEB-INF/cxf-servlet.xml");
                if (is != null && is.available() > 0) {
                    is.close();
                    configLocation = "/WEB-INF/cxf-servlet.xml";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return context.getResourceAsStream(configLocation);
    }
}

