/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.discovery.cxf.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.discovery.cxf.internal.CxfDiscoveryDataHolder;
import org.wso2.carbon.utils.ConfigurationContextService;

public class CxfDiscoveryServiceComponent {
    private static final Log log = LogFactory.getLog(CxfDiscoveryServiceComponent.class);
    private ServiceRegistration observerServiceRegistration;
    private CxfDiscoveryDataHolder dataHolder = CxfDiscoveryDataHolder.getInstance();

    protected void activate(ComponentContext ctx) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Activating CXF WS-Discovery Startup Publisher Component");
        }
    }

    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deactivating CXF WS-Discovery component");
        }
        if (this.observerServiceRegistration != null) {
            this.observerServiceRegistration.unregister();
            this.observerServiceRegistration = null;
        }
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        this.dataHolder.setMainServerConfigContext(contextService.getServerConfigContext());
        this.dataHolder.setClientConfigurationContext(contextService.getClientConfigContext());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        this.dataHolder.setMainServerConfigContext(null);
        this.dataHolder.setClientConfigurationContext(null);
    }
}

