/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.discovery.cxf;

import java.net.ConnectException;
import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.discovery.DiscoveryException;
import org.wso2.carbon.discovery.DiscoveryOMUtils;
import org.wso2.carbon.discovery.config.Config;
import org.wso2.carbon.discovery.cxf.CXFServiceInfo;
import org.wso2.carbon.discovery.cxf.internal.CxfDiscoveryDataHolder;
import org.wso2.carbon.discovery.messages.Notification;
import org.wso2.carbon.discovery.messages.TargetService;
import org.wso2.carbon.discovery.util.DiscoveryMgtUtils;
import org.wso2.carbon.registry.core.Registry;

public class CxfMessageSender {
    private static final Log log = LogFactory.getLog(CxfMessageSender.class);

    public void sendHello(CXFServiceInfo serviceBean, Config config) throws DiscoveryException {
        this.sendNotification(serviceBean, config, 0);
    }

    public void sendBye(CXFServiceInfo serviceBean, Config config) throws DiscoveryException {
        this.sendNotification(serviceBean, config, 1);
    }

    private void sendNotification(CXFServiceInfo serviceBean, Config config, int notificationType) throws DiscoveryException {
        AxisConfiguration axisConfig = this.getAxisConfig();
        if (axisConfig == null) {
            CxfDiscoveryDataHolder.getInstance().getInitialMessagesList().add(serviceBean);
            return;
        }
        Parameter discoveryProxyParam = DiscoveryMgtUtils.getDiscoveryParam((AxisConfiguration)axisConfig);
        if (discoveryProxyParam == null) {
            return;
        }
        String discoveryEPR = (String)discoveryProxyParam.getValue();
        try {
            ServiceClient serviceClient = this.initServiceClient(discoveryEPR, notificationType, axisConfig);
            String uniqueID = this.getServerID(serviceBean, config);
            EndpointReference endpointReference = new EndpointReference(uniqueID);
            TargetService targetService = new TargetService(endpointReference);
            targetService.setTypes(new QName[]{serviceBean.getType()});
            URI[] scopes = new URI[config.getScopes().size()];
            for (int i = 0; i < config.getScopes().size(); ++i) {
                scopes[i] = new URI((String)config.getScopes().get(i));
            }
            targetService.setScopes(scopes);
            Object[] eprs = serviceBean.getxAddrs().toArray();
            URI[] xAddres = new URI[eprs.length];
            for (int i = 0; i < eprs.length; ++i) {
                String epr = (String)eprs[i];
                if (epr.endsWith("/")) {
                    epr = epr.substring(0, epr.length() - 1);
                }
                xAddres[i] = new URI(epr);
            }
            targetService.setXAddresses(xAddres);
            targetService.setMetadataVersion(config.getMetadataVersion());
            if (notificationType == 0) {
                serviceClient.addStringHeader(new QName("http://www.wso2.org/ws/discovery", "serviceName", "mns"), serviceBean.getServiceName());
                serviceClient.addStringHeader(new QName("http://www.wso2.org/ws/discovery", "wsdlURI", "mns"), serviceBean.getWsdlURI());
            }
            Notification notification = new Notification(notificationType, targetService);
            serviceClient.fireAndForget(DiscoveryOMUtils.toOM((Notification)notification, (OMFactory)OMAbstractFactory.getOMFactory()));
            serviceClient.cleanup();
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                log.error((Object)("Error while connecting to Discovery Service. Connection Refused - " + discoveryEPR));
            }
            throw new DiscoveryException("Error while sending the WS-Discovery notification for the service " + serviceBean.getServiceName(), (Throwable)e);
        }
    }

    private String getServerID(CXFServiceInfo serviceBean, Config config) throws Exception {
        String uniqueID = config.getUniqueId();
        if (uniqueID == null) {
            Registry registry = (Registry)PrivilegedCarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_CONFIGURATION);
            uniqueID = DiscoveryMgtUtils.getExistingServiceIdOrUpdate((String)this.getNameForService(serviceBean.getServiceName()), (String)UIDGenerator.generateURNString(), (org.wso2.carbon.registry.api.Registry)registry);
        }
        return uniqueID;
    }

    private String getNameForService(String serviceName) {
        return serviceName.replace("/", "");
    }

    private ServiceClient initServiceClient(String epr, int notificationType, AxisConfiguration axisConf) throws Exception {
        ConfigurationContext cfgCtx = CxfDiscoveryDataHolder.getInstance().getClientConfigurationContext();
        ServiceClient serviceClient = new ServiceClient(cfgCtx, null);
        serviceClient.setTargetEPR(new EndpointReference(epr));
        if (notificationType == 0) {
            serviceClient.getOptions().setAction("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Hello");
        } else {
            serviceClient.getOptions().setAction("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Bye");
        }
        serviceClient.engageModule("addressing");
        Registry registry = (Registry)PrivilegedCarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_CONFIGURATION);
        Policy policy = DiscoveryMgtUtils.getClientSecurityPolicy((org.wso2.carbon.registry.api.Registry)registry);
        if (policy != null) {
            serviceClient.engageModule("rampart");
            serviceClient.getOptions().setProperty("rampartPolicy", (Object)policy);
        }
        return serviceClient;
    }

    private AxisConfiguration getAxisConfig() {
        AxisConfiguration axisConfig;
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        ConfigurationContext mainConfigContext = this.getMainConfigurationContext();
        if (mainConfigContext == null) {
            return null;
        }
        if (tenantId == -1234) {
            axisConfig = mainConfigContext.getAxisConfiguration();
        } else {
            Map tenantConfigContexts = TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)this.getMainConfigurationContext());
            ConfigurationContext tenantConfigCtx = (ConfigurationContext)tenantConfigContexts.get(tenantDomain);
            if (tenantConfigCtx == null) {
                return null;
            }
            axisConfig = tenantConfigCtx.getAxisConfiguration();
        }
        return axisConfig;
    }

    private ConfigurationContext getMainConfigurationContext() {
        ConfigurationContext cc = CxfDiscoveryDataHolder.getInstance().getMainServerConfigContext();
        if (cc != null) {
            return cc;
        }
        return null;
    }
}

