/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.discovery.cxf.listeners;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.OMNamespaceImpl;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.discovery.DiscoveryException;
import org.wso2.carbon.discovery.config.Config;
import org.wso2.carbon.discovery.cxf.CXFServiceInfo;
import org.wso2.carbon.discovery.cxf.CxfMessageSender;
import org.wso2.carbon.discovery.cxf.internal.CxfDiscoveryDataHolder;
import org.wso2.carbon.utils.CarbonUtils;

public class TomcatCxfDiscoveryListener
implements LifecycleListener {
    private static final String CXF_SERVLET_CLASS = "org.apache.cxf.transport.servlet.CXFServlet";
    private static final String HTTP_PORT = "http";
    private static final String HTTPS_PORT = "https";
    private static final String HOST_NAME_ = "HostName";
    private static final String HOST_NAME_LOCAL = "carbon.local.ip";
    private static final String JAX_WS_PREFIX = "jaxws";
    private static final String JAX_RS_PREFIX = "jaxrs";
    private static final String JAX_WS_NAMESPACE_URI = "http://cxf.apache.org/jaxws";
    private static final String JAX_RS_NAMESPACE_URI = "http://cxf.apache.org/jaxrs";
    private CxfMessageSender cxfMessageSender = new CxfMessageSender();
    private Config config = new Config();
    private static final Log log = LogFactory.getLog(TomcatCxfDiscoveryListener.class);

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        try {
            String type = lifecycleEvent.getType();
            if ("after_start".equals(type) || "before_stop".equals(type)) {
                StandardContext context = (StandardContext)lifecycleEvent.getLifecycle();
                String jaxServletMapping = null;
                boolean isJaxWebapp = false;
                Map servletRegs = context.getServletContext().getServletRegistrations();
                for (ServletRegistration servletReg : servletRegs.values()) {
                    if (!CXF_SERVLET_CLASS.equals(servletReg.getClassName())) continue;
                    Object[] mappings = servletReg.getMappings().toArray();
                    jaxServletMapping = mappings.length > 0 ? this.getServletContextPath((String)mappings[0]) : null;
                    isJaxWebapp = true;
                    break;
                }
                if (isJaxWebapp) {
                    this.addConfigData(context.getServletContext());
                    for (CXFServiceInfo serviceBean : this.getServiceInfo(context, jaxServletMapping)) {
                        if (serviceBean == null) {
                            return;
                        }
                        if ("after_start".equals(type)) {
                            this.cxfMessageSender.sendHello(serviceBean, this.config);
                            continue;
                        }
                        if (!"before_stop".equals(type)) continue;
                        this.cxfMessageSender.sendBye(serviceBean, this.config);
                    }
                }
            }
        }
        catch (DiscoveryException e) {
            log.error((Object)"Error while publishing the services to the discovery service ", (Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)"Error while publishing the services to the discovery service ", e);
        }
    }

    private String getServletContextPath(String jaxServletPattern) {
        if (!"".equals(jaxServletPattern) && jaxServletPattern != null) {
            if (jaxServletPattern.endsWith("/*")) {
                jaxServletPattern = jaxServletPattern.substring(0, jaxServletPattern.length() - 2);
            }
            if (jaxServletPattern.startsWith("/")) {
                jaxServletPattern = jaxServletPattern.substring(1);
            }
        } else {
            jaxServletPattern = "services";
        }
        return jaxServletPattern;
    }

    private List<CXFServiceInfo> getServiceInfo(StandardContext context, String jaxServletMapping) throws DiscoveryException {
        String contextPath = context.getServletContext().getContextPath();
        contextPath = contextPath.startsWith("/") ? contextPath.substring(1, contextPath.length()) : contextPath;
        try {
            InputStream configStream = this.getConfigLocation(context.getServletContext());
            StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(configStream);
            OMElement documentElement = stAXOMBuilder.getDocumentElement(true);
            Iterator declaredNamespaces = documentElement.getAllDeclaredNamespaces();
            while (declaredNamespaces.hasNext()) {
                OMNamespaceImpl nameSpace = (OMNamespaceImpl)declaredNamespaces.next();
                if (JAX_WS_PREFIX.equals(nameSpace.getPrefix()) && JAX_WS_NAMESPACE_URI.equals(nameSpace.getNamespaceURI())) {
                    return this.getJaxWsServiceInfo(documentElement, context, jaxServletMapping, contextPath);
                }
                if (!JAX_RS_PREFIX.equals(nameSpace.getPrefix()) || !JAX_RS_NAMESPACE_URI.equals(nameSpace.getNamespaceURI())) continue;
                return this.getJaxRsServiceInfo(documentElement, context, jaxServletMapping, contextPath);
            }
        }
        catch (XMLStreamException e) {
            log.error((Object)("Error processing CXF config file of " + contextPath), (Throwable)e);
        }
        return new ArrayList<CXFServiceInfo>();
    }

    private List<CXFServiceInfo> getJaxRsServiceInfo(OMElement documentElement, StandardContext context, String jaxServletMapping, String contextPath) throws DiscoveryException {
        ArrayList<CXFServiceInfo> serviceInfoList = new ArrayList<CXFServiceInfo>();
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
        QName serverQName = new QName(JAX_RS_NAMESPACE_URI, "server");
        Iterator services = documentElement.getChildrenWithName(serverQName);
        while (services.hasNext()) {
            OMElement server = (OMElement)services.next();
            String endpoint = server.getAttributeValue(new QName("address"));
            String serviceBean = server.getFirstChildWithName(new QName(JAX_RS_NAMESPACE_URI, "serviceBeans")).getFirstElement().getAttributeValue(new QName("bean"));
            String endpointInterface = "";
            Iterator beanList = documentElement.getChildrenWithName(new QName("bean"));
            while (beanList.hasNext()) {
                OMElement bean = (OMElement)beanList.next();
                if (!serviceBean.equals(bean.getAttributeValue(new QName("id")))) continue;
                endpointInterface = bean.getAttributeValue(new QName("class"));
                break;
            }
            CXFServiceInfo serviceInfo = new CXFServiceInfo();
            serviceInfo.setServiceName(contextPath + "_" + endpoint.substring(1));
            serviceInfo.setType(this.getType(endpointInterface));
            serviceInfo.setTenantDomain(tenantDomain);
            serviceInfo.setWsdlURI(this.getWadlUri(context, jaxServletMapping, endpoint));
            serviceInfo.setxAddrs(this.getXAddrsList(context, jaxServletMapping, endpoint));
            serviceInfoList.add(serviceInfo);
        }
        return serviceInfoList;
    }

    private List<CXFServiceInfo> getJaxWsServiceInfo(OMElement documentElement, StandardContext context, String jaxServletMapping, String contextPath) throws DiscoveryException {
        ArrayList<CXFServiceInfo> serviceInfoList = new ArrayList<CXFServiceInfo>();
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
        QName serviceType = new QName(JAX_WS_NAMESPACE_URI, "server");
        Iterator services = documentElement.getChildrenWithName(serviceType);
        while (services.hasNext()) {
            OMElement server = (OMElement)services.next();
            String endpoint = server.getAttributeValue(new QName("address"));
            String endpointInterface = server.getFirstChildWithName(new QName(JAX_WS_NAMESPACE_URI, "serviceBean")).getFirstElement().getAttributeValue(new QName("class"));
            CXFServiceInfo serviceInfo = new CXFServiceInfo();
            serviceInfo.setServiceName(contextPath + "_" + endpoint.substring(1));
            serviceInfo.setType(this.getPortType(context, endpointInterface));
            serviceInfo.setTenantDomain(tenantDomain);
            serviceInfo.setWsdlURI(this.getWsdlUri(context, jaxServletMapping, endpoint));
            serviceInfo.setxAddrs(this.getXAddrsList(context, jaxServletMapping, endpoint));
            serviceInfoList.add(serviceInfo);
        }
        return serviceInfoList;
    }

    private QName getType(String serviceEndpointInterface) {
        String targetNamespace = this.generateTargetNsFromInterfaceName(serviceEndpointInterface);
        String name = serviceEndpointInterface.substring(serviceEndpointInterface.lastIndexOf(46) + 1);
        return new QName(targetNamespace, name);
    }

    private QName getPortType(StandardContext context, String serviceEndpoint) throws DiscoveryException {
        QName seiInfo;
        try {
            Class<?> clazz = context.getServletContext().getClassLoader().loadClass(serviceEndpoint);
            seiInfo = this.processClazz(clazz, context);
        }
        catch (ClassNotFoundException e) {
            throw new DiscoveryException(e.getMessage(), (Throwable)e);
        }
        return seiInfo;
    }

    private QName processClazz(Class<?> clazz, StandardContext context) throws DiscoveryException, ClassNotFoundException {
        Class<?> endpointInterface;
        WebService jwsAnnotation = clazz.getAnnotation(WebService.class);
        String targetNamespace = jwsAnnotation.targetNamespace();
        String name = jwsAnnotation.name();
        String endpointInterfaceName = jwsAnnotation.endpointInterface();
        if (endpointInterfaceName != null && !endpointInterfaceName.trim().isEmpty()) {
            endpointInterface = context.getServletContext().getClassLoader().loadClass(endpointInterfaceName);
        } else {
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces.length > 0) {
                endpointInterface = interfaces[0];
            } else {
                if (targetNamespace == null || targetNamespace.trim().isEmpty()) {
                    targetNamespace = this.generateTargetNsFromInterfaceName(clazz.getName());
                }
                if (name == null || name.trim().isEmpty()) {
                    String tmpInterfaceName = clazz.getName();
                    name = tmpInterfaceName.substring(tmpInterfaceName.lastIndexOf(46) + 1);
                }
                return new QName(targetNamespace, name);
            }
        }
        WebService eiJwsAnnotation = endpointInterface.getAnnotation(WebService.class);
        if (targetNamespace == null || targetNamespace.trim().isEmpty()) {
            targetNamespace = eiJwsAnnotation.targetNamespace();
        }
        if (name == null || name.trim().isEmpty()) {
            name = eiJwsAnnotation.name();
        }
        if (targetNamespace == null || targetNamespace.trim().isEmpty()) {
            targetNamespace = this.generateTargetNsFromInterfaceName(endpointInterface.getName());
        }
        if (name == null || name.trim().isEmpty()) {
            String tmpInterfaceName = endpointInterface.getName();
            name = tmpInterfaceName.substring(tmpInterfaceName.lastIndexOf(46) + 1);
        }
        return new QName(targetNamespace, name);
    }

    private String generateTargetNsFromInterfaceName(String sei) {
        String[] arr = sei.substring(0, sei.lastIndexOf(46)).split("\\.");
        StringBuilder sb = new StringBuilder();
        sb.append("http://");
        for (int i = arr.length - 1; i >= 0; --i) {
            sb.append(arr[i]).append(".");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("/");
        return sb.toString();
    }

    private String getWsdlUri(StandardContext context, String jaxServletMapping, String endpoint) {
        return "http://" + this.getHostname() + ":" + this.getPortForTransport(HTTP_PORT) + context.getServletContext().getContextPath() + "/" + jaxServletMapping + endpoint + "?wsdl";
    }

    private String getWadlUri(StandardContext context, String jaxServletMapping, String endpoint) {
        if (jaxServletMapping.isEmpty()) {
            return "http://" + this.getHostname() + ":" + this.getPortForTransport(HTTP_PORT) + context.getServletContext().getContextPath() + endpoint + "?_wadl";
        }
        return "http://" + this.getHostname() + ":" + this.getPortForTransport(HTTP_PORT) + context.getServletContext().getContextPath() + "/" + jaxServletMapping + endpoint + "?_wadl";
    }

    private String getHostname() {
        ServerConfigurationService serverConfigurationService = CxfDiscoveryDataHolder.getInstance().getServerConfigurationService();
        if (serverConfigurationService.getFirstProperty(HOST_NAME_) != null) {
            return serverConfigurationService.getFirstProperty(HOST_NAME_);
        }
        return System.getProperty(HOST_NAME_LOCAL);
    }

    private List getXAddrsList(StandardContext context, String jaxServletMapping, String endpoint) {
        ArrayList<String> xAddrs = new ArrayList<String>();
        String httpEndpoint = "http://" + this.getHostname() + ":" + this.getPortForTransport(HTTP_PORT) + context.getServletContext().getContextPath() + "/" + jaxServletMapping + endpoint;
        String httpsEndpoint = "https://" + this.getHostname() + ":" + this.getPortForTransport(HTTPS_PORT) + context.getServletContext().getContextPath() + "/" + jaxServletMapping + endpoint;
        xAddrs.add(httpEndpoint);
        xAddrs.add(httpsEndpoint);
        return xAddrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getConfigLocation(ServletContext context) {
        String configLocation = context.getInitParameter("config-location");
        if (configLocation == null) {
            InputStream is = null;
            try {
                is = context.getResourceAsStream("/WEB-INF/cxf-servlet.xml");
                if (is != null && is.available() > 0) {
                    configLocation = "/WEB-INF/cxf-servlet.xml";
                }
            }
            catch (IOException ex) {
                String message = "Configuration location not available for " + context.getContextPath();
                log.error((Object)message, (Throwable)ex);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return context.getResourceAsStream(configLocation);
    }

    private void addScopes(String scopesString) {
        if (scopesString != null && !scopesString.isEmpty()) {
            String[] scopeNames;
            for (String scope : scopeNames = scopesString.split(" ")) {
                this.config.addScope(scope);
            }
        } else {
            this.config.addScope("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/DefaultScope");
        }
    }

    private void addMetadataVersion(String metaDataVersion) {
        if (metaDataVersion != null && !metaDataVersion.isEmpty()) {
            this.config.setMetadataVersion(Integer.parseInt(metaDataVersion));
        } else {
            this.config.setMetadataVersion(1);
        }
    }

    private void addConfigData(ServletContext servletContext) {
        this.addScopes(servletContext.getInitParameter("Scopes"));
        this.addMetadataVersion(servletContext.getInitParameter("MetadataVersion"));
    }

    private int getPortForTransport(String transport) {
        return CarbonUtils.getTransportPort((ConfigurationContext)CxfDiscoveryDataHolder.getInstance().getMainServerConfigContext(), (String)transport);
    }
}

