/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.jarservices;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.jarservices.DuplicateServiceException;
import org.wso2.carbon.jarservices.DuplicateServiceGroupException;
import org.wso2.carbon.jarservices.JarUploadException;
import org.wso2.carbon.jarservices.Operation;
import org.wso2.carbon.jarservices.Resource;
import org.wso2.carbon.jarservices.Service;
import org.wso2.carbon.jarservices.UploadArtifactsResponse;
import org.wso2.carbon.utils.ArchiveManipulator;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.FileManipulator;

public class JarServiceCreatorAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(JarServiceCreatorAdmin.class);
    public static BundleContext bundleContext;

    public UploadArtifactsResponse upload(String serviceGroupName, Resource wsdl, Resource[] resources) throws DuplicateServiceGroupException, JarUploadException {
        AxisConfiguration axisConfig = this.getAxisConfig();
        AxisServiceGroup serviceGroup = axisConfig.getServiceGroup(serviceGroupName);
        if (serviceGroup != null) {
            String msg = "Service group " + serviceGroupName + " already exists";
            log.error((Object)msg);
            throw new DuplicateServiceGroupException(msg);
        }
        String repo = axisConfig.getRepository().getPath();
        if (CarbonUtils.isURL((String)repo)) {
            throw new JarUploadException("Uploading services to URL repo is not supported ");
        }
        String tempDir = this.getTempDir();
        String libDir = tempDir + File.separator + "lib";
        new File(libDir).mkdirs();
        ArrayList<Service> services = new ArrayList<Service>();
        try {
            for (int i = 0; i < resources.length; ++i) {
                Resource resource = resources[i];
                this.writeToFileSystem(libDir, resource.getFileName(), resource.getDataHandler());
                services.addAll(this.getClasses(libDir + File.separator + resource.getFileName()));
            }
            if (wsdl != null) {
                String metaInfDir = tempDir + File.separator + "META-INF";
                new File(metaInfDir).mkdirs();
                this.writeToFileSystem(metaInfDir, wsdl.getFileName(), wsdl.getDataHandler());
            }
        }
        catch (IOException e) {
            String msg = "Error occured while uploading jar service ";
            log.error((Object)msg, (Throwable)e);
            throw new JarUploadException(msg, e);
        }
        UploadArtifactsResponse response = new UploadArtifactsResponse();
        response.setResourcesDirPath(tempDir);
        response.setWsdlProvided(wsdl != null);
        Collections.sort(services, new Comparator<Service>(){

            @Override
            public int compare(Service o1, Service o2) {
                return o1.getClassName().compareTo(o2.getClassName());
            }
        });
        response.setServices(services.toArray(new Service[services.size()]));
        return response;
    }

    private String getTempDir() {
        String workDir = (String)MessageContext.getCurrentMessageContext().getProperty("WORK_DIR");
        String tempDir = workDir + File.separator + ((double)System.currentTimeMillis() + Math.random());
        return tempDir;
    }

    private List<Service> getClasses(String filePath) throws AxisFault {
        ArrayList<Service> services = new ArrayList<Service>();
        if (filePath != null) {
            try {
                String[] entries = new ArchiveManipulator().check(filePath);
                for (int i = 0; i < entries.length; ++i) {
                    String serviceName;
                    String entry = entries[i];
                    if (!entry.endsWith(".class")) continue;
                    entry = entry.replace('/', '.').substring(0, entry.lastIndexOf(".class"));
                    Service service = new Service();
                    service.setClassName(entry);
                    AxisConfiguration axisConfig = this.getAxisConfig();
                    String newServiceName = serviceName = entry.substring(entry.lastIndexOf(".") + 1);
                    int x = 1;
                    while (axisConfig.getService(newServiceName) != null) {
                        newServiceName = serviceName + x;
                        ++x;
                    }
                    service.setServiceName(newServiceName);
                    services.add(service);
                }
            }
            catch (IOException e) {
                String msg = "Could not read archive";
                log.error((Object)msg, (Throwable)e);
                throw new AxisFault(msg, (Throwable)e);
            }
        }
        return services;
    }

    public Service[] getClassMethods(String directoryPath, Service[] services) throws AxisFault, DuplicateServiceException {
        File[] files;
        if (services == null || services.length == 0) {
            String msg = "Cannot find services";
            log.error((Object)msg);
            throw new AxisFault(msg);
        }
        ArrayList<String> methodExcludeList = new ArrayList<String>();
        methodExcludeList.add("hashCode");
        methodExcludeList.add("getClass");
        methodExcludeList.add("equals");
        methodExcludeList.add("notify");
        methodExcludeList.add("notifyAll");
        methodExcludeList.add("toString");
        methodExcludeList.add("wait");
        ArrayList<URL> resourcesList = new ArrayList<URL>();
        for (File file : files = new File(directoryPath + File.separator + "lib").listFiles()) {
            try {
                resourcesList.add(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        AxisConfiguration axisConfig = this.getAxisConfig();
        URL[] urls = resourcesList.toArray(new URL[resourcesList.size()]);
        URLClassLoader classLoader = URLClassLoader.newInstance(urls, axisConfig.getServiceClassLoader());
        for (int i = 0; i < services.length; ++i) {
            Service service = services[i];
            String className = service.getClassName();
            if (axisConfig.getService(service.getServiceName()) != null) {
                String msg = "Axis service " + service.getServiceName() + " already exists";
                log.warn((Object)msg);
                throw new DuplicateServiceException(msg);
            }
            try {
                Class<?> clazz = classLoader.loadClass(className);
                Method[] methods = clazz.getMethods();
                ArrayList<Operation> operationList = new ArrayList<Operation>();
                for (int j = 0; j < methods.length; ++j) {
                    Method method = methods[j];
                    String methodName = method.getName();
                    int modifiers = method.getModifiers();
                    if (!Modifier.isPublic(modifiers) || methodExcludeList.contains(methodName)) continue;
                    Operation operation = new Operation();
                    operation.setOperationName(methodName);
                    operationList.add(operation);
                }
                this.findOverloadedMethods(operationList);
                service.setOperations(operationList.toArray(new Operation[operationList.size()]));
                continue;
            }
            catch (ClassNotFoundException e) {
                String msg = "The class " + className + " cannot be loaded";
                log.error((Object)msg);
            }
        }
        return services;
    }

    private void findOverloadedMethods(List methodList) {
        HashMap finalMap = new HashMap();
        int size = methodList.size();
        for (int k = 0; k < size - 1; ++k) {
            Operation startPointer = (Operation)methodList.get(k);
            if (finalMap.containsKey(startPointer.getOperationName())) continue;
            int count = 0;
            for (Operation operation : methodList) {
                if (!operation.getOperationName().equals(startPointer.getOperationName())) continue;
                ++count;
            }
            for (Operation operation : methodList) {
                if (!operation.getOperationName().equals(startPointer.getOperationName()) || count <= 1) continue;
                operation.setOverloaded(true);
            }
        }
    }

    public void createAndDeployService(String directoryPath, String serviceHierarchy, String serviceGroupName, Service[] data) throws AxisFault, DuplicateServiceException, DuplicateServiceGroupException {
        AxisConfiguration axisConfig = this.getAxisConfig();
        if (serviceGroupName == null || serviceGroupName.trim().length() == 0) {
            serviceGroupName = String.valueOf((double)System.currentTimeMillis() + Math.random());
        } else if (axisConfig.getServiceGroup(serviceGroupName) != null) {
            String msg = "Service group " + serviceGroupName + " already exists";
            log.error((Object)msg);
            throw new DuplicateServiceGroupException(msg);
        }
        File file = new File(directoryPath + File.separator + "META-INF" + File.separator + "services.xml");
        file.mkdirs();
        try {
            File absoluteFile = file.getAbsoluteFile();
            if (absoluteFile.exists()) {
                absoluteFile.delete();
            }
            absoluteFile.createNewFile();
            FileOutputStream os = new FileOutputStream(file);
            OMElement servicesXML = this.createServicesXML(data);
            servicesXML.build();
            servicesXML.serialize((OutputStream)os);
        }
        catch (DuplicateServiceException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Cannot write services XML";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        String tempDir = this.getTempDir();
        new File(tempDir).mkdirs();
        String outAARFilename = tempDir + File.separator + serviceGroupName + ".aar";
        try {
            ArchiveManipulator archiveManipulator = new ArchiveManipulator();
            archiveManipulator.archiveDir(outAARFilename, directoryPath);
        }
        catch (IOException e) {
            String msg = "Cannot create new AAR archive";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        String servicesDir = axisConfig.getParameter("ServicesDirectory").getValue().toString();
        String destDir = axisConfig.getRepository().getPath() + File.separator + servicesDir;
        if (serviceHierarchy != null) {
            String[] hierarchyParts;
            for (String part : hierarchyParts = serviceHierarchy.split("/")) {
                File hierarchyFolder = new File(destDir = destDir + File.separator + part);
                if (hierarchyFolder.exists()) continue;
                hierarchyFolder.mkdir();
            }
        }
        try {
            String fileName = serviceGroupName + ".aar";
            File aarInRepo = new File(destDir + File.separator + fileName);
            FileManipulator.copyFile((File)new File(outAARFilename), (File)aarInRepo);
        }
        catch (Exception e) {
            String msg = "Cannot copy AAR file to Repo";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    private String prepareHierarchy(String serviceHierarchy) {
        if (serviceHierarchy.startsWith("/")) {
            serviceHierarchy = serviceHierarchy.substring(1);
        }
        if (serviceHierarchy.endsWith("/")) {
            serviceHierarchy = serviceHierarchy.substring(0, serviceHierarchy.length() - 1);
        }
        return serviceHierarchy;
    }

    private OMElement createServicesXML(Service[] services) throws DuplicateServiceException {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace emptyNS = factory.createOMNamespace("", "");
        OMElement serviceGroupEle = factory.createOMElement("serviceGroup", "", "");
        for (int i = 0; i < services.length; ++i) {
            Service service = services[i];
            String serviceClass = service.getClassName();
            String serviceName = service.getServiceName();
            AxisConfiguration axisConfig = this.getAxisConfig();
            try {
                if (axisConfig.getService(serviceName) != null) {
                    String msg = "An Axis2 service  with name " + serviceName + " already exists";
                    log.warn((Object)msg);
                    throw new DuplicateServiceException(msg);
                }
            }
            catch (AxisFault msg) {
                // empty catch block
            }
            OMElement serviceEle = factory.createOMElement("service", "", "");
            OMElement schemaEle = factory.createOMElement("schema", "", "");
            schemaEle.addAttribute(factory.createOMAttribute("elementFormDefaultQualified", emptyNS, "true"));
            serviceEle.addAttribute(factory.createOMAttribute("name", emptyNS, serviceName));
            serviceEle.addAttribute(factory.createOMAttribute("scope", emptyNS, service.getDeploymentScope()));
            OMElement msgReceiversEle = factory.createOMElement("messageReceivers", "", "");
            OMElement msgReceiverEle1 = factory.createOMElement("messageReceiver", "", "");
            msgReceiverEle1.addAttribute("mep", "http://www.w3.org/ns/wsdl/in-only", emptyNS);
            msgReceiverEle1.addAttribute("class", "org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver", emptyNS);
            OMElement msgReceiverEle2 = factory.createOMElement("messageReceiver", "", "");
            msgReceiverEle2.addAttribute("mep", "http://www.w3.org/ns/wsdl/in-out", emptyNS);
            msgReceiverEle2.addAttribute("class", "org.apache.axis2.rpc.receivers.RPCMessageReceiver", emptyNS);
            msgReceiversEle.addChild((OMNode)msgReceiverEle1);
            msgReceiversEle.addChild((OMNode)msgReceiverEle2);
            OMElement parameterEle = factory.createOMElement("parameter", "", "");
            parameterEle.addAttribute("name", "ServiceClass", emptyNS);
            parameterEle.setText(serviceClass);
            OMElement serviceTypeParamEle = factory.createOMElement("parameter", "", "");
            serviceTypeParamEle.addAttribute("name", "serviceType", emptyNS);
            serviceTypeParamEle.setText("jarservice");
            if (service.isUseOriginalWsdl()) {
                OMElement useOriginalWsdlParamEle = factory.createOMElement("parameter", "", "");
                useOriginalWsdlParamEle.addAttribute("name", "useOriginalwsdl", emptyNS);
                useOriginalWsdlParamEle.setText("true");
                serviceEle.addChild((OMNode)useOriginalWsdlParamEle);
                OMElement modifyUserWSDLPortAddressParamEle = factory.createOMElement("parameter", "", "");
                modifyUserWSDLPortAddressParamEle.addAttribute("name", "modifyUserWSDLPortAddress", emptyNS);
                modifyUserWSDLPortAddressParamEle.setText("true");
                serviceEle.addChild((OMNode)modifyUserWSDLPortAddressParamEle);
            }
            serviceEle.addChild((OMNode)schemaEle);
            serviceEle.addChild((OMNode)msgReceiversEle);
            serviceEle.addChild((OMNode)parameterEle);
            serviceEle.addChild((OMNode)serviceTypeParamEle);
            Operation[] operation = service.getOperations();
            if (operation != null && operation.length > 0) {
                OMElement excludesEle = factory.createOMElement("excludeOperations", "", "");
                serviceEle.addChild((OMNode)excludesEle);
                ArrayList<String> operationDuplicationList = new ArrayList<String>();
                for (int j = 0; j < operation.length; ++j) {
                    String methodName = operation[j].getOperationName();
                    if (operationDuplicationList.contains(methodName)) continue;
                    OMElement operationEle = factory.createOMElement("operation", "", "");
                    operationDuplicationList.add(methodName);
                    operationEle.setText(methodName);
                    excludesEle.addChild((OMNode)operationEle);
                }
            }
            serviceGroupEle.addChild((OMNode)serviceEle);
        }
        return serviceGroupEle;
    }

    private void writeToFileSystem(String path, String fileName, DataHandler dataHandler) throws IOException {
        File destFile = new File(path, fileName);
        FileOutputStream fos = new FileOutputStream(destFile);
        dataHandler.writeTo((OutputStream)fos);
        fos.flush();
        fos.close();
    }
}

