/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.jarservices.ui.fileupload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.jarservices.stub.DuplicateServiceGroupExceptionException;
import org.wso2.carbon.jarservices.stub.JarUploadExceptionException;
import org.wso2.carbon.jarservices.stub.types.Resource;
import org.wso2.carbon.jarservices.stub.types.UploadArtifactsResponse;
import org.wso2.carbon.jarservices.ui.fileupload.JarServiceAdminClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class JarFileUploadExecutor
extends AbstractFileUploadExecutor {
    private static final String[] RESOURCE_FILE_EXTENSIONS = new String[]{".jar"};
    private static final String[] WSDL_FILE_EXTENSIONS = new String[]{".wsdl"};

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        Map formFieldsMap = this.getFormFieldsMap();
        String serviceGroupName = (String)((ArrayList)formFieldsMap.get("serviceGroupName")).get(0);
        String serviceHierarchy = (String)((ArrayList)formFieldsMap.get("serviceHierarchy")).get(0);
        request.getSession().setAttribute("serviceGroupName", (Object)serviceGroupName);
        request.getSession().setAttribute("serviceHierarchy", (Object)serviceHierarchy);
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        Map fileItemsMap = this.getFileItemsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            String msg = "File upload failed. No files are specified";
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/jarservices/index.jsp"));
        }
        try {
            JarServiceAdminClient jarServiceAdminClient = new JarServiceAdminClient(this.configurationContext, serverURL, cookie);
            ArrayList<Resource> resources = new ArrayList<Resource>();
            Resource wsdl = null;
            for (Object o : fileItemsMap.keySet()) {
                String fieldName = (String)o;
                List fileItemDatas = (List)fileItemsMap.get(fieldName);
                for (FileItemData fileItemData : fileItemDatas) {
                    String fileName = this.getFileName(fileItemData.getFileItem().getName());
                    if (fieldName.equals("resourceFileName")) {
                        this.checkServiceFileExtensionValidity(fileName, RESOURCE_FILE_EXTENSIONS);
                        Resource resource = new Resource();
                        resource.setDataHandler(fileItemData.getDataHandler());
                        resource.setFileName(fileName);
                        resources.add(resource);
                        continue;
                    }
                    if (!fieldName.equals("wsdlFileName")) continue;
                    this.checkServiceFileExtensionValidity(fileName, WSDL_FILE_EXTENSIONS);
                    wsdl = new Resource();
                    wsdl.setDataHandler(fileItemData.getDataHandler());
                    wsdl.setFileName(fileName);
                }
            }
            UploadArtifactsResponse uploadResponse = jarServiceAdminClient.upload(serviceGroupName, wsdl, resources.toArray(new Resource[resources.size()]));
            request.getSession().setAttribute("UploadArtifactsResponse", (Object)uploadResponse);
            response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/jarservices/list_classes.jsp");
            return true;
        }
        catch (JarUploadExceptionException e) {
            this.handleException(request, response, "error", webContext, "Error occurred while uploading resource. " + e.getFaultMessage().getJarUploadException().getMessage(), (Exception)((Object)e));
        }
        catch (DuplicateServiceGroupExceptionException e) {
            this.handleException(request, response, "warning", webContext, "Service group " + serviceGroupName + " already exists. ", (Exception)((Object)e));
        }
        catch (Exception e) {
            this.handleException(request, response, "error", webContext, "File upload failed. " + e.getMessage(), e);
        }
        return false;
    }

    private void handleException(HttpServletRequest request, HttpServletResponse response, String msgStatus, String webContext, String msg, Exception e) throws IOException {
        log.error((Object)msg, (Throwable)e);
        CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)msgStatus, (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/jarservices/index.jsp"));
    }
}

