/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.javaee.tomee;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.TreeSet;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomee.catalina.ContextListener;
import org.apache.tomee.catalina.GlobalListenerSupport;
import org.wso2.carbon.javaee.tomee.ASTomEEServerListener;
import org.wso2.carbon.webapp.mgt.loader.ClassloadingContextBuilder;
import org.wso2.carbon.webapp.mgt.loader.WebappClassloadingContext;

public class ASGlobalListenerSupport
extends GlobalListenerSupport {
    private static final Log log = LogFactory.getLog((String)ASTomEEServerListener.class.getName());
    public static final String JAVA_EE_CRE = "JavaEE";
    public static final String JAVA_EE_OLD_CRE = "J2EE";
    public static final String IS_JAVA_EE_APP = "IS_JAVA_EE_APP";

    public ASGlobalListenerSupport(StandardServer standardServer, ContextListener contextListener) {
        super(standardServer, contextListener);
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            Object source = event.getSource();
            if (source instanceof StandardContext) {
                StandardContext standardContext = (StandardContext)source;
                Boolean isJavaEEApp = (Boolean)standardContext.getServletContext().getAttribute(IS_JAVA_EE_APP);
                if (isJavaEEApp == null) {
                    isJavaEEApp = this.isJavaEEApp(standardContext);
                    standardContext.getServletContext().setAttribute(IS_JAVA_EE_APP, (Object)isJavaEEApp);
                }
                if (!isJavaEEApp.booleanValue()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("JavaEE CRE was not found for this webapp - " + ((StandardContext)source).getName() + ". Not continuing the OpenEJB container initialization."));
                    }
                    return;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not determine the Classloader Runtime Environment. Not continuing the OpenEJB container initialization." + e.getMessage()), (Throwable)e);
            return;
        }
        super.lifecycleEvent(event);
    }

    private boolean isJavaEEApp(StandardContext standardContext) throws Exception {
        WebappClassloadingContext clContext = ClassloadingContextBuilder.buildClassloadingContext((String)this.getWebappFilePath(standardContext));
        String[] webappCREs = clContext.getEnvironments();
        if (webappCREs != null) {
            TreeSet<String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            set.addAll(Arrays.asList(webappCREs));
            return set.contains(JAVA_EE_CRE) || set.contains(JAVA_EE_OLD_CRE);
        }
        String[] defaultCREs = ClassloadingContextBuilder.buildSystemConfig().getEnvironments();
        TreeSet<String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        set.addAll(Arrays.asList(defaultCREs));
        return set.contains(JAVA_EE_CRE) || set.contains(JAVA_EE_OLD_CRE);
    }

    private String getWebappFilePath(StandardContext ctx) throws IOException {
        String webappFilePath = null;
        String docBase = ctx.getDocBase();
        Host host = (Host)ctx.getParent();
        String appBase = host.getAppBase();
        File canonicalAppBase = new File(appBase);
        canonicalAppBase = canonicalAppBase.isAbsolute() ? canonicalAppBase.getCanonicalFile() : new File(System.getProperty("carbon.home"), appBase).getCanonicalFile();
        File webappFile = new File(docBase);
        webappFilePath = webappFile.isAbsolute() ? webappFile.getCanonicalPath() : new File(canonicalAppBase, docBase).getPath();
        return webappFilePath;
    }
}

