/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.javaee.tomee;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.util.ServerInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.JuliLogStreamFactory;
import org.apache.openejb.util.OpenEjbVersion;
import org.apache.tomee.catalina.ServerListener;
import org.apache.tomee.loader.TomcatHelper;
import org.wso2.carbon.javaee.tomee.ASTomcatLoader;

public class ASTomEEServerListener
extends ServerListener {
    private static final Log log = LogFactory.getLog((String)ASTomEEServerListener.class.getName());
    private static boolean listenerInstalled;

    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_init".equals(event.getType()) && StandardServer.class.isInstance(event.getSource())) {
            this.installServerInfo();
        }
        if (listenerInstalled || !"after_init".equals(event.getType())) {
            return;
        }
        if (!(event.getSource() instanceof StandardServer)) {
            return;
        }
        try {
            StandardServer server = (StandardServer)event.getSource();
            TomcatHelper.setServer((StandardServer)server);
            Properties properties = new Properties();
            System.getProperties().setProperty("openejb.embedder.source", ((Object)((Object)this)).getClass().getSimpleName());
            properties.setProperty("openejb.embedder.source", ((Object)((Object)this)).getClass().getSimpleName());
            if (SystemInstance.isInitialized()) {
                return;
            }
            properties.setProperty("tomee.webapp.classloader.enrichment.skip", "true");
            properties.setProperty("openejb.loader", "tomcat-system");
            properties.setProperty("openejb.system.apps", "false");
            String catalinaHome = System.getProperty("catalina.base");
            properties.setProperty("openejb.home", catalinaHome);
            System.setProperty("openejb.home", catalinaHome);
            String catalinaBase = System.getProperty("catalina.base");
            properties.setProperty("openejb.base", catalinaBase);
            System.setProperty("openejb.base", catalinaBase);
            try {
                String serverBuilt;
                String serverInfo;
                ClassLoader classLoader = ServerListener.class.getClassLoader();
                Properties tomcatServerInfo = IO.readProperties((InputStream)classLoader.getResourceAsStream("org/apache/catalina/util/ServerInfo.properties"), (Properties)new Properties());
                String serverNumber = tomcatServerInfo.getProperty("server.number");
                if (serverNumber == null && (serverInfo = tomcatServerInfo.getProperty("server.info")) != null) {
                    int slash = serverInfo.indexOf(47);
                    serverNumber = serverInfo.substring(slash + 1);
                }
                if (serverNumber != null) {
                    System.setProperty("tomcat.version", serverNumber);
                }
                if ((serverBuilt = tomcatServerInfo.getProperty("server.built")) != null) {
                    System.setProperty("tomcat.built", serverBuilt);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                ProvisioningUtil.addAdditionalLibraries();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.setServiceManager(properties);
            this.setOpenJPALogFactory();
            this.readSystemPropertiesConf();
            ASTomcatLoader loader = new ASTomcatLoader();
            loader.init(properties);
            listenerInstalled = true;
        }
        catch (Exception e) {
            log.error((Object)"TomEE Listener can't start OpenEJB", (Throwable)e);
        }
    }

    protected void setOpenJPALogFactory() {
        try {
            JuliLogStreamFactory.class.getClassLoader().loadClass("org.wso2.carbon.javaee.tomee.openjpa.JULOpenJPALogFactory");
            System.setProperty("openjpa.Log", "org.wso2.carbon.javaee.tomee.openjpa.JULOpenJPALogFactory");
        }
        catch (Exception ignored) {
            log.debug((Object)ignored.getMessage(), (Throwable)ignored);
        }
    }

    protected void setServiceManager(Properties properties) {
        properties.put("openejb.service.manager.class", "org.wso2.carbon.javaee.tomee.osgi.ASServiceManagerExtender");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installServerInfo() {
        String value = ServerInfo.getServerInfo();
        Field field = null;
        boolean acc = true;
        try {
            field = ServerInfo.class.getDeclaredField("serverInfo");
            acc = field.isAccessible();
            int slash = value.indexOf(47);
            field.setAccessible(true);
            String version = OpenEjbVersion.get().getVersion();
            String tomeeVersion = Integer.parseInt("" + version.charAt(0)) - 3 + version.substring(1, version.length());
            field.set(null, value.substring(0, slash) + " (TomEE)" + value.substring(slash) + " (" + tomeeVersion + ")");
        }
        catch (Exception e) {
        }
        finally {
            if (field != null) {
                field.setAccessible(acc);
            }
        }
    }

    private void readSystemPropertiesConf() {
        Properties systemProperties;
        String systemPropertiesPath = new File(System.getProperty("carbon.home")).getAbsolutePath() + File.separator + "repository" + File.separator + "conf" + File.separator + "tomee" + File.separator + "system.properties";
        File file = new File(systemPropertiesPath);
        if (!file.exists()) {
            return;
        }
        try {
            systemProperties = IO.readProperties((File)file);
        }
        catch (IOException e) {
            return;
        }
        SystemInstance.get().getProperties().putAll((Map<?, ?>)systemProperties);
    }
}

