/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.javaee.tomee;

import java.io.File;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.deploy.ContextTransaction;
import org.apache.catalina.startup.ContextConfig;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomcat.JarScanner;
import org.apache.tomee.catalina.ContextListener;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.apache.tomee.common.UserTransactionFactory;
import org.apache.tomee.loader.TomcatHelper;
import org.wso2.carbon.javaee.tomee.ASGlobalListenerSupport;
import org.wso2.carbon.javaee.tomee.ASOpenEJBContextConfig;
import org.wso2.carbon.tomcat.ext.scan.CarbonTomcatJarScanner;

public class ASTomcatWebAppBuilder
extends TomcatWebAppBuilder {
    private final ASGlobalListenerSupport globalListenerSupport;
    private Class<?> sessionManagerClass = null;
    private static final boolean FORCE_RELOADABLE = SystemInstance.get().getOptions().get("tomee.force-reloadable", false);
    private static final boolean SKIP_TLD = SystemInstance.get().getOptions().get("tomee.skip-tld", false);
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB.createChild("tomcat"), (String)"org.apache.openejb.util.resources");
    private String defaultHost = "localhost";
    private static Method startInternal = null;
    private static Method addMyFacesDefaultParameters = null;

    public ASTomcatWebAppBuilder() {
        StandardServer standardServer = TomcatHelper.getServer();
        this.globalListenerSupport = new ASGlobalListenerSupport(standardServer, (ContextListener)this);
        for (Service service : standardServer.findServices()) {
            if (!(service.getContainer() instanceof Engine)) continue;
            Engine engine = (Engine)service.getContainer();
            this.defaultHost = engine.getDefaultHost();
        }
    }

    public void start() {
        this.globalListenerSupport.start();
    }

    public void stop() {
        this.globalListenerSupport.stop();
    }

    public void init(StandardContext standardContext) {
        standardContext.setIgnoreAnnotations(true);
        standardContext.setJarScanner((JarScanner)new CarbonTomcatJarScanner());
    }

    public void configureStart(StandardContext standardContext) {
        if (TomcatHelper.isTomcat7()) {
            ContextTransaction contextTransaction = new ContextTransaction();
            contextTransaction.setProperty("factory", (Object)UserTransactionFactory.class.getName());
            standardContext.getNamingResources().setTransaction(contextTransaction);
            try {
                startInternal.invoke((Object)this, standardContext);
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        try {
            addMyFacesDefaultParameters.invoke((Object)this, standardContext.getLoader().getClassLoader(), standardContext.getServletContext());
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        standardContext.setTldValidation(Boolean.parseBoolean(SystemInstance.get().getProperty("tomee.tld.validation", "false")));
        standardContext.setXmlValidation(Boolean.parseBoolean(SystemInstance.get().getProperty("tomee.xml.validation", "false")));
    }

    protected void setContextConfig(StandardContext standardContext) {
        LifecycleListener[] listeners;
        for (LifecycleListener l : listeners = standardContext.findLifecycleListeners()) {
            if (!(l instanceof ContextConfig)) continue;
            standardContext.removeLifecycleListener(l);
        }
        String globalWebXml = new File(System.getProperty("carbon.home")).getAbsolutePath() + File.separator + "repository" + File.separator + "conf" + File.separator + "tomcat" + File.separator + "web.xml";
        String globalContextXml = new File(System.getProperty("carbon.home")).getAbsolutePath() + File.separator + "repository" + File.separator + "conf" + File.separator + "tomcat" + File.separator + "context.xml";
        ASOpenEJBContextConfig contextConfig = new ASOpenEJBContextConfig(new TomcatWebAppBuilder.StandardContextInfo((TomcatWebAppBuilder)this, standardContext));
        contextConfig.setDefaultWebXml(globalWebXml);
        contextConfig.setDefaultContextXml(globalContextXml);
        standardContext.addLifecycleListener((LifecycleListener)contextConfig);
    }

    static {
        try {
            startInternal = TomcatWebAppBuilder.class.getDeclaredMethod("startInternal", StandardContext.class);
            startInternal.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new OpenEJBRuntimeException("can't find method isIgnored", (Throwable)e);
        }
        try {
            addMyFacesDefaultParameters = TomcatWebAppBuilder.class.getDeclaredMethod("addMyFacesDefaultParameters", ClassLoader.class, ServletContext.class);
            addMyFacesDefaultParameters.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new OpenEJBRuntimeException("can't find method isIgnored", (Throwable)e);
        }
    }
}

