/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.javaee.tomee;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import org.apache.catalina.Context;
import org.apache.catalina.deploy.ApplicationListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.loader.SystemInstance;
import org.apache.tomee.catalina.IgnoredStandardContext;
import org.apache.tomee.catalina.OpenEJBContextConfig;
import org.apache.tomee.catalina.TomcatWebAppBuilder;

public class ASOpenEJBContextConfig
extends OpenEJBContextConfig {
    private static final String MYFACES_TOMEEM_CONTAINER_INITIALIZER = "org.apache.tomee.myfaces.TomEEMyFacesContainerInitializer";
    private static final String TOMEE_MYFACES_CONTEXT_LISTENER = "org.apache.tomee.myfaces.TomEEMyFacesContextListener";
    private static final Log log = LogFactory.getLog((String)ASOpenEJBContextConfig.class.getName());

    public ASOpenEJBContextConfig(TomcatWebAppBuilder.StandardContextInfo standardContextInfo) {
        super(standardContextInfo);
    }

    protected void processServletContainerInitializers() {
        super.processServletContainerInitializers();
    }

    protected void webConfig() {
        super.webConfig();
        if (IgnoredStandardContext.class.isInstance(this.context)) {
            return;
        }
        try {
            this.context.getLoader().getClassLoader().loadClass("com.sun.faces.context.SessionMap");
            return;
        }
        catch (Throwable ignored) {
            try {
                Class<?> myfacesInitializer = Class.forName(MYFACES_TOMEEM_CONTAINER_INITIALIZER, true, this.context.getLoader().getClassLoader());
                ServletContainerInitializer instance = (ServletContainerInitializer)myfacesInitializer.newInstance();
                this.context.addServletContainerInitializer(instance, this.getJsfClasses(this.context));
                this.context.addApplicationListener(new ApplicationListener(TOMEE_MYFACES_CONTEXT_LISTENER, false));
            }
            catch (Exception ignored2) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return;
        }
    }

    private Set<Class<?>> getJsfClasses(Context context) {
        WebAppBuilder builder = (WebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
        ClassLoader cl = context.getLoader().getClassLoader();
        Map scanned = (Map)builder.getJsfClasses().get(cl);
        if (scanned == null || scanned.isEmpty()) {
            return null;
        }
        HashSet classes = new HashSet();
        for (Set entry : scanned.values()) {
            for (String name : entry) {
                try {
                    classes.add(cl.loadClass(name));
                }
                catch (ClassNotFoundException ignored) {
                    log.warn((Object)("class '" + name + "' was found but can't be loaded as a JSF class"));
                }
            }
        }
        return classes;
    }
}

