/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.javaee.tomee;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.util.ServerInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openejb.classloader.ClassLoaderConfigurer;
import org.apache.openejb.config.QuickJarsTxtParser;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.JuliLogStreamFactory;
import org.apache.openejb.util.OpenEjbVersion;
import org.apache.tomee.TomEELogConfigurer;
import org.apache.tomee.catalina.ServerListener;
import org.apache.tomee.loader.TomcatHelper;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.javaee.tomee.ASTomcatLoader;
import org.wso2.carbon.utils.CarbonUtils;

public class ASTomEEServerListener
extends ServerListener {
    private static final Log log = LogFactory.getLog((String)ASTomEEServerListener.class.getName());
    private static final AtomicBoolean listenerInstalled = new AtomicBoolean(false);

    public void lifecycleEvent(LifecycleEvent event) {
        this.install(event);
        SystemInstance.get().fireEvent((Object)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install(LifecycleEvent event) {
        if ("before_init".equals(event.getType()) && StandardServer.class.isInstance(event.getSource())) {
            this.installServerInfo();
        }
        AtomicBoolean atomicBoolean = listenerInstalled;
        synchronized (atomicBoolean) {
            if (listenerInstalled.get() || !"after_init".equals(event.getType())) {
                return;
            }
            if (!(event.getSource() instanceof StandardServer)) {
                return;
            }
            try {
                StandardServer server = (StandardServer)event.getSource();
                TomcatHelper.setServer((StandardServer)server);
                Properties properties = new Properties();
                System.getProperties().setProperty("openejb.embedder.source", ((Object)((Object)this)).getClass().getSimpleName());
                properties.setProperty("openejb.embedder.source", ((Object)((Object)this)).getClass().getSimpleName());
                if (SystemInstance.isInitialized()) {
                    return;
                }
                properties.setProperty("tomee.webapp.classloader.enrichment.skip", "true");
                properties.setProperty("openejb.loader", "tomcat-system");
                properties.setProperty("openejb.system.apps", "false");
                String catalinaHome = System.getProperty("catalina.base");
                properties.setProperty("openejb.home", catalinaHome);
                System.setProperty("openejb.home", catalinaHome);
                String catalinaBase = System.getProperty("catalina.base");
                properties.setProperty("openejb.base", catalinaBase);
                System.setProperty("openejb.base", catalinaBase);
                properties.setProperty("openejb.cxf.jmx", "false");
                ClassLoader classLoader = ServerListener.class.getClassLoader();
                try {
                    String serverBuilt;
                    String serverInfo;
                    Properties tomcatServerInfo = IO.readProperties((InputStream)classLoader.getResourceAsStream("org/apache/catalina/util/ServerInfo.properties"), (Properties)new Properties());
                    String serverNumber = tomcatServerInfo.getProperty("server.number");
                    if (serverNumber == null && (serverInfo = tomcatServerInfo.getProperty("server.info")) != null) {
                        int slash = serverInfo.indexOf(47);
                        serverNumber = serverInfo.substring(slash + 1);
                    }
                    if (serverNumber != null) {
                        System.setProperty("tomcat.version", serverNumber);
                    }
                    if ((serverBuilt = tomcatServerInfo.getProperty("server.built")) != null) {
                        System.setProperty("tomcat.built", serverBuilt);
                    }
                }
                catch (Throwable tomcatServerInfo) {
                    // empty catch block
                }
                if (URLClassLoader.class.isInstance(classLoader)) {
                    URLClassLoader ucl = (URLClassLoader)URLClassLoader.class.cast(classLoader);
                    try {
                        Method addUrl = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                        boolean acc = addUrl.isAccessible();
                        try {
                            for (File f : ProvisioningUtil.addAdditionalLibraries()) {
                                ASTomEEServerListener.addUrl(ucl, addUrl, f.toURI().toURL());
                            }
                            File globalJaxrsTxt = SystemInstance.get().getConf("jars.txt");
                            ClassLoaderConfigurer configurer = QuickJarsTxtParser.parse((File)globalJaxrsTxt);
                            if (configurer != null) {
                                for (URL f : configurer.additionalURLs()) {
                                    ASTomEEServerListener.addUrl(ucl, addUrl, f);
                                }
                            }
                        }
                        finally {
                            addUrl.setAccessible(acc);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    log.debug((Object)("container classloader is not an URL one so can't check provisining: " + classLoader));
                }
                this.setServiceManager(properties);
                this.setOpenJPALogFactory();
                this.readSystemPropertiesConf();
                ASTomcatLoader loader = new ASTomcatLoader();
                loader.initSystemInstance(properties);
                loader.initialize(properties);
                TomEELogConfigurer.configureLogs();
                listenerInstalled.set(true);
            }
            catch (Exception e) {
                log.error((Object)"TomEE Listener can't start OpenEJB", (Throwable)e);
            }
        }
    }

    private static void addUrl(URLClassLoader ucl, Method addUrl, URL url) throws IllegalAccessException, InvocationTargetException, MalformedURLException {
        if (!addUrl.isAccessible()) {
            addUrl.setAccessible(true);
        }
        addUrl.invoke((Object)ucl, url);
    }

    protected void setOpenJPALogFactory() {
        try {
            JuliLogStreamFactory.class.getClassLoader().loadClass("org.wso2.carbon.javaee.tomee.openjpa.JULOpenJPALogFactory");
            System.setProperty("openjpa.Log", "org.wso2.carbon.javaee.tomee.openjpa.JULOpenJPALogFactory");
        }
        catch (Exception ignored) {
            log.debug((Object)ignored.getMessage(), (Throwable)ignored);
        }
    }

    protected void setServiceManager(Properties properties) {
        properties.put("openejb.service.manager.class", "org.wso2.carbon.javaee.tomee.osgi.ASServiceManagerExtender");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void installServerInfo() {
        String value = ServerInfo.getServerInfo();
        Field field = null;
        boolean acc = true;
        try {
            field = ServerInfo.class.getDeclaredField("serverInfo");
            acc = field.isAccessible();
            int slash = value.indexOf(47);
            field.setAccessible(true);
            String version = OpenEjbVersion.get().getVersion();
            String tomeeVersion = Integer.parseInt(Character.toString(version.charAt(0))) - 3 + version.substring(1, version.length());
            String asVersion = ServerConfiguration.getInstance().getFirstProperty("Version");
            field.set(null, "WSO2 AS " + asVersion + " (" + value.substring(0, slash) + " " + value.substring(slash + 1) + "/TomEE " + tomeeVersion + ")");
        }
        catch (Exception exception) {
        }
        finally {
            if (field != null) {
                field.setAccessible(acc);
            }
        }
    }

    private void readSystemPropertiesConf() {
        Properties systemProperties;
        String systemPropertiesPath = Paths.get(CarbonUtils.getCarbonConfigDirPath(), "tomee", "system.properties").toString();
        File file = new File(systemPropertiesPath);
        if (!file.exists()) {
            return;
        }
        try {
            systemProperties = IO.readProperties((File)file);
        }
        catch (IOException e) {
            return;
        }
        SystemInstance.get().getProperties().putAll((Map<?, ?>)systemProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Properties properties = System.getProperties();
        synchronized (properties) {
            SystemInstance.get();
        }
    }
}

