/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.javaee.tomee;

import java.io.File;
import java.util.Properties;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.config.sys.Tomee;
import org.apache.openejb.loader.SystemInstance;
import org.apache.tomee.catalina.TomcatLoader;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.wso2.carbon.base.CarbonBaseUtils;
import org.wso2.carbon.javaee.tomee.ASTomcatWebAppBuilder;

public class ASTomcatLoader
extends TomcatLoader {
    public void initialize(Properties properties) throws Exception {
        this.setJdbcPool();
        this.setTomeeXml();
        TomcatWebAppBuilder tomcatWebAppBuilder = (TomcatWebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
        if (tomcatWebAppBuilder == null) {
            tomcatWebAppBuilder = new ASTomcatWebAppBuilder();
            tomcatWebAppBuilder.start();
            SystemInstance.get().setComponent(WebAppBuilder.class, (Object)tomcatWebAppBuilder);
        }
        super.initialize(properties);
    }

    protected void setJdbcPool() {
        try {
            Class<?> creatorClass = TomcatLoader.class.getClassLoader().loadClass("org.apache.tomee.jdbc.TomEEDataSourceCreator");
            SystemInstance.get().setProperty("openejb.jdbc.datasource-creator", creatorClass.getName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void setTomeeXml() {
        String tomeeXmlLocation = CarbonBaseUtils.getCarbonConfigDirPath() + File.separator + "tomee" + File.separator + "tomee.xml";
        File tomeeXml = new File(tomeeXmlLocation);
        if (tomeeXml.exists()) {
            SystemInstance.get().setProperty("openejb.configuration", tomeeXml.getAbsolutePath());
            SystemInstance.get().setProperty("openejb.configuration.class", Tomee.class.getName());
        }
    }
}

