/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.javaee.tomee.scan;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomee.loader.TomEEJarScanner;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.wso2.carbon.utils.CarbonUtils;

public class ASTomEEJarScanner
extends TomEEJarScanner {
    private static final Log log = LogFactory.getLog(ASTomEEJarScanner.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.scan");
    private static final String CARBON_PLUGINS_DIR_PATH = Paths.get(CarbonUtils.getComponentsRepo(), new String[0]).toString();

    public void scan(ServletContext context, ClassLoader classloader, JarScannerCallback callback, Set<String> jarsToSkip) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        while (loader != null) {
            File[] jarFiles;
            if (!(loader instanceof BundleClassLoader)) continue;
            File pluginsDir = new File(CARBON_PLUGINS_DIR_PATH);
            for (File jarFile : jarFiles = pluginsDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().endsWith(".jar");
                }
            })) {
                try {
                    this.process(callback, jarFile.toURI().toURL());
                }
                catch (IOException e) {
                    log.warn((Object)sm.getString("jarScan.classloaderFail"), (Throwable)e);
                }
            }
        }
    }

    private void process(JarScannerCallback callback, URL url) throws IOException {
        URLConnection conn;
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("jarScan.jarUrlStart", new Object[]{url}));
        }
        if ((conn = url.openConnection()) instanceof JarURLConnection) {
            callback.scan((JarURLConnection)conn);
        } else {
            String urlStr = url.toString();
            if (urlStr.startsWith("file:") || urlStr.startsWith("jndi:")) {
                if (urlStr.endsWith(".jar")) {
                    URL jarURL = new URL("jar:" + urlStr + "!/");
                    callback.scan((JarURLConnection)jarURL.openConnection());
                } else {
                    try {
                        File metainf;
                        File f = new File(url.toURI());
                        if (f.isFile() && this.isScanAllFiles()) {
                            URL jarURL = new URL("jar:" + urlStr + "!/");
                            callback.scan((JarURLConnection)jarURL.openConnection());
                        } else if (f.isDirectory() && this.isScanAllDirectories() && (metainf = new File(f.getAbsoluteFile() + File.separator + "META-INF")).isDirectory()) {
                            callback.scan(f);
                        }
                    }
                    catch (URISyntaxException e) {
                        IOException ioe = new IOException();
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
            }
        }
    }
}

