/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.module.mgt.service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.Version;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.util.ParameterUtil;
import org.wso2.carbon.core.util.SystemFilter;
import org.wso2.carbon.identity.sts.common.config.SecurityConfigAdmin;
import org.wso2.carbon.module.mgt.ModuleMetaData;
import org.wso2.carbon.module.mgt.ModuleMgtException;
import org.wso2.carbon.module.mgt.ModuleUploadData;
import org.wso2.carbon.module.mgt.internal.DataHolder;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.FileManipulator;

public class ModuleAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(ModuleAdminService.class);
    public static final String THROTTLE_MODULE = "wso2throttle";
    public static final String CACHING_MODULE = "wso2caching";
    public static final String ADDRESSING_MODULE = "addressing";
    private static final String GLOBALLY_ENGAGED_PARAM_NAME = "globallyEngaged";
    private static final String RAMPART_MODULE_NAME = "rampart";
    private static final String RAHAS_MODULE_NAME = "rahas";
    private PersistenceFactory pf;

    public ModuleAdminService() throws Exception {
        this.axisConfig = this.getAxisConfig();
        this.pf = PersistenceFactory.getInstance((AxisConfiguration)this.axisConfig);
    }

    public ModuleAdminService(AxisConfiguration ac) throws Exception {
        this.axisConfig = ac;
        this.pf = PersistenceFactory.getInstance((AxisConfiguration)this.axisConfig);
    }

    public ModuleMetaData[] listModules() {
        ArrayList<ModuleMetaData> moduleList = new ArrayList<ModuleMetaData>();
        for (AxisModule axisModule : this.axisConfig.getModules().values()) {
            if (SystemFilter.isFilteredOutModule((AxisModule)axisModule) || axisModule.getName() == null) continue;
            ModuleMetaData moduleMetaData = this.populateModuleMetaData(axisModule);
            moduleList.add(moduleMetaData);
        }
        return moduleList.toArray(new ModuleMetaData[moduleList.size()]);
    }

    public ModuleMetaData[] listGloballyEngagedModules() {
        ArrayList<ModuleMetaData> emodules = new ArrayList<ModuleMetaData>();
        for (AxisModule axisModule : this.axisConfig.getEngagedModules()) {
            String globallyEngaged;
            String moduleVersion = "";
            if (axisModule.getVersion() != null) {
                moduleVersion = axisModule.getVersion().toString();
            }
            String moduleId = this.getModuleId(axisModule.getName(), axisModule.getVersion());
            if (SystemFilter.isFilteredOutModule((AxisModule)axisModule)) continue;
            if (this.axisConfig.isEngaged(moduleId)) {
                emodules.add(new ModuleMetaData(axisModule.getName(), moduleVersion));
                continue;
            }
            Parameter param = axisModule.getParameter(GLOBALLY_ENGAGED_PARAM_NAME);
            if (param == null || (globallyEngaged = (String)param.getValue()) == null || globallyEngaged.length() == 0 || !Boolean.parseBoolean(globallyEngaged.trim())) continue;
            emodules.add(new ModuleMetaData(axisModule.getName(), moduleVersion));
        }
        return emodules.toArray(new ModuleMetaData[emodules.size()]);
    }

    public ModuleMetaData[] listModulesForOperation(String serviceName, String operationName) throws ModuleMgtException {
        ModuleMetaData[] modules;
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        if (service == null) {
            log.error((Object)("Service " + serviceName + "cannnot be found!"));
            throw new ModuleMgtException(2, "service.not.found");
        }
        AxisOperation operation = service.getOperation(new QName(operationName));
        if (operation == null) {
            log.error((Object)("Operation " + serviceName + "cannnot be found!"));
            throw new ModuleMgtException(2, "operation.not.found");
        }
        AxisServiceGroup serviceGroup = service.getAxisServiceGroup();
        for (ModuleMetaData module : modules = this.listModules()) {
            String moduleId = module.getModuleId();
            module.setEngagedServiceGroupLevel(serviceGroup.isEngaged(moduleId));
            module.setEngagedServiceLevel(service.isEngaged(moduleId));
            module.setEngagedOperationLevel(operation.isEngaged(moduleId));
        }
        return modules;
    }

    public ModuleMetaData[] listModulesForService(String serviceName) throws ModuleMgtException {
        ModuleMetaData[] modules;
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        if (service == null) {
            log.error((Object)("Service " + serviceName + "cannnot be found!"));
            throw new ModuleMgtException(2, "service.not.found");
        }
        AxisServiceGroup serviceGroup = service.getAxisServiceGroup();
        for (ModuleMetaData module : modules = this.listModules()) {
            String moduleId = module.getModuleId();
            module.setEngagedServiceGroupLevel(serviceGroup.isEngaged(moduleId));
            module.setEngagedServiceLevel(service.isEngaged(moduleId));
        }
        return modules;
    }

    public ModuleMetaData[] listModulesForServiceGroup(String serviceGroupName) throws ModuleMgtException {
        ModuleMetaData[] modules;
        AxisServiceGroup serviceGroup = this.axisConfig.getServiceGroup(serviceGroupName);
        if (serviceGroup == null) {
            log.error((Object)("Service group " + serviceGroupName + "cannnot be found!"));
            throw new ModuleMgtException(2, "service.group.not.found");
        }
        for (ModuleMetaData module : modules = this.listModules()) {
            String moduleId = module.getModuleId();
            module.setEngagedServiceGroupLevel(serviceGroup.isEngaged(moduleId));
        }
        return modules;
    }

    public ModuleMetaData getModuleInfo(String moduleName, String moduleVersion) throws ModuleMgtException {
        AxisModule axisModule = this.getAxisModule(moduleName, moduleVersion);
        if (axisModule == null) {
            log.error((Object)("Module " + moduleName + "-" + moduleVersion + " cannnot be found!"));
            throw new ModuleMgtException(2, "module.not.found");
        }
        return this.populateModuleMetaData(axisModule);
    }

    public boolean globallyEngageModule(String moduleId) throws ModuleMgtException {
        try {
            AxisModule axisModule = this.getAxisModule(moduleId);
            if (axisModule == null) {
                log.error((Object)("Module " + moduleId + " cannnot be found!"));
                throw new ModuleMgtException(2, "module.not.found");
            }
            if (this.axisConfig.isEngaged(axisModule)) {
                throw new ModuleMgtException(1, "already.engaged.globally");
            }
            if (RAHAS_MODULE_NAME.equalsIgnoreCase(axisModule.getName())) {
                AxisModule rampartModule = this.axisConfig.getModule(RAMPART_MODULE_NAME);
                if (rampartModule == null) {
                    log.error((Object)"Rampart module not found when engaging Rampart");
                    throw new ModuleMgtException(2, "rahas.rampart.not.found");
                }
                if (!this.axisConfig.isEngaged(rampartModule)) {
                    this.globallyEngageModule(this.getModuleId(rampartModule.getName(), rampartModule.getVersion()));
                }
            }
            try {
                this.axisConfig.engageModule(axisModule);
                this.persistGloballyEngagedStatus(axisModule, true);
            }
            catch (AxisFault axisFault) {
                log.error((Object)("Error occured while globally engaging the module " + moduleId), (Throwable)axisFault);
                throw new ModuleMgtException(axisFault, 2, "error.global.engage");
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occured while globally engaging the module " + moduleId), (Throwable)e);
            throw new ModuleMgtException(e, 2, "error.global.engage");
        }
        return true;
    }

    private void persistGloballyEngagedStatus(AxisModule axisModule, boolean globallyEngagedStatus) {
        if (DataHolder.getRegistryService() != null) {
            try {
                UserRegistry configSystemRegistry = DataHolder.getRegistryService().getConfigSystemRegistry(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
                String moduleResourcePath = this.getModuleResourcePath(axisModule);
                Object moduleResource = configSystemRegistry.resourceExists(moduleResourcePath) ? configSystemRegistry.get(moduleResourcePath) : configSystemRegistry.newCollection();
                moduleResource.setProperty("globally.engaged", Boolean.toString(globallyEngagedStatus));
                configSystemRegistry.put(moduleResourcePath, (Resource)moduleResource);
            }
            catch (RegistryException e) {
                log.error((Object)("Failed to persist globally engaged status of the module: " + axisModule.getName()), (Throwable)e);
            }
        }
    }

    private String getModuleResourcePath(AxisModule axisModule) {
        return "/repository/axis2/modules/" + axisModule.getName() + "/" + axisModule.getVersion();
    }

    public boolean engageModuleForServiceGroup(String moduleID, String serviceGroupName) throws ModuleMgtException {
        AxisServiceGroup serviceGroup = this.axisConfig.getServiceGroup(serviceGroupName);
        if (serviceGroup == null) {
            log.error((Object)("Service group " + serviceGroupName + "cannnot be found!"));
            throw new ModuleMgtException(2, "service.group.not.found");
        }
        AxisModule module = this.axisConfig.getModule(moduleID);
        if (module == null) {
            log.error((Object)("Module " + moduleID + " cannnot be found!"));
            throw new ModuleMgtException(2, "module.not.found");
        }
        if (this.axisConfig.isEngaged(module)) {
            throw new ModuleMgtException(1, "already.engaged.globally");
        }
        if (serviceGroup.isEngaged(module)) {
            throw new ModuleMgtException(1, "already.engaged.service.group");
        }
        try {
            if (RAHAS_MODULE_NAME.equals(module.getName())) {
                AxisModule rampartModule = this.axisConfig.getModule(RAMPART_MODULE_NAME);
                if (rampartModule == null) {
                    log.error((Object)"Rampart module not found when engaging Rampart");
                    throw new ModuleMgtException(2, "rahas.rampart.not.found");
                }
                if (!serviceGroup.isEngaged(rampartModule)) {
                    this.pf.getServiceGroupPM().engageModuleForServiceGroup(rampartModule, serviceGroup);
                    serviceGroup.disengageModule(rampartModule);
                    serviceGroup.engageModule(rampartModule);
                }
            }
            this.pf.getServiceGroupPM().engageModuleForServiceGroup(module, serviceGroup);
            serviceGroup.disengageModule(module);
            serviceGroup.engageModule(module);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Error occured while engaging the module " + module), (Throwable)e);
            throw new ModuleMgtException(e, 2, "error.engage");
        }
    }

    public boolean disengageModuleForServiceGroup(String moduleId, String serviceGroupName) throws ModuleMgtException {
        AxisServiceGroup serviceGroup = this.axisConfig.getServiceGroup(serviceGroupName);
        if (serviceGroup == null) {
            log.error((Object)("Service group " + serviceGroupName + "cannnot be found!"));
            throw new ModuleMgtException(2, "service.group.not.found");
        }
        AxisModule module = this.axisConfig.getModule(moduleId);
        if (module == null) {
            log.error((Object)("Module " + moduleId + " cannnot be found!"));
            throw new ModuleMgtException(2, "module.not.found");
        }
        if (serviceGroup.isEngaged(module)) {
            AxisModule rahasModule;
            if (RAMPART_MODULE_NAME.equalsIgnoreCase(module.getName()) && serviceGroup.isEngaged(rahasModule = this.axisConfig.getModule(RAHAS_MODULE_NAME))) {
                throw new ModuleMgtException(1, "rahas.rampart.disengage");
            }
            if (RAMPART_MODULE_NAME.equalsIgnoreCase(module.getName()) || RAHAS_MODULE_NAME.equalsIgnoreCase(module.getName())) {
                Iterator servicesIterator = serviceGroup.getServices();
                while (servicesIterator.hasNext()) {
                    AxisService service = (AxisService)servicesIterator.next();
                    if (!this.isRequiredForSecurityScenario(service.getName(), module.getName())) continue;
                    throw new ModuleMgtException(1, "services.scenario.applied");
                }
            }
            try {
                this.pf.getServiceGroupPM().disengageModuleForServiceGroup(module, serviceGroup);
                serviceGroup.disengageModule(module);
            }
            catch (Exception e) {
                log.error((Object)("Error occured while disengaging the module " + module), (Throwable)e);
                throw new ModuleMgtException(e, 2, "error.disengage");
            }
            return true;
        }
        throw new ModuleMgtException(1, "not.engaged");
    }

    public boolean engageModuleForService(String moduleId, String serviceName) throws ModuleMgtException {
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        if (service == null) {
            log.error((Object)("Service  " + serviceName + "cannnot be found!"));
            throw new ModuleMgtException(2, "service.not.found");
        }
        AxisModule module = this.axisConfig.getModule(moduleId);
        if (module == null) {
            log.error((Object)("Module " + moduleId + " cannnot be found!"));
            throw new ModuleMgtException(2, "module.not.found");
        }
        if (this.axisConfig.isEngaged(module)) {
            throw new ModuleMgtException(1, "already.engaged.globally");
        }
        AxisServiceGroup axisServiceGroup = service.getAxisServiceGroup();
        if (axisServiceGroup.isEngaged(module)) {
            throw new ModuleMgtException(1, "already.engaged.service.group");
        }
        if (service.isEngaged(module)) {
            throw new ModuleMgtException(1, "already.engaged.service");
        }
        try {
            if (RAHAS_MODULE_NAME.equalsIgnoreCase(module.getName())) {
                AxisModule rampartModule = this.axisConfig.getModule(RAMPART_MODULE_NAME);
                if (rampartModule == null) {
                    throw new ModuleMgtException(2, "rahas.rampart.not.found");
                }
                if (!service.isEngaged(rampartModule)) {
                    this.pf.getServicePM().engageModuleForService(rampartModule, service);
                    service.disengageModule(rampartModule);
                    service.engageModule(rampartModule);
                }
            }
            this.pf.getServicePM().engageModuleForService(module, service);
            service.disengageModule(module);
            service.engageModule(module);
            return true;
        }
        catch (Exception e) {
            String msg = "Error occured while engaging the module " + module;
            log.error((Object)msg, (Throwable)e);
            throw new ModuleMgtException(e, 2, "error.engage");
        }
    }

    public boolean disengageModuleForService(String moduleId, String serviceName) throws ModuleMgtException {
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        if (service == null) {
            log.error((Object)("Service  " + serviceName + "cannnot be found!"));
            throw new ModuleMgtException(2, "service.not.found");
        }
        AxisModule module = this.axisConfig.getModule(moduleId);
        if (module == null) {
            log.error((Object)("Module " + moduleId + " cannnot be found!"));
            throw new ModuleMgtException(2, "module.not.found");
        }
        if (service.isEngaged(module)) {
            AxisModule rahasModule;
            if (RAMPART_MODULE_NAME.equalsIgnoreCase(module.getName()) && service.isEngaged(rahasModule = this.axisConfig.getModule(RAHAS_MODULE_NAME))) {
                throw new ModuleMgtException(1, "rahas.rampart.disengage");
            }
            if (this.isRequiredForSecurityScenario(serviceName, moduleId)) {
                throw new ModuleMgtException(1, "sec.scenario");
            }
            try {
                this.pf.getServicePM().disengageModuleForService(module, service);
                service.disengageModule(module);
            }
            catch (Exception e) {
                String msg = "Error occured while disengaging the module " + moduleId + " from service " + serviceName;
                log.error((Object)msg, (Throwable)e);
                throw new ModuleMgtException(e, 2, "error.disengage");
            }
        }
        return true;
    }

    public boolean engageModuleForOperation(String moduleId, String serviceName, String operationName) throws ModuleMgtException {
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        if (service == null) {
            log.error((Object)("Service  " + serviceName + "cannnot be found!"));
            throw new ModuleMgtException(2, "service.not.found");
        }
        AxisOperation operation = service.getOperation(new QName(operationName));
        if (operation == null) {
            log.error((Object)("Operation  " + operationName + "cannnot be found!"));
            throw new ModuleMgtException(2, "operation.not.found");
        }
        AxisModule module = this.axisConfig.getModule(moduleId);
        if (module == null) {
            log.error((Object)("Module  " + moduleId + "cannnot be found!"));
            throw new ModuleMgtException(2, "operation.not.found");
        }
        if (this.axisConfig.isEngaged(module)) {
            throw new ModuleMgtException(1, "already.engaged.globally");
        }
        AxisServiceGroup axisServiceGroup = service.getAxisServiceGroup();
        if (axisServiceGroup.isEngaged(module)) {
            throw new ModuleMgtException(1, "already.engaged.service.group");
        }
        if (service.isEngaged(module)) {
            throw new ModuleMgtException(1, "already.engaged.service");
        }
        if (operation.isEngaged(module)) {
            throw new ModuleMgtException(1, "already.engaged.operation");
        }
        try {
            if (RAHAS_MODULE_NAME.equalsIgnoreCase(module.getName())) {
                AxisModule rampartModule = this.axisConfig.getModule(RAMPART_MODULE_NAME);
                if (rampartModule == null) {
                    throw new ModuleMgtException(1, "rahas.rampart.not.found");
                }
                if (!operation.isEngaged(rampartModule)) {
                    this.pf.getOperationPM().engageModuleForOperation(rampartModule, operation);
                    operation.disengageModule(rampartModule);
                    operation.engageModule(rampartModule);
                }
            }
            this.pf.getOperationPM().engageModuleForOperation(module, operation);
            operation.disengageModule(module);
            operation.engageModule(module);
        }
        catch (Exception e) {
            String msg = "Error occured while engaging the module " + moduleId + " to " + operationName;
            log.error((Object)msg, (Throwable)e);
            throw new ModuleMgtException(e, 2, "error.engage");
        }
        return true;
    }

    public boolean disengageModuleForOperation(String moduleId, String serviceName, String operationName) throws ModuleMgtException {
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        if (service == null) {
            log.error((Object)("Service  " + serviceName + "cannnot be found!"));
            throw new ModuleMgtException(2, "service.not.found");
        }
        AxisOperation operation = service.getOperation(new QName(operationName));
        if (operation == null) {
            log.error((Object)("Operation  " + operationName + "cannnot be found!"));
            throw new ModuleMgtException(2, "operation.not.found");
        }
        AxisModule module = this.axisConfig.getModule(moduleId);
        if (module == null) {
            log.error((Object)("Module  " + moduleId + "cannnot be found!"));
            throw new ModuleMgtException(2, "operation.not.found");
        }
        if (operation.isEngaged(module)) {
            AxisModule rahasModule;
            if (RAMPART_MODULE_NAME.equalsIgnoreCase(module.getName()) && operation.isEngaged(rahasModule = this.axisConfig.getModule(RAHAS_MODULE_NAME))) {
                throw new ModuleMgtException(1, "rahas.rampart.disengage");
            }
            try {
                this.pf.getOperationPM().disengageModuleForOperation(module, operation);
                operation.disengageModule(module);
            }
            catch (Exception e) {
                String msg = "Error occured while disengaging the module " + moduleId + " from operation " + operationName;
                log.error((Object)msg, (Throwable)e);
                throw new ModuleMgtException(e, 2, "error.disengage");
            }
        }
        return true;
    }

    public boolean globallyDisengageModule(String moduleId) throws ModuleMgtException {
        if (moduleId.startsWith(ADDRESSING_MODULE)) {
            throw new ModuleMgtException(1, "disengage.addressing.globally");
        }
        AxisModule module = this.axisConfig.getModule(moduleId);
        if (module == null) {
            log.error((Object)("Module  " + moduleId + "cannnot be found!"));
            throw new ModuleMgtException(2, "module.not.found");
        }
        try {
            this.disengageModuleFromSystem(moduleId);
            this.persistGloballyEngagedStatus(module, false);
        }
        catch (ModuleMgtException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Error occured while globally disengaging the module " + moduleId;
            log.error((Object)msg, (Throwable)e);
            throw new ModuleMgtException(e, 2, "error.disengage");
        }
        return true;
    }

    private AxisModule getAxisModule(String moduleId, String moduleVersion) throws ModuleMgtException {
        AxisModule module = this.axisConfig.getModule(moduleId, moduleVersion);
        if (module == null) {
            log.error((Object)("Module  " + moduleId + "-" + moduleVersion + "cannnot be found!"));
            throw new ModuleMgtException(2, "module.not.found");
        }
        return module;
    }

    private AxisModule getAxisModule(String moduleId) throws ModuleMgtException {
        AxisModule module = this.axisConfig.getModule(moduleId);
        if (module == null) {
            log.error((Object)("Module  " + moduleId + "cannnot be found!"));
            throw new ModuleMgtException(2, "module.not.found");
        }
        return module;
    }

    public String uploadModule(ModuleUploadData[] moduleUploadData) throws AxisFault {
        String fileName = "";
        try {
            String repo = this.getAxisConfig().getRepository().getPath();
            if (CarbonUtils.isURL((String)repo)) {
                throw new AxisFault("Uploading modules to URL repository is not allowed");
            }
            File modulesDir = new File(repo, "axis2modules");
            if (!modulesDir.exists() && !modulesDir.mkdir()) {
                log.warn((Object)("Cannot create " + modulesDir.getAbsolutePath()));
            }
            for (ModuleUploadData uploadData : moduleUploadData) {
                fileName = uploadData.getFileName();
                this.writeToRepository(modulesDir.getAbsolutePath(), fileName, uploadData.getDataHandler());
            }
        }
        catch (Exception e) {
            String msg = "Error occured while uploading the module " + fileName;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        return "successful";
    }

    public String[] getModuleParameters(String moduleName, String moduleVersion) throws ModuleMgtException {
        AxisModule module = this.getAxisModule(moduleName, moduleVersion);
        if (module == null) {
            log.error((Object)("Module  " + module + "cannnot be found!"));
            throw new ModuleMgtException(2, "module.not.found");
        }
        ArrayList<String> parameters = new ArrayList<String>();
        ArrayList moduleParams = module.getParameters();
        for (Object serviceParam : moduleParams) {
            Parameter parameter = (Parameter)serviceParam;
            if (parameter.getParameterElement() == null) continue;
            parameters.add(parameter.getParameterElement().toString());
        }
        Collections.sort(parameters, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return arg0.compareToIgnoreCase(arg1);
            }
        });
        return parameters.toArray(new String[parameters.size()]);
    }

    public void setModuleParameters(String moduleName, String moduleVersion, String[] parameters) throws ModuleMgtException {
        for (String parameter : parameters) {
            this.setModuleParameter(moduleName, moduleVersion, parameter);
        }
    }

    private String setModuleParameter(String moduleName, String moduleVersion, String parameterStr) throws ModuleMgtException {
        OMElement paramEle;
        AxisModule module = this.getAxisModule(moduleName, moduleVersion);
        if (module == null) {
            log.error((Object)("Module  " + module + "cannnot be found!"));
            throw new ModuleMgtException(2, "module.not.found");
        }
        try {
            XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(parameterStr.getBytes()));
            paramEle = new StAXOMBuilder(xmlSR).getDocumentElement();
        }
        catch (XMLStreamException e) {
            String msg = "Cannot create OMElement from parameter: " + parameterStr;
            log.error((Object)msg, (Throwable)e);
            throw new ModuleMgtException(2, "error.param.remove");
        }
        try {
            Parameter parameter = ParameterUtil.createParameter((OMElement)paramEle);
            if (module.getParameter(parameter.getName()) == null || !module.getParameter(parameter.getName()).isLocked()) {
                module.addParameter(parameter);
                this.pf.getModulePM().updateModuleParameter(module, parameter);
            }
        }
        catch (Exception e) {
            String msg = "Cannot persist module parameter for operation " + module.getName();
            log.error((Object)msg, (Throwable)e);
            throw new ModuleMgtException(2, "error.param.remove");
        }
        return "Succesfully updated service parameters";
    }

    public String removeModuleParameter(String moduleName, String moduleVersion, String parameterName) throws ModuleMgtException {
        AxisModule module = this.getAxisModule(moduleName, moduleVersion);
        if (module == null) {
            log.error((Object)("Module  " + module + "cannot be found!"));
            throw new ModuleMgtException(2, "module.not.found");
        }
        try {
            Parameter parameter = ParameterUtil.createParameter((String)parameterName, null);
            module.removeParameter(parameter);
            this.pf.getModulePM().removeModuleParameter(module, parameter);
        }
        catch (Exception e) {
            String msg = "Cannot persist parameter removal from module  " + module.getName();
            log.error((Object)msg, (Throwable)e);
            throw new ModuleMgtException(2, "error.param.remove");
        }
        return "Successfully removed parameter " + parameterName + " from " + moduleName + ":" + moduleVersion + " module";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String removeModule(String moduleId) throws ModuleMgtException {
        String repo = this.getAxisConfig().getRepository().getPath();
        if (CarbonUtils.isURL((String)repo)) {
            throw new ModuleMgtException(1, "url.repo");
        }
        if (moduleId.startsWith(ADDRESSING_MODULE)) {
            throw new ModuleMgtException(1, "disengage.addressing.globally");
        }
        AxisModule module = this.axisConfig.getModule(moduleId);
        if (module == null) {
            log.error((Object)("Module  " + moduleId + "cannnot be found!"));
            throw new ModuleMgtException(2, "module.not.found");
        }
        if (module.getFileName() == null) throw new ModuleMgtException(1, "system.module.delete");
        String fileName = module.getFileName().getPath();
        File file = new File(fileName);
        if (!file.canWrite()) {
            throw new ModuleMgtException(1, "module.delete.error");
        }
        if (this.isEngaged(module)) {
            throw new ModuleMgtException(1, "engaged.module.remove");
        }
        this.disengageModuleFromSystem(moduleId);
        if (!file.exists()) throw new ModuleMgtException(1, "module.file.not.found");
        if (!(file.isDirectory() && FileManipulator.deleteDir((File)file) || file.delete())) {
            throw new ModuleMgtException(1, "module.delete.error");
        }
        try {
            this.pf.getModulePM().removeModule(module);
            this.axisConfig.removeModule(module.getName(), module.getVersion());
            return "Module " + moduleId + " was successfully removed from system";
        }
        catch (Exception e) {
            log.error((Object)("Error while removing module : " + moduleId), (Throwable)e);
            throw new ModuleMgtException(1, "error.module.remove");
        }
    }

    public boolean disengageModuleFromSystem(String moduleId) throws ModuleMgtException {
        if (moduleId.startsWith(ADDRESSING_MODULE)) {
            throw new ModuleMgtException(1, "disengage.addressing.globally");
        }
        AxisModule module = this.getAxisModule(moduleId);
        try {
            if (this.axisConfig.isEngaged(module)) {
                AxisModule rahasModule;
                if (RAHAS_MODULE_NAME.equalsIgnoreCase(module.getName()) || RAMPART_MODULE_NAME.equalsIgnoreCase(module.getName())) {
                    HashMap services = this.axisConfig.getServices();
                    for (AxisService service : services.values()) {
                        if (!this.isRequiredForSecurityScenario(service.getName(), moduleId)) continue;
                        throw new ModuleMgtException(1, "services.scenario.applied");
                    }
                }
                if (RAMPART_MODULE_NAME.equalsIgnoreCase(module.getName()) && this.axisConfig.isEngaged(rahasModule = this.axisConfig.getModule(RAHAS_MODULE_NAME))) {
                    throw new ModuleMgtException(1, "rahas.rampart.disengage");
                }
                this.axisConfig.disengageModule(module);
                Parameter param = new Parameter(GLOBALLY_ENGAGED_PARAM_NAME, (Object)Boolean.FALSE.toString());
                module.addParameter(param);
            }
        }
        catch (ModuleMgtException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while disengaging module " + module.getName()), (Throwable)e);
            throw new ModuleMgtException(2, "error.global.disengage");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToRepository(String path, String fileName, DataHandler dataHandler) throws Exception {
        File destFile = new File(path, fileName);
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(destFile);
            dataHandler.writeTo((OutputStream)fos);
            fos.flush();
            fos.close();
        }
    }

    private boolean isRequiredForSecurityScenario(String serviceName, String moduleId) throws ModuleMgtException {
        String[] requiredModules;
        try {
            SecurityConfigAdmin secConfAdmin = new SecurityConfigAdmin(this.getUserRealm(), this.getConfigSystemRegistry(), this.axisConfig);
            requiredModules = secConfAdmin.getRequiredModules(serviceName, moduleId);
        }
        catch (Exception e) {
            String msg = "Error occured while getting the security scenarions for the service";
            log.error((Object)msg);
            throw new ModuleMgtException(e, 2, "sec.scenario.error");
        }
        if (requiredModules == null) {
            return false;
        }
        for (String module : requiredModules) {
            if (!moduleId.startsWith(module)) continue;
            return true;
        }
        return false;
    }

    private ModuleMetaData populateModuleMetaData(AxisModule axisModule) {
        String globallyEngaged;
        ModuleMetaData moduleMetaData = new ModuleMetaData();
        String moduleVersion = "";
        if (axisModule.getVersion() != null) {
            moduleVersion = axisModule.getVersion().toString();
        }
        moduleMetaData.setModulename(axisModule.getName());
        moduleMetaData.setModuleVersion(moduleVersion);
        moduleMetaData.setModuleId(this.getModuleId(axisModule.getName(), axisModule.getVersion()));
        moduleMetaData.setEngagedGlobalLevel(this.axisConfig.isEngaged(axisModule));
        Parameter param = axisModule.getParameter(GLOBALLY_ENGAGED_PARAM_NAME);
        if (param != null && (globallyEngaged = (String)param.getValue()) != null && globallyEngaged.length() != 0 && Boolean.parseBoolean(globallyEngaged.trim())) {
            moduleMetaData.setEngagedGlobalLevel(true);
        }
        moduleMetaData.setManagedModule(SystemFilter.isManagedModule((AxisModule)axisModule));
        String description = axisModule.getModuleDescription();
        if (description != null) {
            moduleMetaData.setDescription(description);
        } else {
            moduleMetaData.setDescription("No description found");
        }
        return moduleMetaData;
    }

    private boolean isEngaged(AxisModule module) {
        if (this.axisConfig.isEngaged(module)) {
            return true;
        }
        Iterator serviceGroups = this.axisConfig.getServiceGroups();
        while (serviceGroups.hasNext()) {
            AxisServiceGroup serviceGroup = (AxisServiceGroup)serviceGroups.next();
            if (!serviceGroup.isEngaged(module)) continue;
            return true;
        }
        HashMap services = this.axisConfig.getServices();
        for (AxisService service : services.values()) {
            if (service.isEngaged(module)) {
                return true;
            }
            Iterator ops = service.getOperations();
            while (ops.hasNext()) {
                AxisOperation op = (AxisOperation)ops.next();
                if (!op.isEngaged(module)) continue;
                return true;
            }
        }
        return false;
    }

    private String getModuleId(String moduleName, Version moduleVersion) {
        String version;
        if (moduleVersion != null && (version = moduleVersion.toString()) != null && version.length() != 0) {
            moduleName = moduleName + "-" + moduleVersion;
        }
        return moduleName;
    }
}

