/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.module.mgt.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.rpc.receivers.RPCMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.module.mgt.ModuleMgtException;

public class ModuleAdminMessageReceiver
extends RPCMessageReceiver {
    private static Log log = LogFactory.getLog(ModuleAdminMessageReceiver.class);

    protected void handleInvocationTargetException(InvocationTargetException e, Method method) throws AxisFault {
        String msg = null;
        Throwable cause = e.getCause();
        if (cause != null) {
            msg = cause.getMessage();
        }
        if (msg == null) {
            msg = "Exception occurred while trying to invoke service method " + (method != null ? method.getName() : "null");
        }
        if (cause instanceof ModuleMgtException) {
            log.debug((Object)msg, cause);
            AxisFault axisFault = new AxisFault(msg, (Throwable)e);
            axisFault.setDetail(this.getExceptionDetails((ModuleMgtException)cause));
            throw axisFault;
        }
        if (cause instanceof AxisFault) {
            log.debug((Object)msg, cause);
            throw (AxisFault)cause;
        }
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    private OMElement getExceptionDetails(ModuleMgtException e) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("http://service.mgt.module.carbon.wso2.org", "modmgt");
        OMNamespace nsXsd = factory.createOMNamespace("http://mgt.module.carbon.wso2.org/xsd", "modxsd");
        OMElement moduleEx = factory.createOMElement("ModuleMgtException", ns);
        OMElement moduleWrap = factory.createOMElement("ModuleMgtException", ns);
        OMElement key = factory.createOMElement("key", nsXsd);
        OMElement level = factory.createOMElement("level", nsXsd);
        key.setText(e.getKey());
        level.setText(String.valueOf(e.getLevel()));
        moduleEx.addChild((OMNode)key);
        moduleEx.addChild((OMNode)level);
        moduleWrap.addChild((OMNode)moduleEx);
        return moduleWrap;
    }
}

