/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.module.mgt.ui.util;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wso2.carbon.module.mgt.stub.ModuleAdminServiceModuleMgtExceptionException;
import org.wso2.carbon.module.mgt.stub.types.ModuleMgtException;
import org.wso2.carbon.ui.CarbonUIMessage;

public class ModuleManagementUtils {
    public static final String RESOURCE_BUNDLE = "org.wso2.carbon.module.mgt.ui.i18n.Resources";

    public static ModuleMgtException getModuleMgtException(ModuleAdminServiceModuleMgtExceptionException e) {
        if (e.getFaultMessage() != null) {
            return e.getFaultMessage().getModuleMgtException();
        }
        return null;
    }

    public static void handleModuleMgtErrors(ModuleAdminServiceModuleMgtExceptionException e, HttpServletRequest req, HttpServletResponse res, String warnPage) throws IOException {
        String warnRedirect = warnPage == null ? "index.jsp" : warnPage;
        ResourceBundle resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, req.getLocale());
        if (e.getFaultMessage() == null) {
            CarbonUIMessage.sendCarbonUIMessage((String)e.getMessage(), (String)"error", (HttpServletRequest)req, (Exception)e);
            res.sendRedirect("../admin/error.jsp");
            return;
        }
        ModuleMgtException moduleMgtException = ModuleManagementUtils.getModuleMgtException(e);
        if (moduleMgtException == null) {
            CarbonUIMessage.sendCarbonUIMessage((String)e.getMessage(), (String)"error", (HttpServletRequest)req, (Exception)e);
            res.sendRedirect("../admin/error.jsp");
            return;
        }
        if (moduleMgtException.getLevel() == 1) {
            String key = moduleMgtException.getKey();
            CarbonUIMessage carbonMessage = new CarbonUIMessage(resourceBundle.getString(key), "warning");
            req.getSession().setAttribute("carbonUIMessage", (Object)carbonMessage);
            res.sendRedirect(warnRedirect);
            return;
        }
        if (moduleMgtException.getLevel() == 2) {
            String key = moduleMgtException.getKey();
            CarbonUIMessage carbonMessage = new CarbonUIMessage(resourceBundle.getString(key), "error");
            req.getSession().setAttribute("carbonUIMessage", (Object)carbonMessage);
            res.sendRedirect("../admin/error.jsp");
            return;
        }
    }
}

