/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.operation.mgt.ui.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.operation.mgt.stub.OperationAdminStub;
import org.wso2.carbon.operation.mgt.stub.types.OperationMetaData;
import org.wso2.carbon.operation.mgt.stub.types.OperationMetaDataWrapper;
import org.wso2.carbon.operation.mgt.ui.client.Parameter;
import org.wso2.carbon.utils.xml.XMLPrettyPrinter;

public class OperationAdminClient {
    private static final Log log = LogFactory.getLog(OperationAdminClient.class);
    private OperationAdminStub stub;

    public OperationAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "OperationAdmin";
        this.stub = new OperationAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public OperationMetaDataWrapper listAllOperations(String serviceName) throws AxisFault {
        if (serviceName == null) {
            this.handleException("Service name cannot be null");
        }
        OperationMetaDataWrapper metaDataWrapper = null;
        try {
            metaDataWrapper = this.stub.listAllOperations(serviceName);
        }
        catch (Exception e) {
            this.handleException("Cannot get operation list", e);
        }
        return metaDataWrapper;
    }

    public OperationMetaData getOperationMetaData(String serviceName, String opName) throws AxisFault {
        try {
            return this.stub.getOperationMetaData(serviceName, opName);
        }
        catch (Exception e) {
            this.handleException("Cannot get operation metadata for service: " + serviceName + "operation " + opName, e);
            return null;
        }
    }

    public void configureMTOM(String flag, String serviceName, String operationName) throws AxisFault {
        try {
            this.stub.configureMTOM(flag, serviceName, operationName);
        }
        catch (Exception e) {
            this.handleException("Could not change MTOM processing to " + flag + " for service " + serviceName + ", operation=" + operationName, e);
        }
    }

    public List<Parameter> getOperationParameters(String serviceName, String operationName) throws AxisFault {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        try {
            String[] operationParameters = this.stub.getDeclaredOperationParameters(serviceName, operationName);
            if (operationParameters != null && operationParameters.length != 0) {
                for (String operationParameter : operationParameters) {
                    XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(operationParameter.getBytes()));
                    OMElement paramEle = new StAXOMBuilder(xmlSR).getDocumentElement();
                    String paramName = paramEle.getAttribute(new QName("name")).getAttributeValue();
                    ByteArrayInputStream xmlIn = new ByteArrayInputStream(operationParameter.getBytes());
                    XMLPrettyPrinter xmlPrettyPrinter = new XMLPrettyPrinter((InputStream)xmlIn, null);
                    Parameter parameter = new Parameter(paramName, xmlPrettyPrinter.xmlFormat());
                    boolean isLocked = false;
                    OMAttribute lockedAttrib = paramEle.getAttribute(new QName("locked"));
                    if (lockedAttrib != null) {
                        isLocked = "true".equals(lockedAttrib.getAttributeValue());
                    }
                    parameter.setLocked(isLocked);
                    parameters.add(parameter);
                }
            }
        }
        catch (Exception e) {
            this.handleException("Could not get operation parameters for service: " + serviceName + " & operation:" + operationName, e);
        }
        return parameters;
    }

    public void removeOperationParameter(String serviceName, String operation, String parameterName) throws AxisFault {
        try {
            this.stub.removeOperationParameter(serviceName, operation, parameterName);
        }
        catch (RemoteException e) {
            this.handleException("Could not remove operation parameter. Service: " + serviceName + ", operation: " + operation + ", parameterName=" + parameterName, e);
        }
    }

    public void setOperationParameters(String serviceName, String operation, List<String> parameters) throws AxisFault {
        try {
            this.stub.setOperationParameters(serviceName, operation, parameters.toArray(new String[parameters.size()]));
        }
        catch (RemoteException e) {
            this.handleException("Cannot add operation parameters", e);
        }
    }

    private void handleException(String msg) throws AxisFault {
        log.error((Object)msg);
        throw new AxisFault(msg);
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

