/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.service.mgt.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.TwoChannelAxisOperation;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver;
import org.apache.axis2.rpc.receivers.RPCMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.util.SystemFilter;
import org.wso2.carbon.service.mgt.PolicyUtil;
import org.wso2.carbon.utils.ArchiveManipulator;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.FileManipulator;
import org.wso2.carbon.utils.NetworkUtils;

public final class ServiceArchiveCreator {
    private static Log log = LogFactory.getLog(ServiceArchiveCreator.class);

    private ServiceArchiveCreator() {
    }

    public static String createArchive(ConfigurationContext configurationContext, String serviceGroupName) throws AxisFault {
        String msg;
        String axis2Repo = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.RepositoryLocation");
        if (CarbonUtils.isURL((String)axis2Repo)) {
            String message = "Archive creation is not supported with a URL based Axis2 repository. The repository in use is " + axis2Repo;
            log.error((Object)message);
            throw new AxisFault(message);
        }
        String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random()) + ".aar";
        AxisServiceGroup axisServiceGroup = configurationContext.getAxisConfiguration().getServiceGroup(serviceGroupName);
        if (axisServiceGroup == null) {
            String error = "Service group " + serviceGroupName + " not found!";
            log.error((Object)error);
            throw new AxisFault(error);
        }
        if (serviceGroupName.contains(".jar") || serviceGroupName.contains(".class")) {
            String message = "Archive creation not supported for " + serviceGroupName;
            log.error((Object)message);
            throw new AxisFault(message);
        }
        URL axisServiceGroupURL = null;
        Iterator iterator = axisServiceGroup.getServices();
        while (iterator.hasNext()) {
            AxisService as = (AxisService)iterator.next();
            for (Parameter parameter : as.getParameters()) {
                String name = parameter.getName();
                Object obj = parameter.getValue();
                String value = "";
                if (obj != null) {
                    value = obj.toString();
                }
                if (!name.equals("serviceType") || !value.equals("axis1") && !value.equals("data_service") && !value.equals("jaxws") && !value.equals("proxy") && !value.equals("js_service") && !value.equals("bpel") && !value.equals("bpelmgt")) continue;
                String message = "WSO2 Carbon does not support creating archive for " + value + " services.";
                log.warn((Object)message);
                throw new AxisFault(message);
            }
            if (axisServiceGroupURL != null) continue;
            if (as.getFileName() == null) {
                String msg2 = "Request to create a service archive file for a service group not found in side repo";
                log.warn((Object)msg2);
                throw new AxisFault(msg2);
            }
            axisServiceGroupURL = as.getFileName();
        }
        if (axisServiceGroupURL == null) {
            String error = ServiceArchiveCreator.class.getName() + " AxisServiceGroup " + serviceGroupName + " location couldn't be found.";
            log.error((Object)error);
            throw new AxisFault(error);
        }
        String workdir = (String)configurationContext.getProperty("WORK_DIR");
        if (workdir == null) {
            String msg3 = "Work dir does not exist. Please make sure that the WORK_DIR property points to a proper workdir.";
            log.error((Object)msg3);
            throw new AxisFault(msg3);
        }
        File f = new File(workdir + File.separator + "dump_aar" + File.separator + uuid);
        if (!f.exists() && !f.mkdirs()) {
            log.warn((Object)("Could not create " + f.getAbsolutePath()));
        }
        try {
            File[] files;
            File file = new File(axisServiceGroupURL.getPath());
            ArchiveManipulator am = new ArchiveManipulator();
            if (file.isDirectory()) {
                FileManipulator.copyDir((File)file, (File)f);
            } else if (file.isFile() && axisServiceGroupURL.getPath().endsWith(".class")) {
                FileManipulator.copyFileToDir((File)file, (File)f);
            } else {
                am.extract(axisServiceGroupURL.getPath(), f.getAbsolutePath());
            }
            File servicesF = new File(f.getAbsolutePath() + File.separator + "META-INF", "services.xml");
            String servicesXmlPath = servicesF.getAbsolutePath();
            if (servicesF.exists() && !servicesF.delete()) {
                log.warn((Object)("Could not delete the existing services.xml at : " + servicesF.getAbsolutePath()));
            }
            File newServicesXml = new File(servicesXmlPath);
            OMElement axisServiceGroupXMLInfoset = ServiceArchiveCreator.createServiceGroupXMLInfoset(axisServiceGroup);
            FileOutputStream os = new FileOutputStream(newServicesXml);
            axisServiceGroupXMLInfoset.serializeAndConsume((OutputStream)os);
            File[] oldWsdls = f.listFiles(new FileFilter(){

                @Override
                public boolean accept(File fw) {
                    return fw.getName().endsWith(".wsdl");
                }
            });
            if (oldWsdls != null) {
                for (File oldWsdl : oldWsdls) {
                    if (!oldWsdl.exists() || oldWsdl.delete()) continue;
                    log.warn((Object)("Could not delete " + oldWsdl.getAbsolutePath()));
                }
            }
            Iterator iterator2 = axisServiceGroup.getServices();
            while (iterator2.hasNext()) {
                AxisService axisService = (AxisService)iterator2.next();
                boolean isRpcMessageReceiver = false;
                Iterator ops = axisService.getOperations();
                while (ops.hasNext()) {
                    MessageReceiver receiver = ((AxisOperation)ops.next()).getMessageReceiver();
                    isRpcMessageReceiver = receiver instanceof RPCMessageReceiver || receiver instanceof RPCInOnlyMessageReceiver;
                }
                if (isRpcMessageReceiver) continue;
                File wsdlF = new File(f.getAbsolutePath() + File.separator + "META-INF", ServiceArchiveCreator.formatServiceName(axisService.getName()) + ".wsdl");
                FileOutputStream wbOut = new FileOutputStream(wsdlF);
                axisService.printWSDL((OutputStream)wbOut, NetworkUtils.getLocalHostname());
            }
            File fout = new File(workdir + File.separator + "dump_aar_output" + File.separator + uuid);
            if (!fout.exists() && !fout.mkdirs()) {
                log.warn((Object)("Could not create " + fout.getAbsolutePath()));
            }
            String outAARFilename = fout.getAbsolutePath() + File.separator + ServiceArchiveCreator.formatServiceName(serviceGroupName) + ".aar";
            am.archiveDir(outAARFilename, f.getPath());
            ConfigurationContext superTenantConfigContext = MessageContext.getCurrentMessageContext().getConfigurationContext();
            Hashtable<String, String> fileResourcesMap = (Hashtable<String, String>)superTenantConfigContext.getProperty("file.resource.map");
            if (fileResourcesMap == null) {
                fileResourcesMap = new Hashtable<String, String>();
                superTenantConfigContext.setProperty("file.resource.map", fileResourcesMap);
            }
            if ((files = fout.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().endsWith(".aar");
                }
            })) != null && files[0] != null && files[0].getAbsoluteFile() != null) {
                fileResourcesMap.put(uuid, files[0].getAbsoluteFile().getAbsolutePath());
            }
            return "/filedownload?id=" + uuid;
        }
        catch (IOException e) {
            msg = "IOException occurred while trying to create service archive for service group " + serviceGroupName;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (XMLStreamException e) {
            msg = "XMLStreamException occurred while trying to create service archive for service group " + serviceGroupName;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    private static OMElement createServicesXMLInfoset(AxisService axisService) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace ns = fac.createOMNamespace("", "");
        OMElement serviceEle = ServiceArchiveCreator.createOMElement(fac, ns, "service");
        OMAttribute nameAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "name", axisService.getName());
        OMAttribute wsAddAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "wsaddressing", AddressingHelper.getAddressingRequirementParemeterValue((AxisDescription)axisService));
        OMAttribute targetNsAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "targetNamespace", axisService.getTargetNamespace());
        OMAttribute scopeAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "scope", axisService.getScope());
        serviceEle.addAttribute(nameAttr);
        serviceEle.addAttribute(wsAddAttr);
        serviceEle.addAttribute(targetNsAttr);
        serviceEle.addAttribute(scopeAttr);
        OMElement discEle = ServiceArchiveCreator.createOMElement(fac, ns, "Description", axisService.getDocumentation());
        serviceEle.addChild((OMNode)discEle);
        OMElement schemaEle = ServiceArchiveCreator.createOMElement(fac, ns, "schema");
        OMAttribute schemaNsAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "schemaNamespace", axisService.getSchemaTargetNamespace());
        OMAttribute schemaEleQualifiedAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "elementFormDefaultQualified", axisService.isElementFormDefault() ? "true" : "false");
        schemaEle.addAttribute(schemaNsAttr);
        schemaEle.addAttribute(schemaEleQualifiedAttr);
        serviceEle.addChild((OMNode)schemaEle);
        Map p2nMap = axisService.getP2nMap();
        if (p2nMap != null) {
            Set entrySet = p2nMap.entrySet();
            Iterator iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry anEntrySet;
                Map.Entry me = anEntrySet = iterator.next();
                String packageKey = (String)me.getKey();
                String namesapceValue = (String)me.getValue();
                OMElement mapping = ServiceArchiveCreator.createOMElement(fac, ns, "mapping");
                OMAttribute packageAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "package", packageKey);
                OMAttribute namespaceAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "namespace", namesapceValue);
                mapping.addAttribute(packageAttr);
                mapping.addAttribute(namespaceAttr);
                schemaEle.addChild((OMNode)mapping);
            }
        }
        if (!axisService.isEnableAllTransports()) {
            OMElement transportsEle = ServiceArchiveCreator.createOMElement(fac, ns, "transports");
            serviceEle.addChild((OMNode)transportsEle);
            for (String transport : axisService.getExposedTransports()) {
                OMElement transportEle = ServiceArchiveCreator.createOMElement(fac, ns, "transport", transport);
                transportsEle.addChild((OMNode)transportEle);
            }
        }
        Iterator iterator = axisService.getOperations();
        while (iterator.hasNext()) {
            OMElement faultActions;
            String outputAction;
            AxisOperation operation = (AxisOperation)iterator.next();
            if (operation.isControlOperation()) continue;
            OMElement operationEle = ServiceArchiveCreator.createOMElement(fac, ns, "operation");
            serviceEle.addChild((OMNode)operationEle);
            OMAttribute opNameAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "name", operation.getName().getLocalPart());
            OMAttribute opMEPAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "mep", operation.getMessageExchangePattern());
            operationEle.addAttribute(opNameAttr);
            operationEle.addAttribute(opMEPAttr);
            OMElement opMREle = ServiceArchiveCreator.createOMElement(fac, ns, "messageReceiver");
            operationEle.addChild((OMNode)opMREle);
            OMAttribute opMRClassAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "class", operation.getMessageReceiver().getClass().getName());
            opMREle.addAttribute(opMRClassAttr);
            ArrayList mappingList = operation.getWSAMappingList();
            if (mappingList != null) {
                for (String aMappingList : mappingList) {
                    OMElement mappingEle = ServiceArchiveCreator.createOMElement(fac, ns, "actionMapping", aMappingList);
                    operationEle.addChild((OMNode)mappingEle);
                }
            }
            if ((outputAction = operation.getOutputAction()) != null) {
                OMElement outputActionMappingEle = ServiceArchiveCreator.createOMElement(fac, ns, "outputActionMapping", outputAction);
                operationEle.addChild((OMNode)outputActionMappingEle);
            }
            if ((faultActions = operation.getFaultActionNames()) != null) {
                for (OMElement faultAction : faultActions) {
                    OMElement faultActionEle = ServiceArchiveCreator.createOMElement(fac, ns, "faultActionMapping");
                    operationEle.addChild((OMNode)faultActionEle);
                    OMAttribute faultActionAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "faultName", (String)faultAction);
                    faultActionEle.addAttribute(faultActionAttr);
                }
            }
            ArrayList operationParameterList = operation.getParameters();
            ServiceArchiveCreator.serializeParameterList(operationParameterList, operationEle, fac, ns);
            Collection operationLevelEngagedModulesCollection = operation.getEngagedModules();
            Collection axisServiceLevelEngagedModuleCollection = axisService.getEngagedModules();
            ArrayList<AxisModule> aoOnlyModuleList = new ArrayList<AxisModule>();
            for (AxisModule axisModule : operationLevelEngagedModulesCollection) {
                if (axisServiceLevelEngagedModuleCollection.contains(axisModule)) continue;
                aoOnlyModuleList.add(axisModule);
            }
            ServiceArchiveCreator.serializeModules(aoOnlyModuleList, operationEle, fac, ns, (AxisDescription)operation);
            Map<String, AxisMessage> axisMessagesMap = new AxisMessageLookup().lookup(operation);
            Set<Map.Entry<String, AxisMessage>> axisMessagesSet = axisMessagesMap.entrySet();
            for (Map.Entry<String, AxisMessage> me : axisMessagesSet) {
                String lableKey = me.getKey();
                AxisMessage axisMessage = me.getValue();
                OMElement axisMessageEle = ServiceArchiveCreator.createOMElement(fac, ns, "message");
                OMAttribute axisMessageLableAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "label", lableKey);
                axisMessageEle.addAttribute(axisMessageLableAttr);
                ArrayList axisMessageParameterList = axisMessage.getParameters();
                ServiceArchiveCreator.serializeParameterList(axisMessageParameterList, axisMessageEle, fac, ns);
                PolicyInclude policyInclude = operation.getPolicyInclude();
                PolicyRegistry registry = policyInclude.getPolicyRegistry();
                ArrayList policyList = policyInclude.getPolicyElements(5);
                if (policyList.isEmpty()) continue;
                ServiceArchiveCreator.serializePolicyIncludes(axisMessageEle, policyList, registry);
            }
            PolicyInclude policyInclude = operation.getPolicyInclude();
            PolicyRegistry registry = policyInclude.getPolicyRegistry();
            ArrayList policyList = policyInclude.getPolicyElements(4);
            if (policyList.isEmpty()) continue;
            ServiceArchiveCreator.serializePolicyIncludes(operationEle, policyList, registry);
        }
        ArrayList serviceParameterList = axisService.getParameters();
        ServiceArchiveCreator.serializeParameterList(serviceParameterList, serviceEle, fac, ns);
        Collection serviceEngagedModuleCollection = axisService.getEngagedModules();
        AxisDescription parent = axisService.getParent();
        AxisServiceGroup asg = (AxisServiceGroup)parent;
        Collection asgEngagedModulesCollection = asg.getEngagedModules();
        ArrayList<AxisModule> asOnlyModuleList = new ArrayList<AxisModule>();
        for (AxisModule axisModule : serviceEngagedModuleCollection) {
            if (asgEngagedModulesCollection.contains(axisModule.getName())) continue;
            asOnlyModuleList.add(axisModule);
        }
        ServiceArchiveCreator.serializeModules(asOnlyModuleList, serviceEle, fac, ns, (AxisDescription)axisService);
        if (axisService.isCustomWsdl()) {
            OMElement package2QName = ServiceArchiveCreator.createOMElement(fac, ns, "packageMapping");
            serviceEle.addChild((OMNode)package2QName);
            TypeTable typeTable = axisService.getTypeTable();
            if (typeTable != null) {
                Map complexSchemaMap = typeTable.getComplexSchemaMap();
                Set complexSchemaSet = complexSchemaMap.entrySet();
                Iterator iterator2 = complexSchemaSet.iterator();
                while (iterator2.hasNext()) {
                    Map.Entry aComplexSchemaSet;
                    Map.Entry me = aComplexSchemaSet = iterator2.next();
                    String packageKey = (String)me.getKey();
                    QName qName = (QName)me.getValue();
                    OMElement mapping = ServiceArchiveCreator.createOMElement(fac, ns, "mapping");
                    OMAttribute packageAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "packageName", packageKey);
                    OMAttribute qNameAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "qName", qName.getNamespaceURI());
                    mapping.addAttribute(packageAttr);
                    mapping.addAttribute(qNameAttr);
                    package2QName.addChild((OMNode)mapping);
                }
            }
        }
        PolicyInclude policyInclude = axisService.getPolicyInclude();
        PolicyRegistry registry = policyInclude.getPolicyRegistry();
        ArrayList policyList = policyInclude.getPolicyElements(3);
        if (!policyList.isEmpty()) {
            ServiceArchiveCreator.serializePolicyIncludes(serviceEle, policyList, registry);
        }
        return serviceEle;
    }

    protected static OMElement createServiceGroupXMLInfoset(AxisServiceGroup axisServiceGroup) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace ns = fac.createOMNamespace("", "");
        OMElement serviceGroupEle = ServiceArchiveCreator.createOMElement(fac, ns, "serviceGroup");
        ArrayList parameterList = axisServiceGroup.getParameters();
        ServiceArchiveCreator.serializeParameterList(parameterList, serviceGroupEle, fac, ns);
        Collection axisServiceGroupModuleCollection = axisServiceGroup.getEngagedModules();
        ServiceArchiveCreator.serializeModules(axisServiceGroupModuleCollection, serviceGroupEle, fac, ns, (AxisDescription)axisServiceGroup);
        Iterator iterator = axisServiceGroup.getServices();
        while (iterator.hasNext()) {
            AxisService axisService = (AxisService)iterator.next();
            OMElement axisServiceEle = ServiceArchiveCreator.createServicesXMLInfoset(axisService);
            serviceGroupEle.addChild((OMNode)axisServiceEle);
        }
        return serviceGroupEle;
    }

    protected static void serializePolicyIncludes(OMElement parent, List policyList, PolicyRegistry policyRegistry) {
        for (Object obj : policyList) {
            if (obj instanceof Policy) {
                Policy policy = (Policy)obj;
                parent.addChild((OMNode)PolicyUtil.getPolicyAsOMElement(policy));
                continue;
            }
            if (!(obj instanceof PolicyReference)) continue;
            PolicyReference policyReference = (PolicyReference)obj;
            Policy policy = policyRegistry.lookup(policyReference.getURI());
            if (policy == null) {
                log.error((Object)(ServiceArchiveCreator.class.getName() + "policy object couldn't be NULL"));
                continue;
            }
            OMElement e = PolicyUtil.getPolicyAsOMElement(policy);
            parent.addChild((OMNode)e);
        }
    }

    protected static void serializeModules(Collection<AxisModule> moduleCollection, OMElement parent, OMFactory fac, OMNamespace ns, AxisDescription axisDesc) {
        if (moduleCollection != null) {
            for (AxisModule axisModule : moduleCollection) {
                ModuleConfiguration moduleConfig;
                String moduleName = axisModule.getName();
                if (SystemFilter.isFilteredOutModule((String)moduleName) || axisDesc.getParent().isEngaged(axisModule)) continue;
                OMElement moduleEle = ServiceArchiveCreator.createOMElement(fac, ns, "module");
                OMAttribute moduleRefAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "ref", moduleName);
                moduleEle.addAttribute(moduleRefAttr);
                parent.addChild((OMNode)moduleEle);
                if (axisDesc instanceof AxisService) {
                    moduleConfig = ((AxisService)axisDesc).getModuleConfig(moduleName);
                } else if (axisDesc instanceof AxisOperation) {
                    moduleConfig = ((AxisOperation)axisDesc).getModuleConfig(moduleName);
                } else if (axisDesc instanceof AxisServiceGroup) {
                    moduleConfig = ((AxisServiceGroup)axisDesc).getModuleConfig(moduleName);
                } else {
                    return;
                }
                if (moduleConfig == null) continue;
                OMElement moduleConfigEle = ServiceArchiveCreator.createOMElement(fac, ns, "moduleConfig");
                OMAttribute moduleConfigNameAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "name", moduleConfig.getModuleName());
                moduleConfigEle.addAttribute(moduleConfigNameAttr);
                parent.addChild((OMNode)moduleConfigEle);
                ArrayList paramsList = moduleConfig.getParameters();
                ServiceArchiveCreator.serializeParameterList(paramsList, moduleConfigEle, fac, ns);
            }
        }
    }

    protected static void serializeParameterList(List<Parameter> parameterList, OMElement parent, OMFactory fac, OMNamespace ns) {
        if (parameterList != null) {
            for (Parameter parm : parameterList) {
                ServiceArchiveCreator.serializeParameter(parm, parent, fac, ns);
            }
        }
    }

    protected static void serializeParameter(Parameter param, OMElement parent, OMFactory fac, OMNamespace ns) {
        if (param == null || param.getValue() == null) {
            return;
        }
        int paramType = param.getParameterType();
        if (paramType != 0) {
            OMElement paramEle = ServiceArchiveCreator.createOMElement(fac, ns, "parameter");
            parent.addChild((OMNode)paramEle);
            OMAttribute paramNameAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "name", param.getName());
            OMAttribute paramLokedAttr = ServiceArchiveCreator.createOMAttribute(fac, ns, "locked", param.isLocked() ? "true" : "false");
            paramEle.addAttribute(paramNameAttr);
            paramEle.addAttribute(paramLokedAttr);
            if (paramType == 2) {
                paramEle.addChild((OMNode)((OMElement)param.getValue()));
            } else if (paramType == 1) {
                paramEle.setText(param.getValue().toString());
            }
        }
    }

    protected static OMElement createOMElement(OMFactory fac, OMNamespace ns, String localName) {
        return fac.createOMElement(localName, ns);
    }

    protected static OMElement createOMElement(OMFactory fac, OMNamespace ns, String localName, String text) {
        OMElement omElement = fac.createOMElement(localName, ns);
        omElement.setText(text);
        return omElement;
    }

    protected static OMAttribute createOMAttribute(OMFactory fac, OMNamespace ns, String localName, String value) {
        return fac.createOMAttribute(localName, ns, value);
    }

    private static String formatServiceName(String name) {
        String newName = name;
        int temp = newName.lastIndexOf(47);
        if (temp != -1) {
            newName = newName.substring(temp + 1, newName.length());
        }
        return newName;
    }

    protected static class AxisMessageLookup {
        protected AxisMessageLookup() {
        }

        protected Map<String, AxisMessage> lookup(AxisOperation axisOperation) {
            HashMap<String, AxisMessage> axisMessageMap = new HashMap<String, AxisMessage>();
            if (axisOperation instanceof InOnlyAxisOperation) {
                axisMessageMap.put("In", axisOperation.getMessage("In"));
                return axisMessageMap;
            }
            if (axisOperation instanceof OutOnlyAxisOperation) {
                axisMessageMap.put("Out", axisOperation.getMessage("Out"));
                return axisMessageMap;
            }
            if (axisOperation instanceof TwoChannelAxisOperation) {
                axisMessageMap.put("In", axisOperation.getMessage("In"));
                axisMessageMap.put("Out", axisOperation.getMessage("Out"));
                return axisMessageMap;
            }
            return axisMessageMap;
        }
    }
}

