/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.service.mgt.multitenancy;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.ArtifactUnloader;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.service.mgt.internal.DataHolder;
import org.wso2.carbon.utils.deployment.DeploymentFileDataWrapper;
import org.wso2.carbon.utils.deployment.GhostArtifactRepository;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class ServiceUnloader
implements ArtifactUnloader {
    private static final Log log = LogFactory.getLog(ServiceUnloader.class);
    private static final long DEFAULT_MAX_INACTIVE_INTERVAL = 10L;

    public void unload() {
        ConfigurationContext mainConfigCtx = DataHolder.getServerConfigContext();
        if (mainConfigCtx == null) {
            return;
        }
        try {
            Set ccEntries = TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)mainConfigCtx).entrySet();
            for (Map.Entry entry : ccEntries) {
                String tenantDomain = (String)entry.getKey();
                this.unloadInactiveServices((ConfigurationContext)entry.getValue(), tenantDomain);
            }
            this.unloadInactiveServices(mainConfigCtx, "carbon.super");
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while unloading inactive services..", (Throwable)axisFault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadInactiveServices(ConfigurationContext configCtx, String tenantDomain) throws AxisFault {
        AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
        int tenantId = MultitenantUtils.getTenantId((ConfigurationContext)configCtx);
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext ctx = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            if (tenantId == -1234) {
                ctx.setTenantId(-1234);
                ctx.setTenantDomain("carbon.super");
            } else {
                ctx.setTenantId(tenantId);
                ctx.setTenantDomain(tenantDomain);
            }
            if (axisConfig != null) {
                Collection services = axisConfig.getServices().values();
                for (AxisService service : services) {
                    File ghostFile;
                    AxisServiceGroup ghostServiceGroup;
                    Parameter lastUsageParam;
                    if (this.isSkippedServiceType(service) || (lastUsageParam = service.getParameter("lastUsedTime")) == null || !this.isInactive((Long)lastUsageParam.getValue()) || service.getFileName() == null) continue;
                    AxisServiceGroup existingSG = (AxisServiceGroup)service.getParent();
                    log.info((Object)("Unloading actual Service Group : " + existingSG.getServiceGroupName() + " and adding a Ghost Service Group. " + "Tenant Domain: " + tenantDomain));
                    existingSG.addParameter("isBeingUnloaded", (Object)"true");
                    GhostDeployerUtils.addServiceGroupToTransitMap((AxisServiceGroup)existingSG, (AxisConfiguration)axisConfig);
                    existingSG.addParameter("keepServiceHistory", (Object)"true");
                    axisConfig.removeServiceGroup(existingSG.getServiceGroupName());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Successfully removed actual Service Group : " + existingSG.getServiceGroupName() + " Tenant Domain: " + tenantDomain));
                    }
                    if ((ghostServiceGroup = GhostDeployerUtils.createGhostServiceGroup((AxisConfiguration)axisConfig, (File)(ghostFile = GhostDeployerUtils.getGhostFile((String)service.getFileName().getPath(), (AxisConfiguration)axisConfig)), (URL)service.getFileName())) == null) continue;
                    axisConfig.addServiceGroup(ghostServiceGroup);
                    GhostArtifactRepository ghostArtifactRegistry = GhostDeployerUtils.getGhostArtifactRepository((AxisConfiguration)axisConfig);
                    DeploymentFileDataWrapper ghostingDfdWrapper = ghostArtifactRegistry.getDeploymentFileData(service.getFileName().getPath());
                    ghostArtifactRegistry.addDeploymentFileData(ghostingDfdWrapper.getDeploymentFileData(), Boolean.TRUE.booleanValue());
                    GhostDeployerUtils.removeServiceGroupFromTransitMap((AxisServiceGroup)ghostServiceGroup, (AxisConfiguration)axisConfig);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Successfully added Ghost Service Group : " + ghostServiceGroup.getServiceGroupName() + " Tenant Domain: " + tenantDomain));
                }
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private boolean isInactive(Long lastUsedTime) {
        long inactiveInterval = System.currentTimeMillis() - lastUsedTime;
        long maxInactiveInterval = 10L;
        String property = System.getProperty("service.idle.time");
        if (property != null) {
            maxInactiveInterval = Long.parseLong(property);
        }
        return inactiveInterval > maxInactiveInterval * 60L * 1000L;
    }

    private boolean isSkippedServiceType(AxisService service) {
        String serviceType = null;
        Parameter serviceTypeParam = service.getParameter("serviceType");
        if (serviceTypeParam != null) {
            serviceType = (String)serviceTypeParam.getValue();
        }
        return serviceType != null && serviceType.equals("bpel");
    }
}

