/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.service.mgt.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.application.deployer.service.ApplicationManagerService;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.ArtifactUnloader;
import org.wso2.carbon.service.mgt.ServiceAdmin;
import org.wso2.carbon.service.mgt.internal.DataHolder;
import org.wso2.carbon.service.mgt.multitenancy.ServiceUnloader;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.MBeanRegistrar;

public class ServiceManagementServiceComponent {
    private static Log log = LogFactory.getLog(ServiceManagementServiceComponent.class);
    private ConfigurationContext configCtx;
    private ServiceAdmin serviceAdmin;
    private static ApplicationManagerService applicationManager;

    protected void activate(ComponentContext ctxt) {
        try {
            BundleContext bundleContext = ctxt.getBundleContext();
            ServiceUnloader serviceUnloader = new ServiceUnloader();
            bundleContext.registerService(ArtifactUnloader.class.getName(), (Object)serviceUnloader, null);
            if (this.serviceAdmin != null) {
                this.serviceAdmin.setConfigurationContext(this.configCtx);
            }
            try {
                ServiceAdmin serviceAdmin = new ServiceAdmin(this.configCtx.getAxisConfiguration());
                bundleContext.registerService(ServiceAdmin.class.getName(), (Object)serviceAdmin, null);
            }
            catch (Exception exception) {
                String msg = "An error occured while initializing ServiceAdmin as an OSGi Service";
                log.error((Object)msg, (Throwable)exception);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate the ServiceManagementServiceComponent", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deactivated ServiceManagementServiceComponent");
        }
    }

    protected void setConfigurationContext(ConfigurationContextService configCtx) {
        this.configCtx = configCtx.getServerConfigContext();
        DataHolder.setServerConfigContext(configCtx.getServerConfigContext());
    }

    protected void unsetConfigurationContext(ConfigurationContextService configCtx) {
        this.configCtx = null;
    }

    protected void setServerConfiguration(ServerConfigurationService serverConfigurationService) {
        this.registerMBeans(serverConfigurationService);
    }

    protected void unsetServerConfiguration(ServerConfigurationService serverConfigurationServiceg) {
    }

    private void registerMBeans(ServerConfigurationService serverConfigurationService) {
        try {
            this.serviceAdmin = new ServiceAdmin();
            if (this.configCtx != null) {
                this.serviceAdmin.setConfigurationContext(this.configCtx);
            }
            MBeanRegistrar.registerMBean((Object)this.serviceAdmin);
        }
        catch (Exception e) {
            log.error((Object)"Error initializing ServiceAdmin.");
        }
    }

    protected void setAppManager(ApplicationManagerService applicationManager) {
        ServiceManagementServiceComponent.applicationManager = applicationManager;
        DataHolder.setApplicationManager(applicationManager);
    }

    protected void unsetAppManager(ApplicationManagerService applicationManager) {
        ServiceManagementServiceComponent.applicationManager = null;
    }
}

