/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.service.mgt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.util.PolicyLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.core.persistence.ServicePersistenceManager;
import org.wso2.carbon.core.persistence.file.ModuleFilePersistenceManager;
import org.wso2.carbon.core.persistence.file.ServiceGroupFilePersistenceManager;
import org.wso2.carbon.core.transports.TransportPersistenceManager;
import org.wso2.carbon.core.util.ParameterUtil;
import org.wso2.carbon.core.util.SystemFilter;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.security.SecurityConfigException;
import org.wso2.carbon.security.config.SecurityConfigAdmin;
import org.wso2.carbon.security.config.service.SecurityScenarioData;
import org.wso2.carbon.service.mgt.FaultyService;
import org.wso2.carbon.service.mgt.FaultyServicesWrapper;
import org.wso2.carbon.service.mgt.PolicyMetaData;
import org.wso2.carbon.service.mgt.PolicyUtil;
import org.wso2.carbon.service.mgt.ServiceAdminMBean;
import org.wso2.carbon.service.mgt.ServiceConstants;
import org.wso2.carbon.service.mgt.ServiceDownloadData;
import org.wso2.carbon.service.mgt.ServiceGroupMetaData;
import org.wso2.carbon.service.mgt.ServiceMetaData;
import org.wso2.carbon.service.mgt.ServiceMetaDataWrapper;
import org.wso2.carbon.service.mgt.internal.DataHolder;
import org.wso2.carbon.service.mgt.sync.ServiceSynchronizeRequest;
import org.wso2.carbon.service.mgt.util.Utils;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.DataPaginator;
import org.wso2.carbon.utils.FileManipulator;
import org.wso2.carbon.utils.Pageable;
import org.wso2.carbon.utils.ServerException;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public class ServiceAdmin
extends AbstractAdmin
implements ServiceAdminMBean {
    private static final Log log = LogFactory.getLog(ServiceAdmin.class);
    private static final String SERVICE_MUST_CONTAIN_AT_LEAST_ONE_TRANSPORT = "Cannot remove transport binding. <br/>A service must contain at least one transport binding!";
    private static final int DEFAULT_ITEMS_PER_PAGE = 10;
    public static final String DISABLE_TRY_IT_PARAM = "disableTryIt";
    public static final String DISABLE_DELETION_PARAM = "disableDeletion";
    private static final String AXIS2_SERVICE_TYPE = "axis2";
    private PersistenceFactory pf = PersistenceFactory.getInstance((AxisConfiguration)this.getAxisConfig());
    private ServicePersistenceManager spm = this.pf.getServicePM();

    public ServiceAdmin() throws Exception {
    }

    public ServiceAdmin(AxisConfiguration axisConfig) throws Exception {
        super(axisConfig);
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        super.setConfigurationContext(configurationContext);
    }

    public void addPoliciesToService(String serviceName, Policy policy, int policyType, String[] modulePaths) throws Exception {
        OMElement policyElement;
        AxisService axisService = this.getAxisService(serviceName);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        ServiceGroupFilePersistenceManager sfpm = this.pf.getServiceGroupFilePM();
        OMElement policyWrapperElement = omFactory.createOMElement("policy", null);
        policyWrapperElement.addAttribute("policyType", "" + policyType, null);
        if (policy.getId() == null) {
            policy.setId(UIDGenerator.generateUID());
            policyWrapperElement.addAttribute("policyUUID", "" + policy.getId(), null);
            policyElement = PersistenceUtils.createPolicyElement((Policy)policy);
            policyWrapperElement.addChild((OMNode)policyElement);
        } else {
            policyElement = PersistenceUtils.createPolicyElement((Policy)policy);
            policyWrapperElement.addAttribute("policyUUID", "" + policy.getId(), null);
            policyWrapperElement.addChild((OMNode)policyElement);
        }
        String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
        String policyResourcePath = serviceXPath + "/" + "policies" + "/" + "policy" + PersistenceUtils.getXPathAttrPredicate((String)"policyUUID", (String)policy.getId());
        boolean transactionStarted1 = sfpm.isTransactionStarted(serviceGroupId);
        if (!transactionStarted1) {
            sfpm.beginTransaction(serviceGroupId);
        }
        if (sfpm.elementExists(serviceGroupId, policyResourcePath)) {
            sfpm.get(serviceGroupId, policyResourcePath).detach();
        }
        sfpm.put(serviceGroupId, policyWrapperElement, serviceXPath + "/" + "policies");
        if (!transactionStarted1) {
            sfpm.commitTransaction(serviceGroupId);
        }
        Map endPointMap = axisService.getEndpoints();
        Iterator iterator = endPointMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            AxisEndpoint point = (AxisEndpoint)entry.getValue();
            AxisBinding binding = point.getBinding();
            binding.applyPolicy(policy);
        }
        try {
            boolean transactionStarted = sfpm.isTransactionStarted(serviceGroupId);
            if (!transactionStarted) {
                sfpm.beginTransaction(serviceGroupId);
            }
            for (String path : modulePaths) {
                String[] values = path.split("/");
                String moduleName = values[0];
                String moduleVersion = values[1];
                OMElement modAssoc = PersistenceUtils.createModule((String)moduleName, (String)moduleVersion, (String)"requiredModules");
                sfpm.put(serviceGroupId, modAssoc, policyResourcePath);
                this.engageModuleToService(serviceName, moduleName, moduleVersion);
            }
            if (!transactionStarted) {
                sfpm.commitTransaction(serviceGroupId);
            }
        }
        catch (Exception e) {
            sfpm.rollbackTransaction(serviceGroupId);
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public void removeServicePoliciesByNamespace(String serviceName, String namesapce) throws Exception {
        try {
            AxisService service = this.getAxisConfig().getServiceForActivation(serviceName);
            String serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
            OMFactory omFactory = OMAbstractFactory.getOMFactory();
            ServiceGroupFilePersistenceManager sfpm = this.pf.getServiceGroupFilePM();
            String serviceXPath = PersistenceUtils.getResourcePath((AxisService)service);
            String policyResourcePath = serviceXPath + "/" + "policies" + "/" + "policy";
            ArrayList<String> removedModuleAssociations = new ArrayList<String>();
            boolean isTransactionStarted = sfpm.isTransactionStarted(serviceGroupId);
            if (!isTransactionStarted) {
                sfpm.beginTransaction(serviceGroupId);
            }
            if (sfpm.elementExists(serviceGroupId, policyResourcePath)) {
                List policyWrappers = sfpm.getAll(serviceGroupId, policyResourcePath);
                for (Object object : policyWrappers) {
                    OMElement policyWrapper = (OMElement)object;
                    OMElement element = policyWrapper.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy"));
                    Policy policy = PolicyEngine.getPolicy((OMElement)element);
                    this.removeAssertionsByNamespace(policy, namesapce);
                    int iValue = policy.getAssertions().size();
                    if (iValue == 1) {
                        List values = sfpm.getAll(serviceGroupId, policyResourcePath + PersistenceUtils.getXPathAttrPredicate((String)"policyUUID", (String)policyWrapper.getAttributeValue(new QName("policyUUID"))) + "/" + "module" + PersistenceUtils.getXPathAttrPredicate((String)"type", (String)"requiredModules"));
                        for (Object val : values) {
                            OMElement moduleAssoc = (OMElement)val;
                            removedModuleAssociations.add(moduleAssoc.getAttributeValue(new QName("name")) + "/" + moduleAssoc.getAttributeValue(new QName("version")));
                        }
                    }
                    policyWrapper.detach();
                }
            }
            if (!isTransactionStarted) {
                sfpm.commitTransaction(serviceGroupId);
            }
            Map endPointMap = service.getEndpoints();
            for (Object object : endPointMap.entrySet()) {
                Map.Entry entry = (Map.Entry)object;
                AxisEndpoint point = (AxisEndpoint)entry.getValue();
                AxisBinding binding = point.getBinding();
                Policy policy = binding.getEffectivePolicy();
                this.removeAssertionsByNamespace(policy, namesapce);
            }
            this.disengageUnusedModuleFromAxisService(serviceName, removedModuleAssociations);
        }
        catch (Exception e) {
            throw new Exception("errorRemovingServicePolicies", e);
        }
    }

    private void disengageUnusedModuleFromAxisService(String serviceName, List<String> checkList) throws Exception {
        AxisService axisService = this.getAxisService(serviceName);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        ServiceGroupFilePersistenceManager sfpm = this.pf.getServiceGroupFilePM();
        String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
        String policyResourcePath = serviceXPath + "/" + "policies" + "/" + "policy";
        boolean isTransactionStarted = sfpm.isTransactionStarted(serviceGroupId);
        if (!isTransactionStarted) {
            sfpm.beginTransaction(serviceGroupId);
        }
        boolean doDisengage = true;
        for (String moduleInfo : checkList) {
            List policyWrappers = sfpm.getAll(serviceGroupId, policyResourcePath);
            for (Object obj : policyWrappers) {
                OMElement policyWrapper = (OMElement)obj;
                List values = sfpm.getAll(serviceGroupId, policyResourcePath + PersistenceUtils.getXPathAttrPredicate((String)"policyUUID", (String)policyWrapper.getAttributeValue(new QName("policyUUID"))) + "/" + "module" + PersistenceUtils.getXPathAttrPredicate((String)"type", (String)"requiredModules"));
                for (Object val : values) {
                    OMElement moduleAss = (OMElement)val;
                    String moduleInfoEl = moduleAss.getAttribute(new QName("name")) + "/" + moduleAss.getAttribute(new QName("version"));
                    if (!moduleInfoEl.equals(moduleInfo)) continue;
                    doDisengage = false;
                    break;
                }
                if (doDisengage) continue;
                break;
            }
            if (doDisengage) {
                Object obj;
                List serviceAss = sfpm.getAll(serviceGroupId, serviceXPath + "/" + "module" + PersistenceUtils.getXPathAttrPredicate((String)"type", (String)"engagedModules"));
                obj = serviceAss.iterator();
                while (obj.hasNext()) {
                    Object obj2 = obj.next();
                    OMElement moduleAss = (OMElement)obj2;
                    String moduleInfoEl = moduleAss.getAttribute(new QName("name")) + "/" + moduleAss.getAttribute(new QName("version"));
                    if (!moduleInfoEl.equals(moduleInfo)) continue;
                    doDisengage = false;
                    break;
                }
            }
            if (!doDisengage) continue;
            String[] values = moduleInfo.split("/");
            String moduleName = values[values.length - 2];
            String moduleVersion = values[values.length - 1];
            axisService.disengageModule(axisService.getAxisConfiguration().getModule(moduleName, moduleVersion));
        }
        if (!isTransactionStarted) {
            sfpm.commitTransaction(serviceGroupId);
        }
    }

    public void engageModuleToService(String serviceName, String moduleName, String version) throws Exception {
        AxisService axisService = this.getAxisService(serviceName);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
        ServiceGroupFilePersistenceManager sfpm = this.pf.getServiceGroupFilePM();
        OMElement modElement = PersistenceUtils.createModule((String)moduleName, (String)version, (String)"engagedModules");
        if (!sfpm.elementExists(serviceGroupId, serviceXPath + "/" + "module" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)moduleName) + PersistenceUtils.getXPathAttrPredicate((String)"version", (String)version))) {
            this.pf.getServiceGroupFilePM().put(serviceGroupId, modElement, serviceXPath);
        }
        AxisModule module = axisService.getAxisConfiguration().getModule(moduleName);
        axisService.disengageModule(module);
        axisService.engageModule(module);
    }

    private void removeAssertionsByNamespace(Policy policy, String namespace) {
        List lst = policy.getAssertions();
        Iterator itePolices = lst.iterator();
        while (itePolices.hasNext()) {
            Assertion assertion;
            PolicyComponent comp = (PolicyComponent)itePolices.next();
            if (!(comp instanceof Assertion) || !(assertion = (Assertion)comp).getName().getNamespaceURI().equals(namespace)) continue;
            itePolices.remove();
        }
    }

    public ServiceGroupMetaData listServiceGroup(String serviceGroupName) throws AxisFault {
        ServiceGroupMetaData sgmd = new ServiceGroupMetaData();
        AxisServiceGroup serviceGroup = this.getAxisConfig().getServiceGroup(serviceGroupName);
        sgmd.setServiceGroupName(serviceGroup.getServiceGroupName());
        Parameter parameter = serviceGroup.getParameter("enableMTOM");
        if (parameter != null) {
            sgmd.setMtomStatus((String)parameter.getValue());
        }
        return sgmd;
    }

    public ServiceMetaDataWrapper listServices(String serviceTypeFilter, String serviceSearchString, int pageNumber) throws AxisFault {
        if (serviceTypeFilter == null) {
            serviceTypeFilter = "ALL";
        }
        if (pageNumber < 0 || pageNumber == Integer.MAX_VALUE) {
            pageNumber = 0;
        }
        ArrayList<ServiceMetaData> serviceList = new ArrayList<ServiceMetaData>();
        TreeSet<String> serviceTypes = new TreeSet<String>();
        serviceTypes.add(AXIS2_SERVICE_TYPE);
        HashMap axisServices = this.getAxisConfig().getServices();
        Set axisFaultServices = this.getAxisConfig().getFaultyServices().keySet();
        ArrayList<AxisService> axisServicesList = new ArrayList<AxisService>();
        Map originalTransitGhosts = GhostDeployerUtils.getTransitGhostServicesMap((AxisConfiguration)this.getAxisConfig());
        HashMap clonedTransitGhosts = new HashMap();
        clonedTransitGhosts.putAll(originalTransitGhosts);
        for (Map.Entry entry : axisServices.entrySet()) {
            AxisService axisService = (AxisService)entry.getValue();
            if (SystemFilter.isAdminService((AxisService)axisService) || SystemFilter.isHiddenService((AxisService)axisService)) continue;
            String serviceType = AXIS2_SERVICE_TYPE;
            Parameter serviceTypeParam = axisService.getParameter("serviceType");
            if (serviceTypeParam != null) {
                serviceType = (String)serviceTypeParam.getValue();
                serviceTypes.add(serviceType);
            }
            if (axisService.isClientSide() || !serviceTypeFilter.equals("ALL") && !serviceTypeFilter.equals(serviceType) || serviceSearchString != null && serviceSearchString.trim().length() > 0 && !this.isServiceSatisfySearchString(serviceSearchString, axisService.getName())) continue;
            axisServicesList.add(axisService);
            if (!clonedTransitGhosts.containsKey(axisService.getName())) continue;
            clonedTransitGhosts.remove(axisService.getName());
        }
        Collection transitGhosts = clonedTransitGhosts.values();
        for (Object transitGhost : transitGhosts) {
            axisServicesList.add((AxisService)transitGhost);
        }
        if (axisServicesList.size() > 0) {
            Collections.sort(axisServicesList, new Comparator<AxisService>(){

                @Override
                public int compare(AxisService arg0, AxisService arg1) {
                    return arg0.getName().compareToIgnoreCase(arg1.getName());
                }
            });
        }
        ArrayList<AxisService> axisServicesRequiredForPage = new ArrayList<AxisService>();
        for (AxisService anAxisServicesList : axisServicesList) {
            axisServicesRequiredForPage.add(anAxisServicesList);
        }
        for (AxisService axisService : axisServicesRequiredForPage) {
            String serviceType = AXIS2_SERVICE_TYPE;
            Parameter serviceTypeParam = axisService.getParameter("serviceType");
            if (serviceTypeParam != null) {
                serviceType = (String)serviceTypeParam.getValue();
                serviceTypes.add(serviceType);
            }
            ServiceMetaData service = new ServiceMetaData();
            String serviceName = axisService.getName();
            service.setName(serviceName);
            service.setCAppArtifact(this.isAxisServiceCApp(axisService));
            serviceTypeParam = axisService.getParameter("serviceType");
            if (serviceTypeParam != null) {
                serviceType = (String)serviceTypeParam.getValue();
            }
            service.setServiceType(serviceType);
            AxisConfiguration axisConfiguration = this.getAxisConfig();
            service.setWsdlURLs(Utils.getWsdlInformation(serviceName, axisConfiguration));
            service.setTryitURL(Utils.getTryitURL(serviceName, this.getConfigContext()));
            service.setActive(axisService.isActive());
            Parameter parameter = axisService.getParameter(DISABLE_TRY_IT_PARAM);
            if (parameter != null && Boolean.TRUE.toString().equalsIgnoreCase((String)parameter.getValue())) {
                service.setDisableTryit(true);
            }
            if ((parameter = axisService.getParameter(DISABLE_DELETION_PARAM)) != null && Boolean.TRUE.toString().equalsIgnoreCase((String)parameter.getValue())) {
                service.setDisableDeletion(true);
            }
            service.setServiceGroupName(axisService.getAxisServiceGroup().getServiceGroupName());
            if (GhostDeployerUtils.isGhostService((AxisService)axisService)) {
                Parameter secParam = axisService.getParameter("securityScenario");
                if (secParam != null) {
                    service.setSecurityScenarioId((String)secParam.getValue());
                }
            } else {
                SecurityScenarioData securityScenario = this.getSecurityScenario(serviceName);
                if (securityScenario != null) {
                    service.setSecurityScenarioId(securityScenario.getScenarioId());
                }
            }
            if (axisFaultServices.contains(axisService.getName())) continue;
            serviceList.add(service);
        }
        ServiceMetaDataWrapper wrapper = new ServiceMetaDataWrapper();
        wrapper.setNumberOfCorrectServiceGroups(this.getNumberOfServiceGroups());
        wrapper.setNumberOfFaultyServiceGroups(this.getNumberOfFaultyServices());
        wrapper.setServiceTypes(serviceTypes.toArray(new String[serviceTypes.size()]));
        wrapper.setNumberOfActiveServices(this.getNumberOfActiveServices());
        DataPaginator.doPaging((int)pageNumber, serviceList, (Pageable)wrapper);
        return wrapper;
    }

    private boolean isServiceSatisfySearchString(String serviceSearchString, String axisServiceName) {
        if (serviceSearchString != null) {
            String regex = serviceSearchString.toLowerCase().replace("..?", ".?").replace("..*", ".*").replaceAll("\\?", ".?").replaceAll("\\*", ".*?");
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(axisServiceName.toLowerCase());
            return regex.trim().length() == 0 || matcher.find();
        }
        return false;
    }

    public int getNumberOfServiceGroups() throws AxisFault {
        ArrayList<String> sgList = new ArrayList<String>();
        Iterator serviceGroups = this.getAxisConfig().getServiceGroups();
        while (serviceGroups.hasNext()) {
            AxisServiceGroup serviceGroup = (AxisServiceGroup)serviceGroups.next();
            if (SystemFilter.isFilteredOutService((AxisServiceGroup)serviceGroup) || !serviceGroup.getServices().hasNext() || ((AxisService)serviceGroup.getServices().next()).isClientSide()) continue;
            sgList.add(serviceGroup.getServiceGroupName());
        }
        Map transitGhostServicesMap = GhostDeployerUtils.getTransitGhostServicesMap((AxisConfiguration)this.getAxisConfig());
        Collection transitServices = transitGhostServicesMap.values();
        for (AxisService transitGhost : transitServices) {
            AxisServiceGroup sg = transitGhost.getAxisServiceGroup();
            if (sgList.contains(sg.getServiceGroupName())) continue;
            sgList.add(sg.getServiceGroupName());
        }
        Set faultServices = this.getAxisConfig().getFaultyServices().keySet();
        sgList.removeAll(faultServices);
        return sgList.size();
    }

    @Override
    public int getNumberOfActiveServices() throws AxisFault {
        ArrayList<String> activeList = new ArrayList<String>();
        HashMap services = this.getAxisConfig().getServices();
        Set faultServices = this.getAxisConfig().getFaultyServices().keySet();
        for (AxisService service : services.values()) {
            if (SystemFilter.isFilteredOutService((AxisServiceGroup)((AxisServiceGroup)service.getParent())) || service.isClientSide() || !service.isActive() || faultServices.contains(service.getName())) continue;
            activeList.add(service.getName());
        }
        Map transitGhostServicesMap = GhostDeployerUtils.getTransitGhostServicesMap((AxisConfiguration)this.getAxisConfig());
        Collection transitServices = transitGhostServicesMap.values();
        for (AxisService transitGhost : transitServices) {
            if (!transitGhost.isActive() || activeList.contains(transitGhost.getName())) continue;
            activeList.add(transitGhost.getName());
        }
        return activeList.size();
    }

    @Override
    public int getNumberOfInactiveServices() throws Exception {
        int inactiveServices = 0;
        HashMap services = this.getAxisConfig().getServices();
        for (AxisService service : services.values()) {
            if (SystemFilter.isFilteredOutService((AxisServiceGroup)((AxisServiceGroup)service.getParent())) || service.isActive()) continue;
            ++inactiveServices;
        }
        return inactiveServices;
    }

    @Override
    public int getNumberOfFaultyServices() {
        return this.getAxisConfig().getFaultyServices().size();
    }

    public FaultyServicesWrapper getFaultyServiceArchives(int pageNumber) throws AxisFault {
        AxisConfiguration ac = this.getAxisConfig();
        String repository = ac.getRepository().getPath();
        Hashtable faultyServices = ac.getFaultyServices();
        ArrayList<FaultyService> fsList = new ArrayList<FaultyService>();
        for (Map.Entry entry : faultyServices.entrySet()) {
            String artifactPath;
            String serviceName = artifactPath = (String)entry.getKey();
            String fault = (String)entry.getValue();
            FaultyService fs = new FaultyService();
            if (File.separatorChar == '\\') {
                serviceName = serviceName.replace('\\', '/');
                if ((repository = repository.replace('\\', '/')).startsWith("/")) {
                    repository = repository.substring(1);
                }
            }
            if (serviceName.endsWith("/")) {
                serviceName = serviceName.substring(0, serviceName.length() - 1);
            }
            if (repository.endsWith("/")) {
                repository = repository.substring(0, repository.length() - 1);
            }
            if (serviceName.startsWith(repository)) {
                serviceName = serviceName.substring(repository.length() + 1);
                serviceName = serviceName.substring(serviceName.indexOf(47) + 1);
            }
            int slashIndex = serviceName.lastIndexOf(47);
            int dotIndex = serviceName.lastIndexOf(46);
            if (dotIndex != -1 && dotIndex > slashIndex) {
                serviceName = serviceName.substring(0, dotIndex);
            }
            AxisService axisService = CarbonUtils.getFaultyService((String)artifactPath, (ConfigurationContext)this.getConfigContext());
            fs.setServiceName(serviceName);
            fs.setFault(fault);
            if (File.separatorChar == '\\') {
                artifactPath = artifactPath.replace('\\', '/');
            }
            if (axisService != null) {
                fs.setArtifact(artifactPath.replace(repository, ""));
                fs.setServiceType(this.getServiceType(axisService));
                fsList.add(fs);
                continue;
            }
            axisService = ac.getService(serviceName);
            if (artifactPath.startsWith(repository)) {
                artifactPath = artifactPath.replace(repository, "");
                fs.setArtifact(artifactPath);
            }
            fs.setServiceName(serviceName);
            fs.setFault(fault);
            if (axisService != null) {
                fs.setServiceType(this.getServiceType(axisService));
            }
            fsList.add(fs);
        }
        FaultyServicesWrapper wrapper = null;
        if (fsList.size() > 0) {
            Collections.sort(fsList, new Comparator<FaultyService>(){

                @Override
                public int compare(FaultyService arg0, FaultyService arg1) {
                    return arg0.getServiceName().compareToIgnoreCase(arg1.getServiceName());
                }
            });
            wrapper = new FaultyServicesWrapper();
            wrapper.setNumberOfFaultyServiceGroups(this.getNumberOfFaultyServices());
            DataPaginator.doPaging((int)pageNumber, fsList, (Pageable)wrapper);
        }
        return wrapper;
    }

    public boolean deleteFaultyServiceGroup(String archiveName) throws AxisFault {
        String repository = this.getAxisConfig().getRepository().getPath();
        String originalName = archiveName;
        if (repository.endsWith("/")) {
            repository = repository.substring(0, repository.length() - 1);
        }
        if (File.separatorChar == '\\') {
            archiveName = archiveName.replace('/', '\\');
            if (repository.startsWith("/")) {
                repository = repository.substring(1);
            }
            repository = repository.replace('/', '\\');
        }
        if (archiveName.indexOf(repository) != 0) {
            originalName = repository + archiveName;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting faulty service archive " + archiveName));
        }
        boolean isDeleted = false;
        if (archiveName.trim().length() != 0) {
            File file = new File(originalName);
            if (file.exists()) {
                if (!(file.isDirectory() && FileManipulator.deleteDir((File)file) || file.delete())) {
                    throw new AxisFault("Faulty service archive deletion failed. Due to a JVM issue on MS-Windows, service archive files cannot be deleted. Please stop the server and manually delete this file.");
                }
                isDeleted = true;
                this.getAxisConfig().getFaultyServices().remove(originalName);
            }
        } else {
            isDeleted = true;
            this.getAxisConfig().getFaultyServices().remove(archiveName);
            this.deleteServiceGroup(archiveName);
        }
        return isDeleted;
    }

    public void deleteAllNonAdminServiceGroups() throws AxisFault {
        Iterator iter = this.getAxisConfig().getServiceGroups();
        while (iter.hasNext()) {
            AxisServiceGroup asGroup = (AxisServiceGroup)iter.next();
            if (SystemFilter.isFilteredOutService((AxisServiceGroup)asGroup)) continue;
            this.deleteServiceGroup(asGroup.getServiceGroupName());
        }
    }

    public void deleteAllFaultyServiceGroups() throws AxisFault {
        for (String fileName : this.getAxisConfig().getFaultyServices().values()) {
            this.deleteFaultyServiceGroup(fileName);
        }
    }

    public boolean checkForGroupedServices(String[] serviceGroupsList) throws AxisFault {
        AxisConfiguration axisConfig = this.getAxisConfig();
        for (String serviceGroup : serviceGroupsList) {
            AxisServiceGroup asGroup = axisConfig.getServiceGroup(serviceGroup);
            int count = 0;
            Iterator serviceIter = asGroup.getServices();
            while (serviceIter.hasNext()) {
                serviceIter.next();
                if (++count <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public void deleteServiceGroups(String[] serviceGroups) throws AxisFault {
        HashSet<String> serviceGroupsSet = new HashSet<String>(Arrays.asList(serviceGroups));
        String[] serviceGroupsArray = new String[serviceGroupsSet.size()];
        serviceGroupsSet.toArray(serviceGroupsArray);
        for (String serviceGroup : serviceGroupsArray) {
            this.deleteServiceGroup(serviceGroup);
        }
    }

    public void deleteFaultyServiceGroups(String[] fileNames) throws AxisFault {
        for (String fileName : fileNames) {
            this.deleteFaultyServiceGroup(fileName);
        }
    }

    private void deleteServiceGroup(String serviceGroupName) throws AxisFault {
        File ghostFile;
        AxisConfiguration axisConfig = this.getAxisConfig();
        AxisServiceGroup asGroup = axisConfig.getServiceGroup(serviceGroupName);
        if (asGroup == null) {
            throw new AxisFault("Invalid service group name " + serviceGroupName);
        }
        if (SystemFilter.isFilteredOutService((AxisServiceGroup)asGroup)) {
            String msg = "Cannot delete admin service group " + serviceGroupName;
            log.error((Object)msg);
            throw new AxisFault(msg);
        }
        String fileName = null;
        Iterator serviceIter = asGroup.getServices();
        while (serviceIter.hasNext()) {
            PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            AxisService axisService = (AxisService)serviceIter.next();
            URL fn = axisService.getFileName();
            if (fn != null) {
                fileName = fn.getPath();
            }
            privilegedCarbonContext.setApplicationName(axisService.getName());
            if ("proxy".equalsIgnoreCase(this.getServiceType(axisService))) {
                axisService.addParameter("originator", (Object)"ServiceAdmin");
                axisConfig.removeService(axisService.getName());
                log.info((Object)("Undeploying Axis2 Service: " + axisService.getName()));
                Registry registry = this.getConfigSystemRegistry();
                String servicePath = "/repository/axis2/service-groups/" + axisService.getAxisServiceGroup().getServiceGroupName() + "/" + "services" + "/" + axisService.getName();
                try {
                    registry.delete(servicePath);
                }
                catch (RegistryException e) {
                    log.warn((Object)("Unable to delete registry collection conf:" + servicePath), (Throwable)e);
                }
            }
            if (fileName == null || !fileName.contains("carbonapps") || axisConfig.getService(axisService.getName()) == null) continue;
            axisConfig.removeService(axisService.getName());
            log.info((Object)("Undeploying Axis2 Service: " + axisService.getName()));
        }
        if (fileName != null && fileName.trim().length() != 0) {
            File file;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting service file " + fileName));
            }
            if (!(!(file = new File(fileName)).exists() || file.isDirectory() && FileManipulator.deleteDir((File)file) || file.delete())) {
                log.error((Object)("Service file/directory deletion failed : " + fileName));
            }
            if (serviceGroupName.lastIndexOf(File.separator) != -1) {
                String firstHierarchicalDir = serviceGroupName.substring(0, serviceGroupName.indexOf(File.separator));
                Utils.deleteEmptyDirsOnPath(fileName, firstHierarchicalDir);
            }
        }
        if ((ghostFile = GhostDeployerUtils.getGhostFile((String)fileName, (AxisConfiguration)axisConfig)) != null && ghostFile.exists() && !ghostFile.delete()) {
            log.error((Object)("Error while deleting ghost service file : " + ghostFile.getAbsolutePath()));
        }
    }

    public ServiceMetaData getServiceData(String serviceName) throws Exception {
        AxisService service = this.getAxisConfig().getServiceForActivation(serviceName);
        if (service == null) {
            Map transitGhostServicesMap = GhostDeployerUtils.getTransitGhostServicesMap((AxisConfiguration)this.getAxisConfig());
            service = (AxisService)transitGhostServicesMap.get(serviceName);
        }
        if (service == null) {
            String msg = "Invalid service name, service not found : " + serviceName;
            log.error((Object)msg);
            throw new AxisFault(msg);
        }
        if (GhostDeployerUtils.isGhostService((AxisService)service)) {
            service = GhostDeployerUtils.deployActualService((AxisConfiguration)this.getAxisConfig(), (AxisService)service);
        }
        String serviceType = this.getServiceType(service);
        ArrayList<String> ops = new ArrayList<String>();
        Iterator opIter = service.getOperations();
        while (opIter.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)opIter.next();
            if (axisOperation.getName() == null) continue;
            ops.add(axisOperation.getName().getLocalPart());
        }
        ServiceMetaData serviceMetaData = new ServiceMetaData();
        serviceMetaData.setOperations(ops.toArray(new String[ops.size()]));
        serviceMetaData.setName(serviceName);
        serviceMetaData.setServiceId(serviceName);
        serviceMetaData.setServiceVersion("");
        serviceMetaData.setActive(service.isActive());
        String[] eprs = this.getServiceEPRs(serviceName);
        serviceMetaData.setEprs(eprs);
        serviceMetaData.setServiceType(serviceType);
        AxisConfiguration axisConfiguration = this.getAxisConfig();
        serviceMetaData.setWsdlURLs(Utils.getWsdlInformation(serviceName, axisConfiguration));
        serviceMetaData.setTryitURL(Utils.getTryitURL(serviceName, this.getConfigContext()));
        AxisServiceGroup serviceGroup = (AxisServiceGroup)service.getParent();
        serviceMetaData.setFoundWebResources(serviceGroup.isFoundWebResources());
        serviceMetaData.setScope(service.getScope());
        serviceMetaData.setWsdlPorts(service.getEndpoints());
        serviceMetaData.setCAppArtifact(this.isAxisServiceCApp(service));
        Parameter deploymentTime = service.getParameter("serviceDeploymentTime");
        if (deploymentTime != null) {
            serviceMetaData.setServiceDeployedTime((Long)deploymentTime.getValue());
        }
        serviceMetaData.setServiceGroupName(serviceGroup.getServiceGroupName());
        SecurityScenarioData securityScenario = this.getSecurityScenario(serviceName);
        if (securityScenario != null) {
            serviceMetaData.setSecurityScenarioId(securityScenario.getScenarioId());
        }
        if (service.getDocumentation() != null) {
            serviceMetaData.setDescription(service.getDocumentation());
        } else {
            serviceMetaData.setDescription("No service description found");
        }
        Parameter parameter = service.getParameter("enableMTOM");
        if (parameter != null) {
            serviceMetaData.setMtomStatus((String)parameter.getValue());
        } else {
            serviceMetaData.setMtomStatus("false");
        }
        parameter = service.getParameter(DISABLE_TRY_IT_PARAM);
        if (parameter != null && Boolean.TRUE.toString().equalsIgnoreCase((String)parameter.getValue())) {
            serviceMetaData.setDisableTryit(true);
        }
        return serviceMetaData;
    }

    private SecurityScenarioData getSecurityScenario(String serviceName) throws AxisFault {
        try {
            return new SecurityConfigAdmin(this.getUserRealm(), this.getConfigSystemRegistry(), this.getAxisConfig()).getCurrentScenario(serviceName);
        }
        catch (SecurityConfigException e) {
            String msg = "Cannot retrieve security scenario for service " + serviceName;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    private String getServiceType(AxisService service) {
        Parameter serviceTypeParam = service.getParameter("serviceType");
        String serviceType = serviceTypeParam != null ? (String)serviceTypeParam.getValue() : AXIS2_SERVICE_TYPE;
        return serviceType;
    }

    private String[] getServiceEPRs(String serviceName) throws AxisFault {
        this.getAxisService(serviceName).setEPRs(null);
        try {
            return this.getAxisService(serviceName).getEPRs();
        }
        catch (NullPointerException ignored) {
            return new String[0];
        }
    }

    public void changeServiceState(String serviceName, boolean isActive) throws AxisFault {
        AxisService service;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Changing service Active state to " + isActive + " for service " + serviceName));
        }
        if ((service = this.getAxisService(serviceName)) == null) {
            String msg = "Service " + serviceName + " is not available";
            log.error((Object)msg);
            throw new AxisFault(msg);
        }
        if (isActive) {
            this.getAxisConfig().startService(serviceName);
            this.sendClusterSyncMessage(ServiceConstants.ServiceOperationType.ACTIVATE, serviceName);
        } else {
            this.getAxisConfig().stopService(serviceName);
            this.sendClusterSyncMessage(ServiceConstants.ServiceOperationType.DEACTIVATE, serviceName);
        }
        try {
            this.spm.setServiceProperty(service, "serviceActive", String.valueOf(isActive));
        }
        catch (Exception e) {
            String msg = "Cannot persist ACTIVE service parameter";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public void configureMTOM(String flag, String serviceName) throws AxisFault {
        AxisService service = this.getAxisConfig().getServiceForActivation(serviceName);
        if (service == null) {
            throw new AxisFault("AxisService " + serviceName + " cannot be found.");
        }
        String serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting the MTOM status to " + flag + " for service " + serviceName));
        }
        Parameter parameter = ParameterUtil.createParameter((String)"enableMTOM", (String)flag.trim());
        service.addParameter(parameter);
        Iterator iterator1 = service.getOperations();
        while (iterator1.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator1.next();
            axisOperation.addParameter(ParameterUtil.createParameter((String)"enableMTOM", (String)((String)parameter.getValue())));
        }
        try {
            this.spm.updateServiceParameter(service, parameter);
        }
        catch (Exception e) {
            String msg = "Cannot persist MTOM service parameter in the registry";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    @Override
    public void startService(String serviceName) throws Exception {
        AxisService axisService;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Activating service " + serviceName));
        }
        if ((axisService = this.getAxisConfig().getServiceForActivation(serviceName)) == null) {
            throw new Exception("Invalid service name " + serviceName);
        }
        try {
            this.getAxisConfig().startService(serviceName);
        }
        catch (AxisFault e) {
            String msg = "Cannot start service " + serviceName;
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    @Override
    public void stopService(String serviceName) throws Exception {
        AxisService axisService;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deactivating service " + serviceName));
        }
        if ((axisService = this.getAxisConfig().getServiceForActivation(serviceName)) == null) {
            throw new Exception("Invalid service name " + serviceName);
        }
        try {
            this.getAxisConfig().stopService(serviceName);
        }
        catch (AxisFault e) {
            String msg = "Cannot stop service " + serviceName;
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public String[] getExposedTransports(String serviceId) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceId);
        if (!axisService.isEnableAllTransports()) {
            List exposedTransports = axisService.getExposedTransports();
            return exposedTransports.toArray(new String[exposedTransports.size()]);
        }
        HashMap transportsIn = this.getConfigContext().getAxisConfiguration().getTransportsIn();
        String[] transports = new String[transportsIn.size()];
        int i = 0;
        for (Object o : transportsIn.values()) {
            TransportInDescription tiDesc = (TransportInDescription)o;
            transports[i++] = tiDesc.getName();
        }
        return transports;
    }

    public String addTransportBinding(String serviceId, String transportProtocol) throws Exception {
        if (transportProtocol == null || transportProtocol.trim().length() == 0) {
            return "Invalid transport " + transportProtocol;
        }
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceId);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        ServiceGroupFilePersistenceManager sfpm = this.pf.getServiceGroupFilePM();
        Registry registry = this.getConfigSystemRegistry();
        if (axisService.isExposedTransport(transportProtocol)) {
            return "Service [" + serviceId + "] already contains the " + transportProtocol + " transport binding!";
        }
        OMElement serviceElement = this.spm.getService(axisService);
        if (serviceElement == null) {
            this.spm.handleNewServiceAddition(axisService);
            serviceElement = this.spm.getService(axisService);
        }
        if (serviceElement.getAttribute(new QName("utEnabled")) != null && !transportProtocol.equalsIgnoreCase("https")) {
            throw new AxisFault("Cannot add non-HTTPS transport binding for Service [" + serviceId + "] since a security scenario which requires the " + "service to contain only the HTTPS transport binding" + " has been applied to this service.");
        }
        if (axisService.isEnableAllTransports()) {
            return "Service [" + serviceId + "] already contains the " + transportProtocol + " transport binding!";
        }
        axisService.addExposedTransport(transportProtocol);
        org.apache.axis2.deployment.util.Utils.addEndpointsToService((AxisService)axisService, (AxisConfiguration)this.axisConfig);
        Resource transportResource = new TransportPersistenceManager(this.getAxisConfig()).getTransportResource(transportProtocol);
        if (transportResource != null) {
            try {
                boolean regTransactionStarted = Transaction.isStarted();
                boolean fileTransactionStarted = sfpm.isTransactionStarted(serviceGroupId);
                if (!regTransactionStarted) {
                    this.getConfigSystemRegistry().beginTransaction();
                }
                if (!fileTransactionStarted) {
                    sfpm.beginTransaction(serviceGroupId);
                }
                serviceElement.addAttribute("exposedAllTransports", String.valueOf(false), null);
                sfpm.put(serviceGroupId, PersistenceUtils.createAssociation((String)transportResource.getPath(), (String)"exposedTransports"), PersistenceUtils.getResourcePath((AxisService)axisService));
                sfpm.put(serviceGroupId, serviceElement, PersistenceUtils.getResourcePath((AxisService)axisService));
                registry.put(transportResource.getPath(), transportResource);
                if (!regTransactionStarted) {
                    this.getConfigSystemRegistry().commitTransaction();
                }
                if (!fileTransactionStarted) {
                    sfpm.commitTransaction(serviceGroupId);
                }
            }
            catch (Exception e) {
                String msg = "Service with name " + serviceId + " not found.";
                log.error((Object)msg);
                sfpm.rollbackTransaction(serviceGroupId);
                try {
                    this.getConfigSystemRegistry().rollbackTransaction();
                }
                catch (RegistryException e1) {
                    throw AxisFault.makeFault((Throwable)e);
                }
                throw new AxisFault(msg, (Throwable)e);
            }
        }
        this.axisConfig.notifyObservers(new AxisEvent(100, (AxisDescription)axisService), axisService);
        return "Successfully added " + transportProtocol + " transport binding to service " + serviceId;
    }

    public String removeTransportBinding(String serviceId, String transportProtocol) throws Exception {
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceId);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        ServiceGroupFilePersistenceManager sfpm = this.pf.getServiceGroupFilePM();
        Registry registry = this.getConfigSystemRegistry();
        OMElement serviceElement = this.spm.getService(axisService);
        if (serviceElement == null) {
            this.spm.handleNewServiceAddition(axisService);
            serviceElement = this.spm.getService(axisService);
        }
        if (serviceElement.getAttribute(new QName("utEnabled")) != null && transportProtocol.equalsIgnoreCase("https")) {
            throw new AxisFault("Cannot add non-HTTPS transport binding for Service [" + serviceId + "] since a security scenario which requires the " + "service to contain only the HTTPS transport binding" + " has been applied to this service.");
        }
        try {
            boolean regTransactionStarted = Transaction.isStarted();
            boolean fileTransactionStarted = sfpm.isTransactionStarted(serviceGroupId);
            if (!regTransactionStarted) {
                this.getConfigSystemRegistry().beginTransaction();
            }
            if (!fileTransactionStarted) {
                sfpm.beginTransaction(serviceGroupId);
            }
            if (!axisService.isEnableAllTransports()) {
                Resource transportResource = new TransportPersistenceManager(this.getAxisConfig()).getTransportResource(transportProtocol);
                if (axisService.getExposedTransports().size() == 1) {
                    return SERVICE_MUST_CONTAIN_AT_LEAST_ONE_TRANSPORT;
                }
                sfpm.delete(serviceGroupId, PersistenceUtils.getResourcePath((AxisService)axisService) + "/" + "association" + PersistenceUtils.getXPathAttrPredicate((String)"destinationPath", (String)transportResource.getPath()) + PersistenceUtils.getXPathAttrPredicate((String)"type", (String)"exposedTransports"));
                axisService.removeExposedTransport(transportProtocol);
                registry.put(transportResource.getPath(), transportResource);
            }
            serviceElement.addAttribute("exposedAllTransports", String.valueOf(false), null);
            sfpm.put(serviceGroupId, serviceElement, PersistenceUtils.getResourcePath((AxisService)axisService));
            if (!regTransactionStarted) {
                this.getConfigSystemRegistry().commitTransaction();
            }
            if (!fileTransactionStarted) {
                sfpm.commitTransaction(serviceGroupId);
            }
        }
        catch (Exception e) {
            sfpm.rollbackTransaction(serviceGroupId);
            try {
                this.getConfigSystemRegistry().rollbackTransaction();
            }
            catch (RegistryException e1) {
                throw AxisFault.makeFault((Throwable)e);
            }
            throw AxisFault.makeFault((Throwable)e);
        }
        this.axisConfig.notifyObservers(new AxisEvent(101, (AxisDescription)axisService), axisService);
        return "Removed " + transportProtocol + " transport binding for " + serviceId + " service";
    }

    public void removeBindingPolicy(String serviceName, String policyKey, String[] moduleNames) throws ServerException {
        try {
            AxisConfiguration axisConfig = this.getAxisConfig();
            Registry registry = this.getConfigSystemRegistry();
            AxisService service = axisConfig.getServiceForActivation(serviceName);
            String serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
            ServiceGroupFilePersistenceManager sfpm = this.pf.getServiceGroupFilePM();
            String serviceXPath = PersistenceUtils.getResourcePath((AxisService)service);
            String policyPath = serviceXPath + "/" + "policies" + "/" + "policy" + PersistenceUtils.getXPathTextPredicate((String)"policyUUID", (String)policyKey);
            sfpm.delete(serviceGroupId, policyPath);
            for (String moduleName : moduleNames) {
                sfpm.delete(serviceGroupId, serviceXPath + "/" + "module" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)moduleName) + PersistenceUtils.getXPathAttrPredicate((String)"type", (String)"engagedModules"));
            }
            Map endPointMap = service.getEndpoints();
            for (Map.Entry o : endPointMap.entrySet()) {
                AxisEndpoint point = (AxisEndpoint)o.getValue();
                AxisBinding binding = point.getBinding();
                PolicySubject subject = binding.getPolicySubject();
                subject.detachPolicyComponent(policyKey);
            }
        }
        catch (Exception e) {
            String msg = "Cannot remove service policy";
            log.error((Object)msg, (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
    }

    public void setServiceParameters(String serviceName, String[] parameters) throws AxisFault {
        for (String parameter : parameters) {
            this.setServiceParameter(serviceName, parameter);
        }
    }

    private void setServiceParameter(String serviceName, String parameterStr) throws AxisFault {
        OMElement paramEle;
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceName);
        if (axisService == null) {
            throw new AxisFault("invalid service name service not found : " + serviceName);
        }
        try {
            XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(parameterStr.getBytes()));
            paramEle = new StAXOMBuilder(xmlSR).getDocumentElement();
        }
        catch (XMLStreamException e) {
            String msg = "Cannot create OMElement from parameter: " + parameterStr;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        Parameter parameter = ParameterUtil.createParameter((OMElement)paramEle);
        if (axisService.getParameter(parameter.getName()) != null) {
            if (!axisService.getParameter(parameter.getName()).isLocked()) {
                axisService.addParameter(parameter);
            }
        } else {
            axisService.addParameter(parameter);
        }
        try {
            this.spm.updateServiceParameter(axisService, parameter);
        }
        catch (Exception e) {
            String msg = "Cannot persist service parameter change for service " + serviceName;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public void removeServiceParameter(String serviceName, String parameterName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceName);
        if (axisService == null) {
            throw new AxisFault("invalid service name service not found : " + serviceName);
        }
        Parameter parameter = ParameterUtil.createParameter((String)parameterName, null);
        axisService.removeParameter(parameter);
        try {
            this.spm.removeServiceParameter(axisService, parameter);
        }
        catch (Exception e) {
            String msg = "Cannot persist service parameter removal. Service " + serviceName;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public String[] getServiceParameters(String serviceName) throws ServerException {
        try {
            AxisService service = this.getAxisService(serviceName);
            ArrayList parameters = service.getParameters();
            ArrayList<String> params = new ArrayList<String>();
            for (Parameter param : parameters) {
                OMElement paramEle = param.getParameterElement();
                if (paramEle != null) {
                    params.add(paramEle.toString());
                    continue;
                }
                if (param.getParameterType() != 1) continue;
                Parameter paramElement = ParameterUtil.createParameter((String)param.getName().trim(), (String)((String)param.getValue()), (boolean)param.isLocked());
                params.add(paramElement.getParameterElement().toString());
            }
            return params.toArray(new String[params.size()]);
        }
        catch (Exception e) {
            String msg = "Error occured while getting parameters of service : " + serviceName;
            log.error((Object)msg, (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
    }

    public String getPolicy(String serviceName) throws AxisFault {
        AxisService axisService = this.getAxisService(serviceName);
        if (axisService == null) {
            throw new AxisFault("invalid service name");
        }
        PolicySubject servicePolicySubject = axisService.getPolicySubject();
        ArrayList policyList = new ArrayList(servicePolicySubject.getAttachedPolicyComponents());
        Policy servicePolicy = org.apache.axis2.util.PolicyUtil.getMergedPolicy(policyList, (AxisService)axisService);
        if (servicePolicy == null) {
            return PolicyUtil.getEmptyPolicyAsOMElement().toString();
        }
        return PolicyUtil.getPolicyAsOMElement(servicePolicy).toString();
    }

    public String getModulePolicy(String moduleName, String moduleVersion) throws AxisFault {
        AxisConfiguration axisConfig = MessageContext.getCurrentMessageContext().getConfigurationContext().getAxisConfiguration();
        AxisModule axisModule = axisConfig.getModule(moduleName, moduleVersion);
        if (axisModule == null) {
            throw new AxisFault("invalid service name");
        }
        PolicySubject modulePolicySubject = axisModule.getPolicySubject();
        ArrayList policyList = new ArrayList(modulePolicySubject.getAttachedPolicyComponents());
        Policy policy = null;
        for (PolicyComponent policyElement : policyList) {
            PolicyComponent attachedPolicyComponent;
            if (policyElement instanceof Policy) {
                policy = policy == null ? (Policy)policyElement : policy.merge((Policy)policyElement);
                continue;
            }
            PolicyReference policyReference = (PolicyReference)policyElement;
            String key = policyReference.getURI();
            int pos = key.indexOf(35);
            if (pos == 0) {
                key = key.substring(1);
            } else if (pos > 0) {
                key = key.substring(0, pos);
            }
            if (!((attachedPolicyComponent = modulePolicySubject.getAttachedPolicyComponent(key)) instanceof Policy)) continue;
            policy = (Policy)attachedPolicyComponent;
        }
        if (policy == null) {
            return PolicyUtil.getEmptyPolicyAsOMElement().toString();
        }
        return PolicyUtil.getPolicyAsOMElement(policy).toString();
    }

    public void setModulePolicy(String moduleName, String moduleVersion, String policyString) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(policyString.getBytes());
        Policy policy = PolicyEngine.getPolicy((InputStream)bais);
        if (policy.getId() == null) {
            policy.setId(UIDGenerator.generateUID());
        }
        AxisConfiguration axisConfig = MessageContext.getCurrentMessageContext().getConfigurationContext().getAxisConfiguration();
        AxisModule axisModule = axisConfig.getModule(moduleName, moduleVersion);
        axisModule.getPolicySubject().clear();
        axisModule.getPolicySubject().attachPolicy(policy);
        ModuleFilePersistenceManager mfpm = this.pf.getModuleFilePM();
        try {
            this.pf.getModulePM().persistModulePolicy(moduleName, moduleVersion, policy, policy.getId(), "2", PersistenceUtils.getResourcePath((AxisModule)axisModule));
        }
        catch (Exception e) {
            String msg = "Cannot persist module policy addition. Module " + moduleName + moduleVersion;
            log.error((Object)msg, (Throwable)e);
            mfpm.rollbackTransaction(moduleName);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public String getOperationPolicy(String serviceName, String operationName) throws AxisFault {
        AxisService axisService = this.getAxisService(serviceName);
        if (axisService == null) {
            throw new AxisFault("invalid service name");
        }
        AxisOperation axisOperation = axisService.getOperation(new QName(operationName));
        PolicySubject operationPolicySubject = axisOperation.getPolicySubject();
        ArrayList policyList = new ArrayList(operationPolicySubject.getAttachedPolicyComponents());
        Policy operationPolicy = org.apache.axis2.util.PolicyUtil.getMergedPolicy(policyList, (AxisService)axisService);
        if (operationPolicy == null) {
            return PolicyUtil.getEmptyPolicyAsOMElement().toString();
        }
        return PolicyUtil.getPolicyAsOMElement(operationPolicy).toString();
    }

    public String getOperationMessagePolicy(String serviceName, String operationName, String messageType) throws AxisFault {
        AxisService axisService = this.getAxisService(serviceName);
        if (axisService == null) {
            throw new AxisFault("invalid service name");
        }
        AxisMessage axisMessage = axisService.getOperation(new QName(operationName)).getMessage(messageType);
        PolicySubject messagePolicySubject = axisMessage.getPolicySubject();
        ArrayList policyList = new ArrayList(messagePolicySubject.getAttachedPolicyComponents());
        Policy messagePolicy = org.apache.axis2.util.PolicyUtil.getMergedPolicy(policyList, (AxisService)axisService);
        if (messagePolicy == null) {
            return PolicyUtil.getEmptyPolicyAsOMElement().toString();
        }
        return PolicyUtil.getPolicyAsOMElement(messagePolicy).toString();
    }

    public PolicyMetaData[] getPolicies(String serviceName) throws AxisFault {
        AxisService axisService = this.getAxisService(serviceName);
        if (axisService == null) {
            throw new AxisFault("invalid service name");
        }
        ArrayList<PolicyMetaData> policyDataArray = new ArrayList<PolicyMetaData>();
        PolicySubject servicePolicySubject = axisService.getPolicySubject();
        ArrayList policyList = new ArrayList(servicePolicySubject.getAttachedPolicyComponents());
        if (!policyList.isEmpty()) {
            PolicyMetaData policyData = new PolicyMetaData();
            policyData.setWrapper("Policies that are applicable for " + axisService.getName() + " service");
            policyData.setPolycies(PolicyUtil.processPolicyElements(policyList.iterator(), (PolicyRegistry)new PolicyLocator(axisService)));
            policyDataArray.add(policyData);
        }
        for (AxisEndpoint axisEndpoint : axisService.getEndpoints().values()) {
            policyList = new ArrayList(axisEndpoint.getPolicySubject().getAttachedPolicyComponents());
            if (policyList.isEmpty()) continue;
            PolicyMetaData policyData = new PolicyMetaData();
            policyData.setWrapper("Policies that are applicable for " + axisEndpoint.getName() + " endpoint");
            policyData.setPolycies(PolicyUtil.processPolicyElements(policyList.iterator(), (PolicyRegistry)new PolicyLocator(axisService)));
            policyDataArray.add(policyData);
        }
        return policyDataArray.toArray(new PolicyMetaData[policyDataArray.size()]);
    }

    public String getBindingPolicy(String serviceName, String bindingName) throws AxisFault {
        AxisService axisService = this.getAxisService(serviceName);
        if (axisService == null) {
            throw new AxisFault("invalid service name");
        }
        AxisBinding axisBinding = null;
        Map endPointMap = axisService.getEndpoints();
        for (Map.Entry o : endPointMap.entrySet()) {
            Map.Entry entry = o;
            AxisEndpoint point = (AxisEndpoint)entry.getValue();
            if (!point.getBinding().getName().getLocalPart().equals(bindingName)) continue;
            axisBinding = point.getBinding();
            break;
        }
        if (axisBinding == null) {
            throw new AxisFault("invalid binding name");
        }
        PolicySubject bindingPolicy = axisBinding.getPolicySubject();
        ArrayList policyList = new ArrayList(bindingPolicy.getAttachedPolicyComponents());
        Policy servicePolicy = org.apache.axis2.util.PolicyUtil.getMergedPolicy(policyList, (AxisService)axisService);
        if (servicePolicy == null) {
            return PolicyUtil.getEmptyPolicyAsOMElement().toString();
        }
        return PolicyUtil.getPolicyAsOMElement(servicePolicy).toString();
    }

    public String getBindingOperationPolicy(String serviceName, String bindingName, String operationName) throws AxisFault {
        AxisService axisService = this.getAxisService(serviceName);
        if (axisService == null) {
            throw new AxisFault("invalid service name");
        }
        AxisBinding axisBinding = null;
        Map endPointMap = axisService.getEndpoints();
        for (Map.Entry o : endPointMap.entrySet()) {
            AxisEndpoint point = (AxisEndpoint)o.getValue();
            if (!point.getBinding().getName().getLocalPart().equals(bindingName)) continue;
            axisBinding = point.getBinding();
            break;
        }
        if (axisBinding == null) {
            throw new AxisFault("invalid binding name");
        }
        Policy bindingOperationPolicy = null;
        Iterator operations = axisBinding.getChildren();
        while (operations.hasNext()) {
            AxisBindingOperation currentOperation = (AxisBindingOperation)operations.next();
            if (!currentOperation.getName().toString().equals(operationName)) continue;
            PolicySubject bindingOperationPolicySubject = currentOperation.getPolicySubject();
            ArrayList policyList = new ArrayList(bindingOperationPolicySubject.getAttachedPolicyComponents());
            bindingOperationPolicy = org.apache.axis2.util.PolicyUtil.getMergedPolicy(policyList, (AxisService)axisService);
            break;
        }
        if (bindingOperationPolicy == null) {
            return PolicyUtil.getEmptyPolicyAsOMElement().toString();
        }
        return PolicyUtil.getPolicyAsOMElement(bindingOperationPolicy).toString();
    }

    public String getBindingOperationMessagePolicy(String serviceName, String bindingName, String operationName, String messageType) throws AxisFault {
        AxisService axisService = this.getAxisService(serviceName);
        if (axisService == null) {
            throw new AxisFault("invalid service name");
        }
        AxisBinding axisBinding = null;
        Map endPointMap = axisService.getEndpoints();
        for (Map.Entry o : endPointMap.entrySet()) {
            Map.Entry entry = o;
            AxisEndpoint point = (AxisEndpoint)entry.getValue();
            if (!point.getBinding().getName().getLocalPart().equals(bindingName)) continue;
            axisBinding = point.getBinding();
            break;
        }
        if (axisBinding == null) {
            throw new AxisFault("invalid binding name");
        }
        Policy bindingOperationMessagePolicy = null;
        Iterator operations = axisBinding.getChildren();
        while (operations.hasNext()) {
            AxisBindingOperation currentOperation = (AxisBindingOperation)operations.next();
            if (!currentOperation.getName().toString().equals(operationName)) continue;
            PolicySubject bindingOperationMessagePolicySubject = currentOperation.getChild((Object)messageType).getPolicySubject();
            ArrayList policyList = new ArrayList(bindingOperationMessagePolicySubject.getAttachedPolicyComponents());
            bindingOperationMessagePolicy = org.apache.axis2.util.PolicyUtil.getMergedPolicy(policyList, (AxisService)axisService);
            break;
        }
        if (bindingOperationMessagePolicy == null) {
            return PolicyUtil.getEmptyPolicyAsOMElement().toString();
        }
        return PolicyUtil.getPolicyAsOMElement(bindingOperationMessagePolicy).toString();
    }

    public void setPolicy(String serviceName, String policyString) throws Exception {
        this.setServicePolicy(serviceName, policyString);
    }

    public void setServicePolicy(String serviceName, String policyString) throws Exception {
        AxisService axisService = this.getAxisService(serviceName);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        ByteArrayInputStream bais = new ByteArrayInputStream(policyString.getBytes());
        Policy policy = PolicyEngine.getPolicy((InputStream)bais);
        if (policy.getId() == null) {
            policy.setId(UIDGenerator.generateUID());
        }
        ServiceGroupFilePersistenceManager sfpm = this.pf.getServiceGroupFilePM();
        try {
            String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
            this.spm.persistServicePolicy(serviceGroupId, policy, policy.getId(), "3", serviceXPath, serviceXPath);
        }
        catch (Exception e) {
            String msg = "Cannot persist service policy addition. Service " + serviceGroupId;
            log.error((Object)msg, (Throwable)e);
            sfpm.rollbackTransaction(serviceGroupId);
            throw new AxisFault(msg, (Throwable)e);
        }
        axisService.getPolicySubject().clear();
        axisService.getPolicySubject().attachPolicy(policy);
        axisService.getAxisConfiguration().notifyObservers(new AxisEvent(-1, (AxisDescription)axisService), axisService);
    }

    public void setServiceOperationPolicy(String serviceName, String operationName, String policyString) throws Exception {
        AxisService axisService = this.getAxisService(serviceName);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        ServiceGroupFilePersistenceManager sfpm = this.pf.getServiceGroupFilePM();
        ByteArrayInputStream bais = new ByteArrayInputStream(policyString.getBytes());
        Policy policy = PolicyEngine.getPolicy((InputStream)bais);
        if (policy.getId() == null) {
            policy.setId(UIDGenerator.generateUID());
        }
        try {
            String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
            String operationXPath = PersistenceUtils.getResourcePath((AxisOperation)axisService.getOperation(new QName(operationName)));
            this.spm.persistServicePolicy(serviceGroupId, policy, policy.getId(), "4", serviceXPath, operationXPath);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            sfpm.rollbackTransaction(serviceGroupId);
            throw AxisFault.makeFault((Throwable)e);
        }
        AxisOperation axisOperation = axisService.getOperation(new QName(operationName));
        axisOperation.getPolicySubject().clear();
        axisOperation.getPolicySubject().attachPolicy(policy);
        axisService.getAxisConfiguration().notifyObservers(new AxisEvent(-1, (AxisDescription)axisOperation), axisService);
    }

    public void setServiceOperationMessagePolicy(String serviceName, String operationName, String messageType, String policyString) throws Exception {
        AxisService axisService = this.getAxisService(serviceName);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        ServiceGroupFilePersistenceManager sfpm = this.pf.getServiceGroupFilePM();
        ByteArrayInputStream bais = new ByteArrayInputStream(policyString.getBytes());
        Policy policy = PolicyEngine.getPolicy((InputStream)bais);
        if (policy.getId() == null) {
            policy.setId(UIDGenerator.generateUID());
        }
        try {
            String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
            boolean transactionStarted = sfpm.isTransactionStarted(serviceGroupId);
            if (!transactionStarted) {
                sfpm.beginTransaction(serviceGroupId);
            }
            OMElement policyElement = PersistenceUtils.createPolicyElement((Policy)policy);
            OMFactory omFactory = OMAbstractFactory.getOMFactory();
            OMElement policyWrapperElement = omFactory.createOMElement("policy", null);
            OMElement idElement = omFactory.createOMElement("policyUUID", null);
            idElement.setText("" + policy.getId());
            policyWrapperElement.addChild((OMNode)idElement);
            policyWrapperElement.addAttribute("policyType", "5", null);
            policyWrapperElement.addChild((OMNode)policyElement);
            if (messageType.equals("In")) {
                OMElement messageInIdElement = omFactory.createOMElement("messageInPolicyUuid", null);
                idElement.setText("" + policy.getId());
                sfpm.put(serviceGroupId, messageInIdElement, PersistenceUtils.getResourcePath((AxisService)axisService) + "/" + "operation" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)operationName));
            } else if (messageType.equals("Out")) {
                OMElement messageOutIdElement = omFactory.createOMElement("messageOutPolicyUuid", null);
                idElement.setText("" + policy.getId());
                sfpm.put(serviceGroupId, messageOutIdElement, PersistenceUtils.getResourcePath((AxisService)axisService) + "/" + "operation" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)operationName));
            }
            String policiesPath = PersistenceUtils.getResourcePath((AxisService)axisService) + "/" + "policies";
            if (!this.spm.getServiceGroupFilePM().elementExists(serviceGroupId, policiesPath)) {
                OMElement policiesEl = omFactory.createOMElement("policies", null);
                this.spm.getServiceGroupFilePM().put(serviceGroupId, policiesEl, PersistenceUtils.getResourcePath((AxisService)axisService));
            } else {
                String pathToPolicy = policiesPath + "/" + "policy" + PersistenceUtils.getXPathTextPredicate((String)"policyUUID", (String)policy.getId());
                if (this.spm.getServiceGroupFilePM().elementExists(serviceGroupId, pathToPolicy)) {
                    this.spm.getServiceGroupFilePM().delete(serviceGroupId, pathToPolicy);
                }
            }
            this.spm.getServiceGroupFilePM().put(serviceGroupId, policyWrapperElement, policiesPath);
            if (!transactionStarted) {
                sfpm.commitTransaction(serviceGroupId);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            sfpm.rollbackTransaction(serviceGroupId);
            throw AxisFault.makeFault((Throwable)e);
        }
        axisService.getOperation(new QName(operationName)).getMessage(messageType).getPolicySubject().clear();
        axisService.getOperation(new QName(operationName)).getMessage(messageType).getPolicySubject().attachPolicy(policy);
    }

    public void setBindingPolicy(String serviceName, String bindingName, String policyString) throws Exception {
        AxisService axisService = this.getAxisService(serviceName);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        ServiceGroupFilePersistenceManager sfpm = this.pf.getServiceGroupFilePM();
        ByteArrayInputStream bais = new ByteArrayInputStream(policyString.getBytes());
        Policy policy = PolicyEngine.getPolicy((InputStream)bais);
        if (policy.getId() == null) {
            policy.setId(UIDGenerator.generateUID());
        }
        try {
            String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
            String bindingXPath = PersistenceUtils.getResourcePath((AxisService)axisService) + "/" + "bindings" + "/" + "binding" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)bindingName);
            this.spm.persistServicePolicy(serviceGroupId, policy, policy.getId(), "9", serviceXPath, bindingXPath);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            sfpm.rollbackTransaction(serviceGroupId);
            throw AxisFault.makeFault((Throwable)e);
        }
        Map endPointMap = axisService.getEndpoints();
        for (Map.Entry o : endPointMap.entrySet()) {
            AxisEndpoint point = (AxisEndpoint)o.getValue();
            AxisBinding binding = point.getBinding();
            if (!binding.getName().getLocalPart().equals(bindingName)) continue;
            binding.getPolicySubject().clear();
            binding.getPolicySubject().attachPolicy(policy);
        }
    }

    public void setBindingOperationPolicy(String serviceName, String bindingName, String operationName, String policyString) throws Exception {
        AxisService axisService = this.getAxisService(serviceName);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        ServiceGroupFilePersistenceManager sfpm = this.pf.getServiceGroupFilePM();
        ByteArrayInputStream bais = new ByteArrayInputStream(policyString.getBytes());
        Policy policy = PolicyEngine.getPolicy((InputStream)bais);
        if (policy.getId() == null) {
            policy.setId(UIDGenerator.generateUID());
        }
        try {
            String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
            String bindingOperationXPath = PersistenceUtils.getResourcePath((AxisService)axisService) + "/" + "bindings" + "/" + "binding" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)bindingName) + "/" + "operation" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)operationName);
            this.spm.persistServicePolicy(serviceGroupId, policy, policy.getId(), "11", serviceXPath, bindingOperationXPath);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            sfpm.rollbackTransaction(serviceGroupId);
            throw AxisFault.makeFault((Throwable)e);
        }
        Map endPointMap = axisService.getEndpoints();
        block2: for (Map.Entry o : endPointMap.entrySet()) {
            AxisEndpoint point = (AxisEndpoint)o.getValue();
            AxisBinding binding = point.getBinding();
            if (!binding.getName().getLocalPart().equals(bindingName)) continue;
            Iterator operations = binding.getChildren();
            while (operations.hasNext()) {
                AxisBindingOperation currentOperation = (AxisBindingOperation)operations.next();
                if (!currentOperation.getName().toString().equals(operationName)) continue;
                currentOperation.getPolicySubject().clear();
                currentOperation.getPolicySubject().attachPolicy(policy);
                continue block2;
            }
        }
    }

    public void setBindingOperationMessagePolicy(String serviceName, String bindingName, String operationName, String messageType, String policyString) throws Exception {
        AxisService axisService = this.getAxisService(serviceName);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        ServiceGroupFilePersistenceManager sfpm = this.pf.getServiceGroupFilePM();
        ByteArrayInputStream bais = new ByteArrayInputStream(policyString.getBytes());
        Policy policy = PolicyEngine.getPolicy((InputStream)bais);
        if (policy.getId() == null) {
            policy.setId(UIDGenerator.generateUID());
        }
        String servicePath = "/repository/axis2/service-groups/" + axisService.getAxisServiceGroup().getServiceGroupName() + "/services/" + axisService.getName();
        Registry registry = this.getConfigSystemRegistry();
        String policyType = messageType.equalsIgnoreCase("In") ? "14" : "15";
        try {
            String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
            boolean transactionStarted = sfpm.isTransactionStarted(serviceGroupId);
            if (!transactionStarted) {
                sfpm.beginTransaction(serviceGroupId);
            }
            OMElement policyElement = PersistenceUtils.createPolicyElement((Policy)policy);
            OMFactory omFactory = OMAbstractFactory.getOMFactory();
            OMElement policyWrapperElement = omFactory.createOMElement("policy", null);
            OMElement idElement = omFactory.createOMElement("policyUUID", null);
            idElement.setText("" + policy.getId());
            policyWrapperElement.addChild((OMNode)idElement);
            policyWrapperElement.addAttribute("policyType", policyType, null);
            policyWrapperElement.addChild((OMNode)policyElement);
            String bindingOppath = PersistenceUtils.getResourcePath((AxisService)axisService) + "/" + "bindings" + "/" + "binding" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)bindingName) + "/" + "operation" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)operationName);
            if (messageType.equals("In")) {
                OMElement messageInIdElement = omFactory.createOMElement("messageInPolicyUuid", null);
                idElement.setText("" + policy.getId());
                sfpm.put(serviceGroupId, messageInIdElement, bindingOppath);
            } else if (messageType.equals("Out")) {
                OMElement messageOutIdElement = omFactory.createOMElement("messageOutPolicyUuid", null);
                idElement.setText("" + policy.getId());
                sfpm.put(serviceGroupId, messageOutIdElement, bindingOppath);
            }
            String policiesPath = PersistenceUtils.getResourcePath((AxisService)axisService) + "/" + "policies";
            if (!this.spm.getServiceGroupFilePM().elementExists(serviceGroupId, policiesPath)) {
                OMElement policiesEl = omFactory.createOMElement("policies", null);
                this.spm.getServiceGroupFilePM().put(serviceGroupId, policiesEl, PersistenceUtils.getResourcePath((AxisService)axisService));
            }
            this.spm.getServiceGroupFilePM().put(serviceGroupId, policyWrapperElement, policiesPath);
            if (!transactionStarted) {
                sfpm.commitTransaction(serviceGroupId);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            sfpm.rollbackTransaction(serviceGroupId);
            throw AxisFault.makeFault((Throwable)e);
        }
        Map endPointMap = axisService.getEndpoints();
        block2: for (Map.Entry o : endPointMap.entrySet()) {
            AxisEndpoint point = (AxisEndpoint)o.getValue();
            AxisBinding binding = point.getBinding();
            if (!binding.getName().getLocalPart().equals(bindingName)) continue;
            Iterator operations = binding.getChildren();
            while (operations.hasNext()) {
                AxisBindingOperation currentOperation = (AxisBindingOperation)operations.next();
                if (!currentOperation.getName().toString().equals(operationName)) continue;
                currentOperation.getChild((Object)messageType).getPolicySubject().clear();
                currentOperation.getChild((Object)messageType).getPolicySubject().attachPolicy(policy);
                continue block2;
            }
        }
    }

    public OMElement getWSDL(String serviceName) throws AxisFault {
        AxisService axisService = this.getAxisService(serviceName);
        if (axisService != null) {
            int seperatorIndex;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            String url = MessageContext.getCurrentMessageContext().getTo().getAddress();
            int ipindex = url.indexOf("//");
            String ip = null;
            if (ipindex >= 0 && (seperatorIndex = (ip = url.substring(ipindex + 2, url.length())).indexOf(58)) > 0) {
                ip = ip.substring(0, seperatorIndex);
            }
            axisService.printWSDL((OutputStream)out, ip);
            try {
                XMLStreamReader xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(new ByteArrayInputStream(out.toByteArray()));
                OMFactory fac = OMAbstractFactory.getOMFactory();
                OMNamespace namespace = fac.createOMNamespace("http://org.apache.axis2/xsd", "ns1");
                OMElement wsdlWrapper = fac.createOMElement("getWSDLResponse", namespace);
                OMElement retvalue = fac.createOMElement("return", null);
                wsdlWrapper.addChild((OMNode)retvalue);
                StAXOMBuilder staxOMBuilder = new StAXOMBuilder(fac, xmlReader);
                retvalue.addChild((OMNode)staxOMBuilder.getDocumentElement());
                return wsdlWrapper;
            }
            catch (XMLStreamException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
        }
        return null;
    }

    public String[] getServiceBindings(String serviceName) throws Exception {
        AxisService axisService = this.getAxisService(serviceName);
        ServiceMetaData serviceMetaData = new ServiceMetaData();
        serviceMetaData.setServiceId(serviceName);
        ArrayList<String> bindingsList = new ArrayList<String>();
        Map endPointMap = axisService.getEndpoints();
        for (Map.Entry o : endPointMap.entrySet()) {
            Map.Entry entry = o;
            AxisEndpoint point = (AxisEndpoint)entry.getValue();
            String currentBinding = point.getBinding().getName().getLocalPart();
            if (currentBinding.contains("HttpBinding") || bindingsList.contains(currentBinding)) continue;
            bindingsList.add(currentBinding);
        }
        String[] bindings = new String[bindingsList.size()];
        bindingsList.toArray(bindings);
        return bindings;
    }

    private AxisService getAxisService(String serviceName) throws AxisFault {
        return this.getAxisConfig().getServiceForActivation(serviceName);
    }

    public ServiceDownloadData downloadServiceArchive(String serviceGroupName) {
        AxisConfiguration axisConfig = this.getAxisConfig();
        AxisServiceGroup asGroup = axisConfig.getServiceGroup(serviceGroupName);
        String fileName = null;
        Iterator serviceIter = asGroup.getServices();
        while (serviceIter.hasNext()) {
            AxisService axisService = (AxisService)serviceIter.next();
            URL fn = axisService.getFileName();
            if (fn == null) continue;
            fileName = fn.getPath();
        }
        if (fileName != null) {
            File file = new File(fileName);
            FileDataSource datasource = new FileDataSource(file);
            DataHandler handler = new DataHandler((DataSource)datasource);
            ServiceDownloadData data = new ServiceDownloadData();
            data.setFileName(file.getName());
            data.setServiceFileData(handler);
            return data;
        }
        return null;
    }

    private void sendClusterSyncMessage(ServiceConstants.ServiceOperationType applicationOpType, String serviceName) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        ClusteringAgent clusteringAgent = DataHolder.getServerConfigContext().getAxisConfiguration().getClusteringAgent();
        if (clusteringAgent != null) {
            int numberOfRetries = 0;
            UUID messageId = UUID.randomUUID();
            ServiceSynchronizeRequest request = new ServiceSynchronizeRequest(tenantId, tenantDomain, messageId, applicationOpType, serviceName);
            while (numberOfRetries < ServiceConstants.MAX_RETRY_COUNT) {
                try {
                    clusteringAgent.sendMessage((ClusteringMessage)request, true);
                    log.info((Object)("Sent [" + (Object)((Object)request) + "]"));
                    break;
                }
                catch (ClusteringFault e) {
                    if (++numberOfRetries < ServiceConstants.MAX_RETRY_COUNT) {
                        log.warn((Object)("Could not send SynchronizeRepositoryRequest for tenant " + tenantId + ". Retry will be attempted in 2s. Request: " + (Object)((Object)request)), (Throwable)e);
                    } else {
                        log.error((Object)("Could not send SynchronizeRepositoryRequest for tenant " + tenantId + ". Several retries failed. Request:" + (Object)((Object)request)), (Throwable)e);
                    }
                    try {
                        Thread.sleep(ServiceConstants.RETRY_INTERVAL);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private boolean isAxisServiceCApp(AxisService axisService) {
        if (AXIS2_SERVICE_TYPE.equals(this.getServiceType(axisService))) {
            try {
                Path axis2ServiceAppPath = Paths.get(axisService.getFileName().toURI());
                if (axis2ServiceAppPath != null) {
                    String tenantId = AppDeployerUtils.getTenantIdString();
                    ArrayList appList = DataHolder.getApplicationManager().getCarbonApps(tenantId);
                    for (CarbonApplication application : appList) {
                        Path cappPath = Paths.get(application.getExtractedPath(), new String[0]);
                        if (!axis2ServiceAppPath.startsWith(cappPath)) continue;
                        return true;
                    }
                }
            }
            catch (URISyntaxException e) {
                log.error((Object)"Unable to retrieve CApp file path ", (Throwable)e);
            }
        }
        return false;
    }
}

