/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.service.mgt.sync;

import java.util.UUID;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.service.mgt.ServiceConstants;

public class ServiceSynchronizeRequest
extends ClusteringMessage {
    private static final transient Log log = LogFactory.getLog(ServiceSynchronizeRequest.class);
    private int tenantId;
    private String tenantDomain;
    private UUID messageId;
    private ServiceConstants.ServiceOperationType operation;
    private String serviceName;

    public ServiceSynchronizeRequest(int tenantId, String tenantDomain, UUID messageId, ServiceConstants.ServiceOperationType operation, String serviceName) {
        this.tenantId = tenantId;
        this.tenantDomain = tenantDomain;
        this.messageId = messageId;
        this.operation = operation;
        this.serviceName = serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(ConfigurationContext configurationContext) throws ClusteringFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received [" + (Object)((Object)this) + "] "));
        }
        if (this.tenantId != -1234 && TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)configurationContext).get(this.tenantDomain) == null) {
            if (!log.isDebugEnabled()) return;
            log.debug((Object)("Tenant is not loaded. TID - " + this.tenantId + " TD - " + this.tenantDomain));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to synchronize Service status for tenant: TID - " + this.tenantId + " TD - " + this.tenantDomain));
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            privilegedCarbonContext.setTenantId(this.tenantId);
            privilegedCarbonContext.setTenantDomain(this.tenantDomain);
            ConfigurationContext tenantConfigurationContext = this.tenantId == -1234 ? configurationContext : (ConfigurationContext)TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)configurationContext).get(this.tenantDomain);
            switch (this.operation) {
                case ACTIVATE: {
                    this.activateService(tenantConfigurationContext, this.serviceName);
                    return;
                }
                case DEACTIVATE: {
                    this.deactivateService(tenantConfigurationContext, this.serviceName);
                    return;
                }
            }
            return;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private void activateService(ConfigurationContext configurationContext, String serviceName) {
        try {
            configurationContext.getAxisConfiguration().startService(serviceName);
            if (log.isDebugEnabled()) {
                log.info((Object)("Service activated [" + serviceName + "]"));
            }
        }
        catch (AxisFault axisFault) {
            String msg = "Cannot activate service [" + serviceName + "]";
            log.error((Object)msg, (Throwable)axisFault);
        }
    }

    private void deactivateService(ConfigurationContext configurationContext, String serviceName) {
        try {
            configurationContext.getAxisConfiguration().stopService(serviceName);
            if (log.isDebugEnabled()) {
                log.info((Object)("Service deactivated [" + serviceName + "]"));
            }
        }
        catch (AxisFault axisFault) {
            String msg = "Cannot deactivate service [" + serviceName + "]";
            log.error((Object)msg, (Throwable)axisFault);
        }
    }

    public ClusteringCommand getResponse() {
        return null;
    }

    public String toString() {
        return "ServiceSynchronizeRequest{tenantId=" + this.tenantId + ", tenantDomain='" + this.tenantDomain + '\'' + ", messageId=" + this.messageId + ", operation=" + (Object)((Object)this.operation) + ", serviceName='" + this.serviceName + '\'' + '}';
    }
}

