/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.service.mgt.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.activation.DataHandler;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.service.mgt.stub.ServiceAdminStub;
import org.wso2.carbon.service.mgt.stub.types.carbon.FaultyServicesWrapper;
import org.wso2.carbon.service.mgt.stub.types.carbon.ServiceDownloadData;
import org.wso2.carbon.service.mgt.stub.types.carbon.ServiceMetaData;
import org.wso2.carbon.service.mgt.stub.types.carbon.ServiceMetaDataWrapper;
import org.wso2.carbon.service.mgt.ui.Parameter;
import org.wso2.carbon.utils.xml.XMLPrettyPrinter;

public class ServiceAdminClient {
    private static final Log log = LogFactory.getLog(ServiceAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.service.mgt.ui.i18n.Resources";
    private ResourceBundle bundle;
    private ServiceAdminStub stub;

    public ServiceAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "ServiceAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new ServiceAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public ServiceMetaData getServiceData(String serviceName) throws AxisFault {
        try {
            return this.stub.getServiceData(serviceName);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.get.service.data"), e);
            return null;
        }
    }

    public ServiceMetaDataWrapper getAllServices(String serviceTypeFilter, String serviceSearchString, int pageNumber) throws RemoteException {
        try {
            return this.stub.listServices(serviceTypeFilter, serviceSearchString, pageNumber);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.all.services"), e);
            return null;
        }
    }

    public FaultyServicesWrapper getAllFaultyServices(int pageNumber) throws RemoteException {
        try {
            return this.stub.getFaultyServiceArchives(pageNumber);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.faulty.services"), e);
            return null;
        }
    }

    public int getNoOfFaultyServices() throws Exception {
        try {
            return this.stub.getNumberOfFaultyServices();
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.the.number.of.faulty.services"), e);
            return 0;
        }
    }

    public List<Parameter> getServiceParameters(String serviceName) throws AxisFault {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        try {
            String[] serviceParameters = this.stub.getServiceParameters(serviceName);
            if (serviceParameters != null && serviceParameters.length != 0) {
                for (String serviceParameter : serviceParameters) {
                    XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(serviceParameter.getBytes()));
                    OMElement paramEle = new StAXOMBuilder(xmlSR).getDocumentElement();
                    String paramName = paramEle.getAttribute(new QName("name")).getAttributeValue();
                    ByteArrayInputStream xmlIn = new ByteArrayInputStream(serviceParameter.getBytes());
                    XMLPrettyPrinter xmlPrettyPrinter = new XMLPrettyPrinter((InputStream)xmlIn, null);
                    Parameter parameter = new Parameter(paramName, xmlPrettyPrinter.xmlFormat());
                    boolean isLocked = false;
                    OMAttribute lockedAttrib = paramEle.getAttribute(new QName("locked"));
                    if (lockedAttrib != null) {
                        isLocked = "true".equals(lockedAttrib.getAttributeValue());
                    }
                    parameter.setLocked(isLocked);
                    parameters.add(parameter);
                }
            }
        }
        catch (Exception e) {
            this.handleException(MessageFormat.format(this.bundle.getString("could.not.get.service.parameters"), serviceName), e);
        }
        return parameters;
    }

    public void setServiceParameters(String serviceName, List<String> parameters) throws AxisFault {
        try {
            this.stub.setServiceParameters(serviceName, parameters.toArray(new String[parameters.size()]));
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.update.service.parameters"), e);
        }
    }

    public void removeServiceParameter(String serviceName, String parameterName) throws AxisFault {
        try {
            this.stub.removeServiceParameter(serviceName, parameterName);
        }
        catch (RemoteException e) {
            this.handleException("Could not remove Service parameter. Service: " + serviceName + ", parameterName=" + parameterName, e);
        }
    }

    public boolean checkForGroupedServices(String[] serviceGroupsList) throws AxisFault {
        boolean foundGroupedServices = false;
        try {
            foundGroupedServices = this.stub.checkForGroupedServices(serviceGroupsList);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.check.grouped.services"), e);
        }
        return foundGroupedServices;
    }

    public void deleteServiceGroups(String[] serviceGroups) throws Exception {
        try {
            this.stub.deleteServiceGroups(serviceGroups);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.delete.service.groups"), e);
        }
    }

    public void deleteAllNonAdminServiceGroups() throws RemoteException {
        try {
            this.stub.deleteAllNonAdminServiceGroups();
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.delete.all.non.admin.service.groups"), e);
        }
    }

    public void deleteAllFaultyServiceGroups() throws RemoteException {
        try {
            this.stub.deleteAllFaultyServiceGroups();
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.delete.all.faulty.service.groups"), e);
        }
    }

    public void deleteFaultyServiceGroups(String[] fileNames) throws RemoteException {
        try {
            this.stub.deleteFaultyServiceGroups(fileNames);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.delete.faulty.service.group"), e);
        }
    }

    public void changeServiceState(String serviceName, boolean isActive) throws RemoteException {
        try {
            this.stub.changeServiceState(serviceName, isActive);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.delete.faulty.service.group"), e);
        }
    }

    public OMElement getPolicy(String serviceName) throws AxisFault {
        try {
            XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(this.stub.getPolicy(serviceName).getBytes()));
            return new StAXOMBuilder(xmlSR).getDocumentElement();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.get.service.policy"), e);
            return null;
        }
    }

    public OMElement getOperationPolicy(String serviceName, String operationName) throws AxisFault {
        try {
            XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(this.stub.getOperationPolicy(serviceName, operationName).getBytes()));
            return new StAXOMBuilder(xmlSR).getDocumentElement();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.get.operation.policy"), e);
            return null;
        }
    }

    public OMElement getOperationMessagePolicy(String serviceName, String operationName, String messageType) throws AxisFault {
        try {
            XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(this.stub.getOperationMessagePolicy(serviceName, operationName, messageType).getBytes()));
            return new StAXOMBuilder(xmlSR).getDocumentElement();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.get.operation.message.policy"), e);
            return null;
        }
    }

    public OMElement getBindingPolicy(String serviceName, String bindingName) throws AxisFault {
        try {
            XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(this.stub.getBindingPolicy(serviceName, bindingName).getBytes()));
            return new StAXOMBuilder(xmlSR).getDocumentElement();
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.get.binding.policy");
            this.handleException(msg, e);
            return null;
        }
    }

    public OMElement getBindingOperationPolicy(String serviceName, String bindingName, String operationName) throws AxisFault {
        try {
            XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(this.stub.getBindingOperationPolicy(serviceName, bindingName, operationName).getBytes()));
            return new StAXOMBuilder(xmlSR).getDocumentElement();
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.get.binding.operation.policy");
            this.handleException(msg, e);
            return null;
        }
    }

    public OMElement getBindingOperationMessagePolicy(String serviceName, String bindingName, String operationName, String messageType) throws AxisFault {
        try {
            XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(this.stub.getBindingOperationMessagePolicy(serviceName, bindingName, operationName, messageType).getBytes()));
            return new StAXOMBuilder(xmlSR).getDocumentElement();
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.get.binding.operation.message.policy");
            this.handleException(msg, e);
            return null;
        }
    }

    public void setPolicy(String serviceName, String policyString) throws AxisFault {
        try {
            this.stub.setPolicy(serviceName, policyString);
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.set.policy.to.axis.service");
            this.handleException(msg, e);
        }
    }

    public void setServicePolicy(String serviceName, String policyString) throws AxisFault {
        try {
            this.stub.setServicePolicy(serviceName, policyString);
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.set.policy.to.axis.service");
            this.handleException(msg, e);
        }
    }

    public void setServiceOperationPolicy(String serviceName, String operationName, String policyString) throws AxisFault {
        try {
            this.stub.setServiceOperationPolicy(serviceName, operationName, policyString);
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.set.service.operation.policy");
            this.handleException(msg, e);
        }
    }

    public void setServiceOperationMessagePolicy(String serviceName, String operationName, String messageType, String policyString) throws AxisFault {
        try {
            this.stub.setServiceOperationMessagePolicy(serviceName, operationName, messageType, policyString);
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.set.service.operation.message.policy");
            this.handleException(msg, e);
        }
    }

    public void setBindingPolicy(String serviceName, String bindingName, String policyString) throws AxisFault {
        try {
            this.stub.setBindingPolicy(serviceName, bindingName, policyString);
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.set.binding.policy");
            this.handleException(msg, e);
        }
    }

    public void setBindingOperationPolicy(String serviceName, String bindingName, String operationName, String policyString) throws AxisFault {
        try {
            this.stub.setBindingOperationPolicy(serviceName, bindingName, operationName, policyString);
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.set.binding.operation.policy");
            this.handleException(msg, e);
        }
    }

    public void setBindingOperationMessagePolicy(String serviceName, String bindingName, String operationName, String messageType, String policyString) throws AxisFault {
        try {
            this.stub.setBindingOperationMessagePolicy(serviceName, bindingName, operationName, messageType, policyString);
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.set.binding.operation.message.policy");
            this.handleException(msg, e);
        }
    }

    public void setModulePolicy(String moduleName, String moduleVersion, String policyString) throws AxisFault {
        try {
            this.stub.setModulePolicy(moduleName, moduleVersion, policyString);
        }
        catch (Exception e) {
            String msg = this.bundle.getString("can.not.set.module.policy");
            this.handleException(msg, e);
        }
    }

    public OMElement getModulePolicy(String moduleName, String moduleVersion) throws AxisFault {
        try {
            XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(this.stub.getModulePolicy(moduleName, moduleVersion).getBytes()));
            return new StAXOMBuilder(xmlSR).getDocumentElement();
        }
        catch (Exception e) {
            String msg = this.bundle.getString("can.not.get.module.policy");
            this.handleException(msg, e);
            return null;
        }
    }

    public String[] getServiceBindings(String serviceName) throws AxisFault {
        try {
            return this.stub.getServiceBindings(serviceName);
        }
        catch (Exception e) {
            String msg = this.bundle.getString("cannot.get.service.binding");
            this.handleException(msg, e);
            return null;
        }
    }

    public void configureMTOM(String mtomState, String serviceName) throws AxisFault {
        try {
            this.stub.configureMTOM(mtomState, serviceName);
        }
        catch (Exception e) {
            String msg = MessageFormat.format(this.bundle.getString("cannot.change.mtom.state.of.service."), serviceName);
            this.handleException(msg, e);
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    public void downloadServiceArchive(String serviceGroupName, String serviceType, HttpServletResponse response) throws AxisFault {
        try {
            ServletOutputStream out = response.getOutputStream();
            ServiceDownloadData downloadData = this.stub.downloadServiceArchive(serviceGroupName);
            if (downloadData != null) {
                int nextChar;
                DataHandler handler = downloadData.getServiceFileData();
                response.setHeader("Content-Disposition", "fileName=" + downloadData.getFileName());
                response.setContentType(handler.getContentType());
                InputStream in = handler.getDataSource().getInputStream();
                while ((nextChar = in.read()) != -1) {
                    out.write((int)((char)nextChar));
                }
                out.flush();
                in.close();
            } else {
                out.write("The requested service archive was not found on the server".getBytes());
            }
        }
        catch (RemoteException e) {
            this.handleException("error.downloading.service", e);
        }
        catch (IOException e) {
            this.handleException("error.downloading.service", e);
        }
    }
}

