/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.springservices;

import org.apache.axis2.AxisFault;
import org.apache.axis2.ServiceObjectSupplier;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.i18n.Messages;
import org.springframework.context.support.GenericApplicationContext;
import org.wso2.carbon.springservices.GenericApplicationContextUtil;

public class GenericApplicationContextSupplier
implements ServiceObjectSupplier {
    public static final String SERVICE_SPRING_BEANNAME = "SpringBeanName";
    public static final String APPLICATION_CONTEXT_LOCATION = "SpringContextLocation";

    public Object getServiceObject(AxisService axisService) throws AxisFault {
        try {
            String springContextLocationValue;
            Parameter springContextLocation = axisService.getParameter(APPLICATION_CONTEXT_LOCATION);
            if (springContextLocation != null) {
                springContextLocationValue = ((String)springContextLocation.getValue()).trim();
                if (springContextLocationValue == null) {
                    throw new AxisFault(Messages.getMessage((String)"paramIsNotSpecified", (String)"springContextLocationValue"));
                }
            } else {
                throw new AxisFault(Messages.getMessage((String)"paramIsNotSpecified", (String)"APPLICATION_CONTEXT_LOCATION"));
            }
            GenericApplicationContext aCtx = GenericApplicationContextUtil.getSpringApplicationContext(axisService, springContextLocationValue);
            Parameter implBeanParam = axisService.getParameter(SERVICE_SPRING_BEANNAME);
            String beanName = ((String)implBeanParam.getValue()).trim();
            if (beanName != null) {
                if (aCtx == null) {
                    throw new Exception("Axis2 Can't find Spring's ApplicationContext");
                }
                if (aCtx.getBean(beanName) == null) {
                    throw new Exception("Axis2 Can't find Spring Bean: " + beanName);
                }
                return aCtx.getBean(beanName);
            }
            throw new AxisFault(Messages.getMessage((String)"paramIsNotSpecified", (String)"SERVICE_SPRING_BEANNAME"));
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }
}

