/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.springservices.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver;
import org.apache.axis2.rpc.receivers.RPCMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.GenericApplicationContext;
import org.wso2.carbon.springservices.ui.GenericApplicationContextUtil;
import org.wso2.carbon.springservices.ui.SpringBeansData;
import org.wso2.carbon.springservices.ui.fileupload.ServiceUploaderClient;
import org.wso2.carbon.utils.ArchiveManipulator;

public class SpringServiceMaker {
    private static final Log log = LogFactory.getLog(SpringServiceMaker.class);
    public static final String FILE_RESOURCE_MAP = "file.resource.map";
    private ConfigurationContext configContext = null;
    private ResourceBundle bundle;
    private static final String BUNDLE = "org.wso2.carbon.springservices.ui.i18n.Resources";
    private static final String SPRING_CONTEXT_SUPPLIER = "org.wso2.carbon.springservices.GenericApplicationContextSupplier";

    public SpringServiceMaker(ConfigurationContext context, Locale locale) {
        this.configContext = context;
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpringBeansData getSpringBeanNames(String springContextId, String springBeanId, ClassLoader bundleClassLoader) throws AxisFault {
        String springContextFilePath = this.getFilePathFromArchiveId(springContextId);
        String springBeanFilePath = this.getFilePathFromArchiveId(springBeanId);
        SpringBeansData data = new SpringBeansData();
        data.setSpringContext(springContextId);
        File urlFile = new File(springBeanFilePath);
        ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
        try {
            URL url = urlFile.toURL();
            URLClassLoader urlCl = URLClassLoader.newInstance(new URL[]{url}, bundleClassLoader);
            Thread.currentThread().setContextClassLoader(urlCl);
            GenericApplicationContext aCtx = GenericApplicationContextUtil.getSpringApplicationContext(springContextFilePath, springBeanFilePath);
            String[] beanDefintions = aCtx.getBeanDefinitionNames();
            data.setBeans(beanDefintions);
        }
        catch (Exception e) {
            String msg = this.bundle.getString("spring.cannot.load.spring.beans");
            this.handleException(msg, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCl);
        }
        return data;
    }

    public void createAndUploadSpringBean(String serviceHierarchy, String springContextId, ServiceUploaderClient client, String springBeanId, String[] beanClasses) throws Exception {
        String filePathFromArchiveId = this.getFilePathFromArchiveId(springBeanId);
        String filePathForSpringContext = this.getFilePathFromArchiveId(springContextId);
        Map fileResMap = (Map)this.configContext.getProperty(FILE_RESOURCE_MAP);
        fileResMap.remove(springContextId);
        if (filePathFromArchiveId == null) {
            String msg = this.bundle.getString("spring.non.existent.file");
            log.warn((Object)msg);
            throw new AxisFault(msg);
        }
        int endIndex = filePathFromArchiveId.lastIndexOf(File.separator);
        String filePath = filePathFromArchiveId.substring(0, endIndex);
        String archiveFileName = filePathFromArchiveId.substring(endIndex);
        archiveFileName = archiveFileName.substring(1, archiveFileName.lastIndexOf("."));
        ArchiveManipulator archiveManipulator = new ArchiveManipulator();
        String unzippeDir = filePath + File.separator + "springTemp";
        File unzipped = new File(unzippeDir);
        if (!unzipped.mkdirs()) {
            log.error((Object)"Error while creating directories..");
        }
        try {
            archiveManipulator.extract(filePathFromArchiveId, unzippeDir);
        }
        catch (IOException e) {
            String msg = this.bundle.getString("spring.cannot.extract.archive");
            this.handleException(msg, e);
        }
        String springContextRelLocation = "spring/context.xml";
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            File absFile;
            File springContextRelDir = new File(unzippeDir + File.separator + "spring");
            if (!springContextRelDir.mkdirs()) {
                log.error((Object)"Error while creating directories..");
            }
            if (!(absFile = new File(springContextRelDir, "context.xml")).exists() && !absFile.createNewFile()) {
                log.error((Object)"Error while creating file..");
            }
            File file = new File(filePathForSpringContext);
            in = new FileInputStream(file);
            out = new FileOutputStream(absFile);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((FileOutputStream)out).write(buf, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    ((FileOutputStream)out).close();
                }
            }
            catch (IOException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
        }
        File file = new File(unzippeDir + File.separator + "META-INF" + File.separator + "services.xml");
        if (!file.mkdirs()) {
            log.error((Object)"Error while creating directories..");
        }
        try {
            File absoluteFile = file.getAbsoluteFile();
            if (absoluteFile.exists() && !absoluteFile.delete()) {
                log.error((Object)"Error while deleting file..");
            }
            if (!absoluteFile.createNewFile()) {
                log.error((Object)"Error while creating file..");
            }
            FileOutputStream os = new FileOutputStream(file);
            OMElement servicesXML = this.createServicesXMLFromSpringBeans(beanClasses, springContextRelLocation);
            servicesXML.build();
            servicesXML.serialize((OutputStream)os);
        }
        catch (Exception e) {
            String msg = this.bundle.getString("spring.cannot.write.services.xml");
            this.handleException(msg, e);
        }
        String outAARFilename = filePath + File.separator + archiveFileName + ".aar";
        try {
            archiveManipulator.archiveDir(outAARFilename, unzipped.getPath());
        }
        catch (IOException e) {
            String msg = this.bundle.getString("springcannot.create.new.aar.archive");
            this.handleException(msg, e);
        }
        File fileToUpload = new File(outAARFilename);
        FileDataSource fileDataSource = new FileDataSource(fileToUpload);
        DataHandler dataHandler = new DataHandler((DataSource)fileDataSource);
        try {
            client.uploadService(archiveFileName + ".aar", serviceHierarchy, dataHandler);
        }
        catch (Exception e) {
            String msg = this.bundle.getString("spring.unable.to.upload");
            this.handleException(msg, e);
        }
    }

    private OMElement createServicesXMLFromSpringBeans(String[] springBeans, String springContextLocation) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace emptyNS = factory.createOMNamespace("", "");
        OMElement serviceGroupEle = factory.createOMElement("serviceGroup", "", "");
        for (int i = 0; i < springBeans.length; ++i) {
            String serviceBeanName = springBeans[i];
            OMElement serviceEle = factory.createOMElement("service", "", "");
            OMElement schemaEle = factory.createOMElement("schema", "", "");
            schemaEle.addAttribute(factory.createOMAttribute("elementFormDefaultQualified", emptyNS, "false"));
            serviceEle.addAttribute(factory.createOMAttribute("name", emptyNS, serviceBeanName));
            OMElement msgReceiversEle = factory.createOMElement("messageReceivers", "", "");
            OMElement msgReceiverEle1 = factory.createOMElement("messageReceiver", "", "");
            msgReceiverEle1.addAttribute("mep", "http://www.w3.org/ns/wsdl/in-only", emptyNS);
            msgReceiverEle1.addAttribute("class", RPCInOnlyMessageReceiver.class.getName(), emptyNS);
            OMElement msgReceiverEle2 = factory.createOMElement("messageReceiver", "", "");
            msgReceiverEle2.addAttribute("mep", "http://www.w3.org/ns/wsdl/in-out", emptyNS);
            msgReceiverEle2.addAttribute("class", RPCMessageReceiver.class.getName(), emptyNS);
            msgReceiversEle.addChild((OMNode)msgReceiverEle1);
            msgReceiversEle.addChild((OMNode)msgReceiverEle2);
            OMElement parameterEleServiceObjectSupplier = factory.createOMElement("parameter", "", "");
            parameterEleServiceObjectSupplier.addAttribute("locked", "true", emptyNS);
            parameterEleServiceObjectSupplier.addAttribute("name", "ServiceObjectSupplier", emptyNS);
            parameterEleServiceObjectSupplier.setText(SPRING_CONTEXT_SUPPLIER);
            OMElement parameterEleSpringBeanName = factory.createOMElement("parameter", "", "");
            parameterEleSpringBeanName.addAttribute("locked", "true", emptyNS);
            parameterEleSpringBeanName.addAttribute("name", "SpringBeanName", emptyNS);
            parameterEleSpringBeanName.setText(serviceBeanName);
            OMElement parameterEleSpringContextLocation = factory.createOMElement("parameter", "", "");
            parameterEleSpringContextLocation.addAttribute("locked", "true", emptyNS);
            parameterEleSpringContextLocation.addAttribute("name", "SpringContextLocation", emptyNS);
            parameterEleSpringContextLocation.setText(springContextLocation);
            OMElement paramEleserviceType = factory.createOMElement("parameter", "", "");
            paramEleserviceType.addAttribute("name", "serviceType", emptyNS);
            paramEleserviceType.setText("spring");
            serviceEle.addChild((OMNode)schemaEle);
            serviceEle.addChild((OMNode)msgReceiversEle);
            serviceEle.addChild((OMNode)parameterEleServiceObjectSupplier);
            serviceEle.addChild((OMNode)parameterEleSpringBeanName);
            serviceEle.addChild((OMNode)parameterEleSpringContextLocation);
            serviceEle.addChild((OMNode)paramEleserviceType);
            serviceGroupEle.addChild((OMNode)serviceEle);
        }
        return serviceGroupEle;
    }

    private String getFilePathFromArchiveId(String archiveId) {
        Map fileResMap = (Map)this.configContext.getProperty(FILE_RESOURCE_MAP);
        return (String)fileResMap.get(archiveId);
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

