/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.deployer.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;
import org.wso2.carbon.utils.component.xml.config.DeployerConfig;
import org.wso2.carbon.utils.deployment.Axis2DeployerProvider;
import org.wso2.carbon.webapp.mgt.DataHolder;

public class VirtualHostDeployerProvider
implements Axis2DeployerProvider {
    private List<DeployerConfig> deployerConfigs = new ArrayList<DeployerConfig>();

    public VirtualHostDeployerProvider() {
        Container[] virtualHosts;
        CarbonTomcatService carbonTomcatService = DataHolder.getCarbonTomcatService();
        for (Container vHost : virtualHosts = carbonTomcatService.getTomcat().getEngine().findChildren()) {
            Host childHost = (Host)vHost;
            String directory = this.getDirectoryName(childHost.getAppBase());
            this.deployerConfigs.add(this.getDeployerConfig(directory, ".war"));
            this.deployerConfigs.add(this.getDeployerConfig(directory, null));
        }
    }

    public List<DeployerConfig> getDeployerConfigs() {
        return this.deployerConfigs;
    }

    private DeployerConfig getDeployerConfig(String directoryName, String extension) {
        DeployerConfig deployerConfig = new DeployerConfig();
        deployerConfig.setClassStr("org.wso2.carbon.webapp.deployer.WebappDeployer");
        deployerConfig.setDirectory(directoryName);
        deployerConfig.setExtension(extension);
        return deployerConfig;
    }

    private String getDirectoryName(String appBase) {
        String baseDir = (appBase = appBase.replace("/", File.separator)).endsWith(File.separator) ? appBase.substring(0, appBase.lastIndexOf(File.separator)) : appBase;
        return baseDir.substring(baseDir.lastIndexOf(File.separator) + 1, baseDir.length());
    }
}

