/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.Cookie;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.catalina.util.SessionConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatGenericWebappsDeployer;

public class TomcatUtil {
    private static CarbonTomcatService carbonTomcatService;
    private static Map<String, TomcatGenericWebappsDeployer> webappsDeployers;
    private static Log log;

    public static boolean checkUnpackWars() {
        CarbonTomcatService carbonTomcatService = DataHolder.getCarbonTomcatService();
        return carbonTomcatService.isUnpackWARs();
    }

    public static void addWebappsDeployer(String webappsDir, TomcatGenericWebappsDeployer webappsDeployer) {
        CarbonUtils.checkSecurity();
        webappsDeployers.put(webappsDir, webappsDeployer);
    }

    public static Map<String, TomcatGenericWebappsDeployer> getWebappsDeployers() {
        CarbonUtils.checkSecurity();
        return Collections.unmodifiableMap(webappsDeployers);
    }

    public static String getApplicationNameFromContext(String contextName) {
        String appName = null;
        if (contextName.contains("webapps") || contextName.contains("jaggeryapps") || contextName.contains("jaxwebapps")) {
            if (contextName.startsWith("#")) {
                String[] temp = contextName.split("#");
                appName = temp[temp.length - 1];
            } else if (contextName.startsWith("/")) {
                String[] temp = contextName.split("/");
                appName = temp[temp.length - 1];
            }
        } else {
            appName = contextName;
        }
        return appName;
    }

    private static void parseSessionCookiesId(Request request) {
        Context context = request.getMappingData().context;
        if (context != null && !context.getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.COOKIE)) {
            return;
        }
        Cookie[] serverCookies = request.getCookies();
        int count = 0;
        if (serverCookies != null && (count = serverCookies.length) == 0) {
            return;
        }
        String sessionCookieName = SessionConfig.getSessionCookieName((Context)context);
        for (int i = 0; i < count; ++i) {
            Cookie cookie = serverCookies[i];
            if (!cookie.getName().equals(sessionCookieName)) continue;
            if (!request.isRequestedSessionIdFromCookie()) {
                request.setRequestedSessionId(cookie.getValue());
                request.setRequestedSessionCookie(true);
                request.setRequestedSessionURL(false);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Requested cookie session id is " + request.getRequestedSessionId()));
                continue;
            }
            if (request.isRequestedSessionIdValid()) continue;
            request.setRequestedSessionId(cookie.getValue());
        }
    }

    static {
        webappsDeployers = new HashMap<String, TomcatGenericWebappsDeployer>();
        log = LogFactory.getLog(TomcatUtil.class);
    }
}

