/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.loader;

import java.io.File;
import java.io.IOException;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.loader.WebappLoader;
import org.wso2.carbon.webapp.mgt.loader.CarbonWebappClassLoader;
import org.wso2.carbon.webapp.mgt.loader.ClassloadingContextBuilder;
import org.wso2.carbon.webapp.mgt.loader.WebappClassloadingContext;

public class CarbonWebappLoader
extends WebappLoader {
    public CarbonWebappLoader() {
    }

    public CarbonWebappLoader(ClassLoader parent) {
        super(parent);
    }

    protected void startInternal() throws LifecycleException {
        WebappClassloadingContext webappClassloadingContext;
        try {
            webappClassloadingContext = ClassloadingContextBuilder.buildClassloadingContext(this.getWebappFilePath());
        }
        catch (Exception e) {
            throw new LifecycleException(e.getMessage(), (Throwable)e);
        }
        super.startInternal();
        ((CarbonWebappClassLoader)((Object)this.getClassLoader())).setWebappCC(webappClassloadingContext);
    }

    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
    }

    private String getWebappFilePath() throws IOException {
        String webappFilePath = null;
        Context ctx = this.getContext();
        String docBase = ctx.getDocBase();
        Host host = (Host)ctx.getParent();
        String appBase = host.getAppBase();
        File canonicalAppBase = new File(appBase);
        canonicalAppBase = canonicalAppBase.isAbsolute() ? canonicalAppBase.getCanonicalFile() : new File(System.getProperty("carbon.home"), appBase).getCanonicalFile();
        File webappFile = new File(docBase);
        webappFilePath = webappFile.isAbsolute() ? webappFile.getCanonicalPath() : new File(canonicalAppBase, docBase).getPath();
        return webappFilePath;
    }
}

