/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.sso;

import java.io.File;
import java.util.Properties;
import org.apache.catalina.connector.Request;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.webapp.mgt.sso.WebappSSOConstants;

public class SSOUtils {
    private static Log log = LogFactory.getLog(SSOUtils.class);

    public static boolean isSSOSPConfigExists() {
        File configFile = new File(WebappSSOConstants.SSO_SP_CONFIG_PATH);
        return configFile.exists();
    }

    public static String generateIssuerID(String contextPath) {
        String issuerId = contextPath.replaceFirst("/webapps", "").replace("/", "_");
        if (issuerId.startsWith("_")) {
            issuerId = issuerId.substring(1);
        }
        return issuerId;
    }

    public static String getSAMLSSOURLforApp(String requestURI, Properties ssoSPConfigProperties) {
        return ssoSPConfigProperties.getProperty(WebappSSOConstants.APP_SERVER_URL) + requestURI + ssoSPConfigProperties.getProperty("SAMLSSOUrl");
    }

    public static String generateConsumerUrl(Request request, Properties ssoSPConfigProperties) {
        String assertionConsumerURL = request.getHeader(ssoSPConfigProperties.getProperty("CustomACSHeader"));
        if (StringUtils.isBlank((String)assertionConsumerURL)) {
            assertionConsumerURL = ssoSPConfigProperties.getProperty(WebappSSOConstants.APP_SERVER_URL) + request.getContextPath() + ssoSPConfigProperties.getProperty(WebappSSOConstants.CONSUMER_URL_POSTFIX);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting ACS_URL to : " + assertionConsumerURL));
        }
        return assertionConsumerURL;
    }

    public static String removeTenantFromURI(String uri, String customACSUrl, String tenantName) {
        String returnURI = uri;
        if (!(StringUtils.isBlank((String)customACSUrl) || StringUtils.isBlank((String)tenantName) || customACSUrl.contains(tenantName) || StringUtils.isBlank((String)returnURI))) {
            returnURI = returnURI.replace("/t/" + tenantName + "/webapps", "");
        }
        return returnURI;
    }
}

