/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.internal;

import java.util.ArrayList;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.application.deployer.service.ApplicationManagerService;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.deployment.DeploymentSynchronizer;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebContextParameter;
import org.wso2.carbon.webapp.mgt.utils.WebAppUtils;

@Component(name="org.wso2.carbon.webapp.mgt.internal.WebappManagementServiceComponent", immediate=true)
public class WebappManagementServiceComponent {
    private static final Log log = LogFactory.getLog(WebappManagementServiceComponent.class);
    private static ApplicationManagerService applicationManager;

    @Activate
    protected void activate(ComponentContext ctx) {
        try {
            this.setServerURLParam(DataHolder.getServerConfigContext());
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred while activating WebappManagementServiceComponent", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        DataHolder.setServerConfigContext(contextService.getServerConfigContext());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        DataHolder.setServerConfigContext(null);
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        DataHolder.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
    }

    @Reference(name="tenant.registryloader", service=TenantRegistryLoader.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetTenantRegistryLoader")
    protected void setTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        DataHolder.setTenantRegistryLoader(tenantRegistryLoader);
    }

    protected void unsetTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
    }

    @Reference(name="depsych.service", service=DeploymentSynchronizer.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetDeploymentSynchronizerService")
    protected void setDeploymentSynchronizerService(DeploymentSynchronizer depSynchService) {
        DataHolder.setDeploymentSynchronizerService(depSynchService);
    }

    protected void unsetDeploymentSynchronizerService(DeploymentSynchronizer depSynchService) {
        DataHolder.setDeploymentSynchronizerService(null);
    }

    private void setServerURLParam(ConfigurationContext configurationContext) {
        Map<String, WebApplicationsHolder> webApplicationsHolderList = WebAppUtils.getAllWebappHolders(configurationContext);
        WebContextParameter serverUrlParam = new WebContextParameter("webServiceServerURL", CarbonUtils.getServerURL((ServerConfigurationService)ServerConfiguration.getInstance(), (ConfigurationContext)configurationContext));
        ArrayList servletContextParameters = (ArrayList)configurationContext.getProperty("servlet.context.parameters.list");
        if (servletContextParameters != null) {
            servletContextParameters.add(serverUrlParam);
        }
        for (WebApplicationsHolder webApplicationsHolder : webApplicationsHolderList.values()) {
            if (webApplicationsHolder == null) continue;
            for (WebApplication application : webApplicationsHolder.getStartedWebapps().values()) {
                application.getContext().getServletContext().setAttribute(serverUrlParam.getName(), (Object)serverUrlParam.getValue());
            }
        }
    }

    @Reference(name="application.manager", service=ApplicationManagerService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetAppManager")
    protected void setAppManager(ApplicationManagerService applicationManager) {
        WebappManagementServiceComponent.applicationManager = applicationManager;
        DataHolder.setApplicationManager(applicationManager);
    }

    protected void unsetAppManager(ApplicationManagerService appManager) {
        applicationManager = null;
    }
}

