/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRegistration;
import org.apache.axis2.AxisFault;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.persistence.metadata.ArtifactMetadataException;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.FileManipulator;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatGenericWebappsDeployer;
import org.wso2.carbon.webapp.mgt.TomcatUtil;
import org.wso2.carbon.webapp.mgt.WebContextParameter;
import org.wso2.carbon.webapp.mgt.utils.WebAppUtils;

public class WebApplication {
    private static final Log log = LogFactory.getLog(WebApplication.class);
    public static final String ENABLE_SAAS = "carbon.enable.saas";
    private Context context;
    private File webappFile;
    private long lastModifiedTime;
    private Exception faultReason;
    private String state;
    private String serviceListPath;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private TomcatGenericWebappsDeployer tomcatGenericWebappsDeployer;
    private String version;
    private String hostName;
    private boolean isThisGhost = false;

    public WebApplication(TomcatGenericWebappsDeployer tomcatGenericWebappsDeployer, Context context, File webappFile) {
        this.tomcatGenericWebappsDeployer = tomcatGenericWebappsDeployer;
        this.context = context;
        this.hostName = WebAppUtils.getMatchingHostName(WebAppUtils.getWebappDirPath(webappFile.getAbsolutePath()));
        this.setWebappFile(webappFile);
        this.setLastModifiedTime(webappFile.lastModified());
        String versionString = context.getName();
        if (context.getName().startsWith("/t/")) {
            versionString = versionString.substring(StringUtils.ordinalIndexOf((String)context.getName(), (String)"/", (int)4) + 1);
        } else if (context.getName().startsWith("/")) {
            versionString = versionString.substring(1);
        }
        if (versionString.contains("/")) {
            versionString = versionString.substring(versionString.indexOf("/"));
            this.setVersion(versionString);
        } else {
            this.setVersion("/default");
        }
        boolean isFaulty = this.checkFaultyWebappParam(context);
        if (isFaulty || !"STARTED".equalsIgnoreCase(context.getStateName())) {
            return;
        }
        String serviceListPathParamName = "service-list-path";
        String serviceListPathParam = context.getServletContext().getInitParameter(serviceListPathParamName);
        if ("".equals(serviceListPathParam) || serviceListPathParam == null) {
            ServletRegistration servletReg;
            Map servletRegs = context.getServletContext().getServletRegistrations();
            Iterator iterator = servletRegs.values().iterator();
            while (iterator.hasNext() && "".equals(serviceListPathParam = (servletReg = (ServletRegistration)iterator.next()).getInitParameter(serviceListPathParamName)) && serviceListPathParam == null) {
            }
        }
        serviceListPathParam = "".equals(serviceListPathParam) || serviceListPathParam == null ? "/services" : "";
        this.setServiceListPath(serviceListPathParam);
    }

    private boolean checkFaultyWebappParam(Context context) {
        String param = context.findParameter("faulty.webapp");
        return param != null && !"".equals(param) && Boolean.parseBoolean(param);
    }

    public void setServletContextParameters(List<WebContextParameter> parameters) {
        for (WebContextParameter parameter : parameters) {
            this.context.getServletContext().setAttribute(parameter.getName(), (Object)parameter.getValue());
        }
    }

    public File getWebappFile() {
        return this.webappFile;
    }

    public void setWebappFile(File webappFile) {
        this.webappFile = webappFile;
    }

    public String getContextName() {
        return "".equals(this.context.getName()) ? "/" : this.context.getName();
    }

    public String getDisplayName() {
        return this.context.getDisplayName();
    }

    public void setDisplayName(String name) {
        this.context.setDisplayName(name);
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Exception getFaultReason() {
        return this.faultReason;
    }

    public void setFaultReason(Exception faultReason) {
        this.faultReason = faultReason;
    }

    public void setProperty(String key, Object value) {
        if (key != null) {
            this.properties.put(key, value);
        }
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public boolean getDistributable() {
        return this.context.getDistributable();
    }

    public void setDistributable(boolean distributable) {
        this.context.setDistributable(distributable);
    }

    public String getDocBase() {
        return this.context.getDocBase();
    }

    public void setDocBase(String docBase) {
        this.context.setDocBase(docBase);
    }

    public void addParameter(String name, String value) {
        this.removeParameter(name);
        this.context.addParameter(name, value);
    }

    public void removeParameter(String name) {
        this.context.removeParameter(name);
    }

    public String findParameter(String contextParamName) {
        return this.context.findParameter(contextParamName);
    }

    public String[] findParameters() {
        return this.context.findParameters();
    }

    public TomcatGenericWebappsDeployer getTomcatGenericWebappsDeployer() {
        return this.tomcatGenericWebappsDeployer;
    }

    public boolean reload() {
        boolean reloaded = false;
        String bamEnable = "";
        try {
            bamEnable = this.getBamEnableFromWebappMetaData();
        }
        catch (Exception e) {
            log.error((Object)"Unable to get bam enable from web app meta data.", (Throwable)e);
        }
        reloaded = this.reload(this.context);
        if (this.context.findParameter("enable.statistics") != null) {
            this.context.removeParameter("enable.statistics");
        }
        this.context.addParameter("enable.statistics", bamEnable);
        return reloaded;
    }

    private boolean reload(Context contextOfWepap) {
        if (this.context.getState().isAvailable()) {
            contextOfWepap.reload();
            log.info((Object)("Reloaded webapp: " + contextOfWepap));
            return true;
        }
        return false;
    }

    protected String getBamEnableFromWebappMetaData() throws AxisFault, ArtifactMetadataException {
        return this.tomcatGenericWebappsDeployer.recievePersistedWebappMetaData(this.getWebappFile(), "enable.statistics");
    }

    protected void updateWebappMetaDataforBam(String value) {
        try {
            this.tomcatGenericWebappsDeployer.setPersistedWebappMetaData(this.getWebappFile(), "enable.statistics", value);
            this.reload();
        }
        catch (Exception e) {
            log.error((Object)"Unable to persist data - bam enable", (Throwable)e);
        }
    }

    public boolean stop() throws CarbonException {
        return this.stop(this.context);
    }

    private boolean stop(Context contextOfWepap) throws CarbonException {
        try {
            if (this.context.getState().isAvailable()) {
                contextOfWepap.stop();
                this.setState("Stopped");
                log.info((Object)("Stopped webapp: " + contextOfWepap));
                return true;
            }
        }
        catch (Exception e) {
            throw new CarbonException("Cannot temporarilly stop webapp " + contextOfWepap, (Throwable)e);
        }
        return false;
    }

    public boolean start() throws CarbonException {
        return this.start(this.context);
    }

    private boolean start(Context contextOfWepap) throws CarbonException {
        try {
            if (!this.context.getState().isAvailable()) {
                contextOfWepap.start();
                this.setState("Started");
                log.info((Object)("Started webapp: " + contextOfWepap));
                return true;
            }
        }
        catch (Exception e) {
            throw new CarbonException("Cannot start webapp " + contextOfWepap, (Throwable)e);
        }
        return false;
    }

    public void lazyUnload() throws CarbonException {
        this.lazyUnload(this.context);
    }

    private void lazyUnload(Context context) throws CarbonException {
        if (DataHolder.getCarbonTomcatService() != null) {
            Host host = DataHolder.getCarbonTomcatService().getTomcat().getHost();
            try {
                if (context.getState().isAvailable()) {
                    context.setRealm(null);
                    context.stop();
                    context.destroy();
                    host.removeChild((Container)context);
                    log.info((Object)("Unloaded webapp: " + context));
                } else if (LifecycleState.STOPPED.equals((Object)context.getState())) {
                    context.setRealm(null);
                    context.destroy();
                    host.removeChild((Container)context);
                    log.info((Object)("Unloaded webapp: " + context));
                }
            }
            catch (Exception e) {
                throw new CarbonException("Cannot lazy unload webapp " + this.context, (Throwable)e);
            }
        }
    }

    public void undeploy() throws CarbonException {
        File webappDir;
        PrivilegedCarbonContext currentCarbonAppContextHolder = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        currentCarbonAppContextHolder.setApplicationName(TomcatUtil.getApplicationNameFromContext(this.context.getBaseName()));
        this.lazyUnload();
        if (this.webappFile.getAbsolutePath().endsWith(".war")) {
            String filePath = this.webappFile.getAbsolutePath();
            webappDir = new File(filePath.substring(0, filePath.lastIndexOf(46)));
        } else {
            webappDir = this.webappFile;
        }
        String cAppTmpDir = CarbonUtils.getTmpDir() + File.separator + "carbonapps" + File.separator;
        if (webappDir.getAbsolutePath().contains(cAppTmpDir)) {
            String webappDeploymentDir = webappDir.getAbsolutePath().substring(webappDir.getAbsolutePath().lastIndexOf(File.separator) + 1, webappDir.getAbsolutePath().length());
            webappDir = new File(DataHolder.getServerConfigContext().getAxisConfiguration().getRepository().getPath() + File.separator + "webapps" + File.separator + webappDeploymentDir);
        }
        if (TomcatUtil.checkUnpackWars() && webappDir.exists() && !this.webappFile.isDirectory() && !FileManipulator.deleteDir((File)webappDir)) {
            throw new CarbonException("exploded Webapp directory " + webappDir + " deletion failed");
        }
        this.removeWebappStoppedStatus(this);
    }

    public void delete() throws CarbonException {
        this.undeploy();
        if (this.webappFile.isFile() && !this.webappFile.delete()) {
            throw new CarbonException("Webapp file " + this.webappFile + " deletion failed");
        }
        if (this.webappFile.isDirectory() && !FileManipulator.deleteDir((File)this.webappFile)) {
            throw new CarbonException("Webapp Directory " + this.webappFile + " deletion failed");
        }
    }

    protected File getAppBase() {
        File appBase = null;
        File file = new File(DataHolder.getCarbonTomcatService().getTomcat().getHost().getAppBase());
        try {
            appBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            appBase = file;
        }
        return appBase;
    }

    private String getConfigFile(String path) {
        String basename = path.equals("") ? "ROOT" : path.substring(1).replace('/', '#');
        return basename;
    }

    private File getConfigBase() {
        File configBase = new File(System.getProperty("catalina.base"), "conf");
        Context host = null;
        Context engine = null;
        for (Context container = this.context; container != null; container = container.getParent()) {
            if (container instanceof Host) {
                host = container;
            }
            if (!(container instanceof Engine)) continue;
            engine = container;
        }
        if (engine != null) {
            configBase = new File(configBase, engine.getName());
        }
        if (host != null) {
            configBase = new File(configBase, host.getName());
        }
        return configBase;
    }

    private String getDocBase(String path) {
        String basename = path.equals("") ? "ROOT" : path.substring(1);
        return basename;
    }

    public void expireAllSessions() {
        Session[] sessions;
        for (Session session : sessions = this.context.getManager().findSessions()) {
            session.expire();
        }
    }

    public void expireSessions(long maxLifetimeMillis) {
        Session[] sessions;
        for (Session session : sessions = this.context.getManager().findSessions()) {
            if (System.currentTimeMillis() - session.getCreationTime() < maxLifetimeMillis) continue;
            session.expire();
        }
    }

    public void expireSessions(String[] sessionIDs) throws CarbonException {
        Manager manager = this.context.getManager();
        try {
            for (String sessionID : sessionIDs) {
                manager.findSession(sessionID).expire();
            }
        }
        catch (IOException e) {
            throw new CarbonException("Cannot expire sessions", (Throwable)e);
        }
    }

    public List<HttpSession> getSessions() {
        Session[] tomcatSessions = this.context.getManager().findSessions();
        ArrayList<HttpSession> sessions = new ArrayList<HttpSession>();
        for (Session tomcatSession : tomcatSessions) {
            sessions.add(new HttpSession(tomcatSession));
        }
        return sessions;
    }

    public HttpSession getSession(String sessionId) throws CarbonException {
        Session session;
        try {
            session = this.context.getManager().findSession(sessionId);
        }
        catch (IOException e) {
            throw new CarbonException("Cannot find session " + sessionId, (Throwable)e);
        }
        if (session != null) {
            return new HttpSession(session);
        }
        return null;
    }

    public Statistics getStatistics() {
        return new Statistics(this.context.getManager());
    }

    public String toString() {
        return this.context + ".File[" + this.webappFile.getAbsolutePath() + "]";
    }

    public String getServiceListPath() {
        return this.serviceListPath;
    }

    public void setServiceListPath(String serviceListPath) {
        this.serviceListPath = serviceListPath;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public Context getContext() {
        return this.context;
    }

    public void setIsGhostWebapp(boolean isThisGhost) {
        this.isThisGhost = isThisGhost;
    }

    private String getWebappKey() {
        return this.hostName + ":" + this.webappFile.getName();
    }

    private void removeWebappStoppedStatus(WebApplication webApplication) {
        if (DataHolder.getRegistryService() != null) {
            try {
                Resource webappResource;
                UserRegistry configSystemRegistry = DataHolder.getRegistryService().getConfigSystemRegistry(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
                String webappResourcePath = WebAppUtils.getWebappResourcePath(webApplication);
                if (configSystemRegistry.resourceExists(webappResourcePath) && (webappResource = configSystemRegistry.get(webappResourcePath)).getProperty("Status") != null) {
                    webappResource.removeProperty("Status");
                    configSystemRegistry.put(webappResourcePath, webappResource);
                }
            }
            catch (RegistryException e) {
                log.error((Object)("Failed to remove persisted webapp stopped state for: " + webApplication.getContext()));
            }
        }
    }

    public static class HttpSession {
        private Session tomcatSession;

        public HttpSession(Session tomcatSession) {
            this.tomcatSession = tomcatSession;
        }

        public String getSessionId() {
            return this.tomcatSession.getId();
        }

        public String getAuthType() {
            return this.tomcatSession.getAuthType();
        }

        public long getCreationTime() {
            return this.tomcatSession.getCreationTime();
        }

        public long getLastAccessedTime() {
            return this.tomcatSession.getLastAccessedTime();
        }

        public long getMaxInactiveInterval() {
            return this.tomcatSession.getMaxInactiveInterval();
        }

        public void expire() {
            this.tomcatSession.expire();
        }
    }

    public final class Statistics {
        private Manager sessionManager;

        private Statistics(Manager sessionManager) {
            this.sessionManager = sessionManager;
        }

        public int getMaxActiveSessions() {
            return this.isGhostWebApp() ? 0 : this.sessionManager.getMaxActive();
        }

        public int getMaxSessionInactivityInterval() {
            return this.isGhostWebApp() ? 0 : this.sessionManager.getContext().getSessionTimeout();
        }

        public int getMaxSessionLifetime() {
            return this.isGhostWebApp() ? 0 : this.sessionManager.getSessionMaxAliveTime();
        }

        public int getAvgSessionLifetime() {
            return this.isGhostWebApp() ? 0 : this.sessionManager.getSessionAverageAliveTime();
        }

        public int getRejectedSessions() {
            return this.isGhostWebApp() ? 0 : this.sessionManager.getRejectedSessions();
        }

        public int getActiveSessions() {
            return this.isGhostWebApp() ? 0 : this.sessionManager.getActiveSessions();
        }

        public long getExpiredSessions() {
            return this.isGhostWebApp() ? 0L : this.sessionManager.getExpiredSessions();
        }

        private boolean isGhostWebApp() {
            return GhostDeployerUtils.isGhostOn() && (WebApplication.this.isThisGhost || this.sessionManager == null);
        }
    }
}

