/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.persistence.metadata.ArtifactMetadataException;
import org.wso2.carbon.core.persistence.metadata.ArtifactMetadataManager;
import org.wso2.carbon.core.persistence.metadata.DeploymentArtifactMetadataFactory;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.utils.WebAppUtils;

public class WebappMetadataDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(WebappMetadataDeployer.class);
    private ConfigurationContext configContext;
    private AxisConfiguration axisConfig;
    private DeploymentArtifactMetadataFactory metadataFactory;
    private String webappMetaDataDir;

    public void init(ConfigurationContext configurationContext) {
        this.configContext = configurationContext;
        this.axisConfig = configurationContext.getAxisConfiguration();
        try {
            this.metadataFactory = DeploymentArtifactMetadataFactory.getInstance((AxisConfiguration)this.axisConfig);
        }
        catch (AxisFault e) {
            log.error((Object)"Error obtaining Deployment Artifact Metadata Factory.", (Throwable)e);
        }
    }

    public void setDirectory(String directory) {
        if (directory.contains("/")) {
            directory = directory.replace("/", File.separator);
        }
        this.webappMetaDataDir = directory;
    }

    public void setExtension(String s) {
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        String artifactName = this.getArtifactFilePath(deploymentFileData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Detected Webapp meta file change.." + artifactName));
        }
        try {
            WebApplicationsHolder webappsHolder = WebAppUtils.getWebappHolder(deploymentFileData.getAbsolutePath(), this.configContext);
            Map<String, WebApplication> startedWebapps = webappsHolder.getStartedWebapps();
            WebApplication webapp = startedWebapps.get(artifactName);
            if (webapp != null) {
                this.loadPersistData(deploymentFileData.getAbsolutePath(), webapp);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No stopped webapp " + artifactName + "found for tenant:"));
            }
        }
        catch (AxisFault e) {
            log.info((Object)e.getMessage(), (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        catch (ArtifactMetadataException e) {
            log.info((Object)e.getMessage(), (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
    }

    private void loadPersistData(String path, WebApplication webapp) throws ArtifactMetadataException, AxisFault {
        ArtifactMetadataManager manager = DeploymentArtifactMetadataFactory.getInstance((AxisConfiguration)this.axisConfig).getMetadataManager();
        Properties prop = manager.loadParameters(path);
        for (String propName : prop.stringPropertyNames()) {
            String propValue = prop.getProperty(propName);
            webapp.addParameter(propName, propValue);
        }
    }

    private String getArtifactFilePath(DeploymentFileData deploymentFileData) {
        String path = deploymentFileData.getAbsolutePath();
        String artifactName = path.substring(path.indexOf(this.webappMetaDataDir) + this.webappMetaDataDir.length() + 1);
        artifactName = artifactName.substring(0, artifactName.lastIndexOf(".properties"));
        return artifactName.replace("\\", "/").replace("/", "#");
    }
}

