/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.session;

import java.util.Map;
import java.util.Set;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.session.SessionMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.session.CarbonTomcatClusterableSessionManager;

public class CarbonSessionReplicationMessage
extends ClusteringMessage {
    private static final transient Log log = LogFactory.getLog(CarbonSessionReplicationMessage.class);
    private ClusterMessage clusterMessage;
    private int tenantId;

    public CarbonSessionReplicationMessage() {
    }

    public CarbonSessionReplicationMessage(int tenantId) {
        this.tenantId = tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public void setSessionClusterMessage(ClusterMessage clusterMessage) {
        this.clusterMessage = clusterMessage;
    }

    public ClusteringCommand getResponse() {
        return new CarbonSessionReplicationMessage();
    }

    public void execute(ConfigurationContext mainConfigContext) throws ClusteringFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Recieved CarbonSessionReplicationMessage");
        }
        try {
            if (this.clusterMessage != null) {
                CarbonTomcatClusterableSessionManager manager;
                String context;
                String tenantDomain = DataHolder.getRealmService().getTenantManager().getDomain(this.tenantId);
                ConfigurationContext configContext = null;
                if (this.tenantId == -1234 || this.tenantId == -1) {
                    configContext = mainConfigContext;
                } else if (TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)mainConfigContext).get(tenantDomain) != null) {
                    configContext = (ConfigurationContext)TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)mainConfigContext).get(tenantDomain);
                }
                if (configContext == null) {
                    return;
                }
                Map sessionManagerMap = (Map)configContext.getProperty("CarbonTomcatSessionManagerMap");
                if (sessionManagerMap != null && !sessionManagerMap.isEmpty() && ((SessionMessage)this.clusterMessage).getContextName() != null && (context = this.getWebappContext(((SessionMessage)this.clusterMessage).getContextName(), sessionManagerMap.keySet())) != null && (manager = (CarbonTomcatClusterableSessionManager)((Object)sessionManagerMap.get(context))) != null) {
                    manager.clusterMessageReceived(this.clusterMessage);
                }
            }
        }
        catch (Exception e) {
            throw new ClusteringFault(e.getMessage(), e);
        }
    }

    private String getWebappContext(String path, Set<String> contextSet) {
        for (String key : contextSet) {
            if (!path.contains(key) || !path.endsWith(key)) continue;
            return key;
        }
        return null;
    }
}

