/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.sync;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebapplicationHelper;
import org.wso2.carbon.webapp.mgt.WebappsConstants;
import org.wso2.carbon.webapp.mgt.utils.WebAppUtils;

public class ApplicationSynchronizeRequest
extends ClusteringMessage {
    private static final transient Log log = LogFactory.getLog(ApplicationSynchronizeRequest.class);
    private int tenantId;
    private String tenantDomain;
    private UUID messageId;
    private WebappsConstants.ApplicationOpType operation;
    private List<WebapplicationHelper> webapplicationHelperList;

    public ApplicationSynchronizeRequest() {
    }

    public ApplicationSynchronizeRequest(int tenantId, String tenantDomain, UUID messageId, WebappsConstants.ApplicationOpType applicationOpType, List<WebapplicationHelper> webapplicationHelperList) {
        this.tenantId = tenantId;
        this.tenantDomain = tenantDomain;
        this.messageId = messageId;
        this.operation = applicationOpType;
        this.webapplicationHelperList = webapplicationHelperList;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(ConfigurationContext configContext) throws ClusteringFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received [" + (Object)((Object)this) + "] "));
        }
        if (this.tenantId != -1234 && TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)configContext).get(this.tenantDomain) == null) {
            if (!log.isDebugEnabled()) return;
            log.debug((Object)("Tenant is not loaded. TID - " + this.tenantId + " TD - " + this.tenantDomain));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to synchronize Application status for tenant: TID - " + this.tenantId + " TD - " + this.tenantDomain));
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            privilegedCarbonContext.setTenantId(this.tenantId);
            privilegedCarbonContext.setTenantDomain(this.tenantDomain);
            ConfigurationContext tenantConfigurationContext = this.tenantId == -1234 ? configContext : (ConfigurationContext)TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)configContext).get(this.tenantDomain);
            Map<String, WebApplicationsHolder> webApplicationsHolderMap = WebAppUtils.getAllWebappHolders(configContext);
            switch (this.operation) {
                case STOP: {
                    this.stopApplications(webApplicationsHolderMap);
                    return;
                }
                case START: {
                    this.startApplications(tenantConfigurationContext, webApplicationsHolderMap);
                    return;
                }
                case RELOAD: {
                    this.reloadApplications(webApplicationsHolderMap);
                    return;
                }
            }
            return;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private void startApplications(ConfigurationContext configContext, Map<String, WebApplicationsHolder> webApplicationsHolderMap) {
        for (WebApplicationsHolder webApplicationsHolder : webApplicationsHolderMap.values()) {
            Map<String, WebApplication> stoppedWebapps = webApplicationsHolder.getStoppedWebapps();
            Deployer webappDeployer = ((DeploymentEngine)configContext.getAxisConfiguration().getConfigurator()).getDeployer(webApplicationsHolder.getWebappsDir().getName(), "war");
            for (WebapplicationHelper webapplicationHelper : this.webapplicationHelperList) {
                WebApplication webApplication = stoppedWebapps.get(webapplicationHelper.getWebappName());
                if (webApplication != null && webapplicationHelper.getHostName().equals(webApplication.getHostName())) {
                    try {
                        boolean started = webApplication.start();
                        if (!started) continue;
                        String startedWebappFileName = webApplication.getWebappFile().getName();
                        stoppedWebapps.remove(startedWebappFileName);
                        Map<String, WebApplication> startedWebapps = webApplicationsHolder.getStartedWebapps();
                        startedWebapps.put(startedWebappFileName, webApplication);
                    }
                    catch (CarbonException e) {
                        String msg = "Cannot start Application " + webApplication;
                        log.error((Object)msg, (Throwable)e);
                    }
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No stopped webapp " + webapplicationHelper.getWebappName() + "found for tenant:" + this.tenantDomain));
            }
        }
    }

    private void reloadApplications(Map<String, WebApplicationsHolder> webApplicationsHolderMap) {
        for (WebApplicationsHolder webApplicationsHolder : webApplicationsHolderMap.values()) {
            for (WebapplicationHelper webapplicationHelper : this.webapplicationHelperList) {
                WebApplication webApplication = webApplicationsHolder.getStartedWebapps().get(webapplicationHelper.getWebappName());
                if (webApplication == null || !webapplicationHelper.getHostName().equals(webApplication.getHostName())) continue;
                webApplication.reload();
            }
        }
    }

    private void stopApplications(Map<String, WebApplicationsHolder> webApplicationsHolderMap) {
        for (WebApplicationsHolder webApplicationsHolder : webApplicationsHolderMap.values()) {
            Map<String, WebApplication> startedWebapps = webApplicationsHolder.getStartedWebapps();
            for (WebapplicationHelper webapplicationHelper : this.webapplicationHelperList) {
                try {
                    WebApplication webApplication = startedWebapps.get(webapplicationHelper.getWebappName());
                    if (webApplication != null && webapplicationHelper.getHostName().equals(webApplication.getHostName())) {
                        webApplicationsHolder.stopWebapp(webApplication);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("No started webapp " + webapplicationHelper.getWebappName() + "found for tenant:" + this.tenantDomain));
                }
                catch (CarbonException e) {
                    log.error((Object)"Error occurred while undeploying Applications", (Throwable)e);
                }
            }
        }
    }

    public ClusteringCommand getResponse() {
        return null;
    }

    public String toString() {
        return "ApplicationSynchronizeRequest{tenantId=" + this.tenantId + ", tenantDomain='" + this.tenantDomain + '\'' + ", messageId=" + this.messageId + '}';
    }
}

