/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.utils;

import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;

public class XMLUtils {
    private static Log log = LogFactory.getLog(XMLUtils.class);

    public static Document buildDocumentFromFile(File xmlFile) throws Exception {
        DocumentBuilderFactory dbFactory = XMLUtils.getSecuredDocumentBuilder();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(xmlFile);
        doc.getDocumentElement().normalize();
        return doc;
    }

    public static Document buildDocumentFromInputStream(InputStream is) throws Exception {
        DocumentBuilderFactory dbFactory = XMLUtils.getSecuredDocumentBuilder();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(is);
        doc.getDocumentElement().normalize();
        return doc;
    }

    public static DocumentBuilderFactory getSecuredDocumentBuilder() {
        Object Constants2 = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbf.setFeature("http://apache.org/xml/features/" + "disallow-doctype-decl", true);
            dbf.setFeature("http://xml.org/sax/features/" + "external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/" + "external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/" + "nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)("Failed to load XML Processor Feature " + "external-general-entities" + " or " + "external-parameter-entities" + " or " + "nonvalidating/load-external-dtd"));
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/" + "security-manager", securityManager);
        return dbf;
    }
}

