/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.loader;

import java.util.ArrayList;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.wso2.carbon.webapp.mgt.loader.ClassloadingConfiguration;
import org.wso2.carbon.webapp.mgt.loader.ClassloadingContextBuilder;

public class WebappClassloadingContext {
    private static final Log log = LogFactory.getLog(WebappClassloadingContext.class);
    private boolean parentFirst = false;
    private String[] delegatedPackages;
    private String[] delegatedPackageStems;
    private String[] excludeedPackages;
    private String[] excludeedPackageStems;
    private String[] delegatedResources;
    private String[] delegatedResourceStems;
    private String[] excludeedResources;
    private String[] excludeedResourceStems;
    private boolean noExcludedPackages = true;
    private boolean noExcludedResources = true;
    private String[] repositories;
    private static ClassloadingConfiguration classloadingConfig;
    private boolean delegateAllPackages = false;
    private boolean delegateAllResources = false;
    private String[] environments;

    public static ClassloadingConfiguration getClassloadingConfig() {
        return classloadingConfig;
    }

    public boolean isDelegatedPackage(String name) {
        if (this.delegateAllPackages) {
            return true;
        }
        if (name == null) {
            return false;
        }
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return false;
        }
        String packageName = name.substring(0, pos);
        for (String delegatedPkg : this.delegatedPackageStems) {
            if (!packageName.startsWith(delegatedPkg)) continue;
            return true;
        }
        for (String delegatedPkg : this.delegatedPackages) {
            if (!packageName.equals(delegatedPkg)) continue;
            return true;
        }
        return false;
    }

    public void setDelegatedPackages(String[] delegatedPkgList) {
        ArrayList<String> delegatedPackageList = new ArrayList<String>();
        ArrayList<String> delegatedPackageStemList = new ArrayList<String>();
        ArrayList<String> excludedPackageList = new ArrayList<String>();
        ArrayList<String> excludedPackageStemList = new ArrayList<String>();
        for (String packageName : delegatedPkgList) {
            if (packageName.startsWith("!")) {
                if ((packageName = packageName.substring(1)).endsWith(".*")) {
                    excludedPackageStemList.add(packageName.substring(0, packageName.length() - 2));
                    continue;
                }
                excludedPackageList.add(packageName);
                continue;
            }
            if (packageName.equals("*")) {
                this.delegateAllPackages = true;
                continue;
            }
            if (packageName.endsWith(".*")) {
                delegatedPackageStemList.add(packageName.substring(0, packageName.length() - 2));
                continue;
            }
            delegatedPackageList.add(packageName);
        }
        if (excludedPackageList.size() > 0 || excludedPackageStemList.size() > 0) {
            this.noExcludedPackages = false;
        }
        if (!this.noExcludedPackages) {
            this.excludeedPackages = excludedPackageList.toArray(new String[excludedPackageList.size()]);
            this.excludeedPackageStems = excludedPackageStemList.toArray(new String[excludedPackageStemList.size()]);
        }
        if (!this.delegateAllPackages) {
            this.delegatedPackages = delegatedPackageList.toArray(new String[delegatedPackageList.size()]);
            this.delegatedPackageStems = delegatedPackageStemList.toArray(new String[delegatedPackageStemList.size()]);
        }
    }

    public String[] getProvidedRepositories() {
        return this.repositories;
    }

    public void setProvidedRepositories(String[] repositories) {
        this.repositories = repositories;
    }

    public boolean isParentFirst() {
        return this.parentFirst;
    }

    public void setParentFirst(boolean parentFirst) {
        this.parentFirst = parentFirst;
    }

    public boolean isExcludedPackage(String name) {
        if (this.noExcludedPackages) {
            return false;
        }
        if (name == null) {
            return false;
        }
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return false;
        }
        String packageName = name.substring(0, pos);
        for (String excludedPkg : this.excludeedPackageStems) {
            if (!packageName.startsWith(excludedPkg)) continue;
            return true;
        }
        for (String excludedPkg : this.excludeedPackages) {
            if (!packageName.equals(excludedPkg)) continue;
            return true;
        }
        return false;
    }

    public void setEnvironments(String[] environments) {
        this.environments = environments;
    }

    public String[] getEnvironments() {
        return this.environments;
    }

    public boolean isExcludedResources(String name) {
        if (this.noExcludedResources) {
            return false;
        }
        if (name == null) {
            return false;
        }
        for (String excludedRes : this.excludeedResourceStems) {
            if (!name.startsWith(excludedRes)) continue;
            return true;
        }
        for (String excludedRes : this.excludeedResources) {
            if (!name.equals(excludedRes)) continue;
            return true;
        }
        return false;
    }

    public boolean isDelegatedResource(String name) {
        if (this.delegateAllResources) {
            return true;
        }
        if (name == null) {
            return false;
        }
        for (String delegatedRes : this.delegatedResourceStems) {
            if (!name.startsWith(delegatedRes)) continue;
            return true;
        }
        for (String delegatedRes : this.delegatedResources) {
            if (!name.equals(delegatedRes)) continue;
            return true;
        }
        return false;
    }

    public void setDelegatedResources(String[] delegatedResourceList) {
        ArrayList<String> delegatedResList = new ArrayList<String>();
        ArrayList<String> delegatedResStemList = new ArrayList<String>();
        ArrayList<String> excludedResList = new ArrayList<String>();
        ArrayList<String> excludedResStemList = new ArrayList<String>();
        for (String resourceName : delegatedResourceList) {
            if (resourceName.startsWith("!")) {
                if ((resourceName = resourceName.substring(1)).endsWith("/*")) {
                    excludedResStemList.add(resourceName.substring(0, resourceName.length() - 2));
                    continue;
                }
                excludedResList.add(resourceName);
                continue;
            }
            if (resourceName.equals("*")) {
                this.delegateAllResources = true;
                continue;
            }
            if (resourceName.endsWith("/*")) {
                delegatedResStemList.add(resourceName.substring(0, resourceName.length() - 2));
                continue;
            }
            delegatedResList.add(resourceName);
        }
        if (excludedResList.size() > 0 || excludedResStemList.size() > 0) {
            this.noExcludedResources = false;
        }
        if (!this.noExcludedResources) {
            this.excludeedResources = excludedResList.toArray(new String[excludedResList.size()]);
            this.excludeedResourceStems = excludedResStemList.toArray(new String[excludedResStemList.size()]);
        }
        if (!this.delegateAllResources) {
            this.delegatedResources = delegatedResList.toArray(new String[delegatedResList.size()]);
            this.delegatedResourceStems = delegatedResStemList.toArray(new String[delegatedResStemList.size()]);
        }
    }

    static {
        try {
            classloadingConfig = ClassloadingContextBuilder.buildSystemConfig();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

