/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatGenericWebappsDeployer;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebContextParameter;
import org.wso2.carbon.webapp.mgt.utils.WebAppUtils;

public abstract class AbstractWebappDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(AbstractWebappDeployer.class);
    protected String webappsDir;
    protected String extension;
    protected TomcatGenericWebappsDeployer tomcatWebappDeployer;
    protected final List<WebContextParameter> servletContextParameters = new ArrayList<WebContextParameter>();
    protected ConfigurationContext configContext;
    protected Map<String, WebApplicationsHolder> webApplicationsHolderMap;
    private String[] defaultWatchedResources;

    public void init(ConfigurationContext configCtx) {
        this.configContext = configCtx;
        String repoPath = configCtx.getAxisConfiguration().getRepository().getPath();
        File webappsDirFile = new File(repoPath + File.separator + this.webappsDir);
        if (!webappsDirFile.exists() && !webappsDirFile.mkdirs()) {
            log.warn((Object)("Could not create directory " + webappsDirFile.getAbsolutePath()));
        }
        PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        int tenantId = privilegedCarbonContext.getTenantId();
        String tenantDomain = privilegedCarbonContext.getTenantDomain();
        String webContextPrefix = tenantDomain != null && !"carbon.super".equals(tenantDomain) ? "/t/" + tenantDomain + "/" + this.webappsDir + "/" : "";
        this.webApplicationsHolderMap = (Map)configCtx.getProperty("carbon.webapps.holderlist");
        if (this.webApplicationsHolderMap == null) {
            this.webApplicationsHolderMap = new HashMap<String, WebApplicationsHolder>();
            configCtx.setProperty("carbon.webapps.holderlist", this.webApplicationsHolderMap);
        }
        if (!this.webApplicationsHolderMap.containsKey(this.webappsDir) && WebAppUtils.appBases.contains(this.webappsDir)) {
            WebApplicationsHolder webApplicationsHolder = new WebApplicationsHolder(new File(this.webappsDir));
            this.webApplicationsHolderMap.put(this.webappsDir, webApplicationsHolder);
        }
        this.tomcatWebappDeployer = this.createTomcatGenericWebappDeployer(webContextPrefix, tenantId, tenantDomain);
        configCtx.setProperty("servlet.context.parameters.list", this.servletContextParameters);
        this.defaultWatchedResources = new String[]{"WEB-INF" + File.separator + "web.xml", "WEB-INF" + File.separator + "lib", "WEB-INF" + File.separator + "classes"};
    }

    protected abstract TomcatGenericWebappsDeployer createTomcatGenericWebappDeployer(String var1, int var2, String var3);

    protected abstract String getType();

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        if (!this.isSkippedWebapp(deploymentFileData.getFile())) {
            this.deployThisWebApp(deploymentFileData);
        }
    }

    private void deployThisWebApp(DeploymentFileData deploymentFileData) throws DeploymentException {
        try {
            ArrayList<Object> listeners = new ArrayList<Object>(1);
            this.tomcatWebappDeployer.deploy(deploymentFileData.getFile(), (ArrayList)this.configContext.getProperty("servlet.context.parameters.list"), listeners);
            super.deploy(deploymentFileData);
        }
        catch (Exception e) {
            String msg = "Error occurred while deploying webapp : " + deploymentFileData.getFile().getAbsolutePath();
            if (deploymentFileData.getAbsolutePath().contains("carbonapps")) {
                String failedArtifact = deploymentFileData.getFile().getName();
                WebApplicationsHolder webappsHolder = WebAppUtils.getWebappHolder(deploymentFileData.getAbsolutePath(), this.configContext);
                webappsHolder.getFaultyWebapps().remove(failedArtifact);
            }
            log.error((Object)msg, (Throwable)e);
            throw new DeploymentException(msg, (Throwable)e);
        }
    }

    public void undeploy(String fileName) throws DeploymentException {
        if (fileName.endsWith(".war")) {
            File warFile = new File(fileName);
            if (fileName.contains("carbonapps")) {
                this.handleUndeployment(fileName, warFile);
            } else if (!warFile.exists()) {
                this.handleUndeployment(fileName, warFile);
            } else {
                this.handleUndeployment(fileName, warFile);
                this.handleRedeployment(warFile);
            }
        } else {
            Context context;
            File warFile = new File(fileName.concat(".war"));
            File unpackedFile = new File(fileName);
            if (!unpackedFile.exists()) {
                if (!warFile.exists()) {
                    this.handleUndeployment(fileName, unpackedFile);
                } else {
                    this.handleUndeployment(fileName, unpackedFile);
                    this.handleRedeployment(warFile);
                }
            } else if (this.isWatchedResourceChanged(fileName, unpackedFile) && (context = this.getWebappContext(unpackedFile)) != null) {
                context.reload();
                log.info((Object)("Reloaded Context with name: " + context.getName()));
            }
        }
    }

    private boolean isWatchedResourceChanged(String fileName, File file) {
        for (String watchedResource : this.defaultWatchedResources) {
            File watchedResourceFile = new File(fileName + File.separator + watchedResource);
            if (watchedResourceFile.lastModified() <= file.lastModified()) continue;
            return true;
        }
        Context context = this.getWebappContext(file);
        if (context != null) {
            String[] watchedResources;
            for (String watchedResource : watchedResources = context.findWatchedResources()) {
                File watchedResourceFile = new File(fileName + File.separator + watchedResource);
                if (watchedResourceFile.lastModified() < file.lastModified()) continue;
                return true;
            }
        }
        return false;
    }

    private Context getWebappContext(File file) {
        WebApplicationsHolder webApplicationsHolder = WebAppUtils.getWebappHolder(file.getAbsolutePath(), this.configContext);
        Map<String, WebApplication> webappMap = webApplicationsHolder.getStartedWebapps();
        WebApplication webapp = webappMap.get(file.getName() + ".war");
        if (webapp != null || (webapp = webappMap.get(file.getName())) != null) {
            return webapp.getContext();
        }
        webappMap = webApplicationsHolder.getStoppedWebapps();
        webapp = webappMap.get(file.getName() + ".war");
        if (webapp != null || (webapp = webappMap.get(file.getName())) != null) {
            return webapp.getContext();
        }
        return null;
    }

    public void cleanup() throws DeploymentException {
        for (String filePath : this.deploymentFileDataMap.keySet()) {
            try {
                this.tomcatWebappDeployer.lazyUnload(new File(filePath));
            }
            catch (CarbonException e) {
                String msg = "Error occurred during cleaning up webapps";
                log.error((Object)msg, (Throwable)e);
                throw new DeploymentException(msg, (Throwable)e);
            }
        }
    }

    private boolean isSkippedWebapp(File webappFile) {
        String webappFilePath = webappFile.getPath();
        boolean isSkipped = true;
        if (webappFilePath.contains("##")) {
            log.info((Object)("Unsupported file path format : " + webappFile));
            return true;
        }
        if ("war".equals(this.extension) || webappFilePath.endsWith(".war")) {
            return this.isInsideAnotherApp(webappFilePath);
        }
        if (webappFilePath.contains("jaxwebapps") || webappFilePath.contains("jaggeryapps") || webappFilePath.contains("carbonapps")) {
            return false;
        }
        String warFilePath = webappFilePath.concat(".war");
        File warFile = new File(warFilePath);
        if (warFile.exists()) {
            return true;
        }
        Host host = DataHolder.getCarbonTomcatService().getTomcat().getHost();
        String webappContext = "/" + webappFile.getName();
        boolean isExistingFaultyApp = this.isExistingFaultyApp(webappFile.getAbsolutePath());
        if (host.findChild(webappContext) == null && webappFile.isDirectory() && !isExistingFaultyApp) {
            isSkipped = false;
        }
        return isSkipped;
    }

    private boolean isHotUpdating(File file) {
        return file.exists();
    }

    private void handleUndeployment(String fileName, File webappToUndeploy) throws DeploymentException {
        try {
            this.tomcatWebappDeployer.undeploy(webappToUndeploy);
        }
        catch (CarbonException e) {
            String msg = "Error occurred during undeploying webapp: " + fileName;
            log.error((Object)msg, (Throwable)e);
            throw new DeploymentException(msg, (Throwable)e);
        }
        super.undeploy(fileName);
    }

    public boolean isExistingFaultyApp(String filePath) {
        WebApplicationsHolder webApplicationsHolder = WebAppUtils.getWebappHolder(filePath, this.configContext);
        if (webApplicationsHolder.getFaultyWebapps() != null) {
            if (webApplicationsHolder.getFaultyWebapps().get(WebAppUtils.getWebappName(filePath)) != null) {
                return true;
            }
            if (webApplicationsHolder.getFaultyWebapps().get(WebAppUtils.getWebappName(filePath) + ".war") != null) {
                return true;
            }
        }
        return false;
    }

    private boolean isInsideAnotherApp(String path) {
        boolean fromCApp = path.contains("carbonapps");
        if (path != null && path.endsWith(".war") && !fromCApp) {
            String base = path.substring(0, path.lastIndexOf(File.separator));
            int index = base.lastIndexOf(File.separator) + 1;
            String baseName = base.substring(index);
            if (base != null && !this.webappsDir.equals(baseName)) {
                return true;
            }
            String preBase = base.substring(0, index - 1);
            String preBaseName = preBase.substring(preBase.lastIndexOf(File.separator) + 1);
            if (preBaseName != null && this.webappsDir.equals(preBaseName)) {
                return true;
            }
        }
        return false;
    }

    protected void handleRedeployment(File file) throws DeploymentException {
        DeploymentFileData data = new DeploymentFileData(file, (Deployer)this);
        this.deploy(data);
    }
}

