/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.SocketException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.servlet.ServletRegistration;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.catalina.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.persistence.metadata.ArtifactMetadataException;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.utils.ArchiveManipulator;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.DataPaginator;
import org.wso2.carbon.utils.NetworkUtils;
import org.wso2.carbon.utils.Pageable;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.SessionMetadata;
import org.wso2.carbon.webapp.mgt.SessionsWrapper;
import org.wso2.carbon.webapp.mgt.TomcatUtil;
import org.wso2.carbon.webapp.mgt.VersionedWebappMetadata;
import org.wso2.carbon.webapp.mgt.VhostHolder;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebappMetadata;
import org.wso2.carbon.webapp.mgt.WebappStatistics;
import org.wso2.carbon.webapp.mgt.WebappUploadData;
import org.wso2.carbon.webapp.mgt.WebapplicationHelper;
import org.wso2.carbon.webapp.mgt.WebappsConstants;
import org.wso2.carbon.webapp.mgt.WebappsWrapper;
import org.wso2.carbon.webapp.mgt.sync.ApplicationSynchronizeRequest;
import org.wso2.carbon.webapp.mgt.utils.WebAppUtils;
import org.wso2.carbon.webapp.mgt.version.AppVersionGroupPersister;

public class WebappAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(WebappAdmin.class);
    private static Boolean defaultVersionManagement = null;
    private Map<String, Boolean> versioningConfiguration = new HashMap<String, Boolean>();
    private Map<String, String> appGroupToCurrentVersionMap = null;

    public WebappAdmin() {
    }

    public WebappAdmin(AxisConfiguration axisConfig) throws Exception {
        super(axisConfig);
    }

    public WebappsWrapper getPagedWebappsSummary(String webappSearchString, String webappState, String webappType, int pageNumber) throws AxisFault {
        if (webappState.equalsIgnoreCase("started")) {
            return this.getPagedWebapps(pageNumber, this.getStartedWebapps(webappType, webappSearchString), webappType);
        }
        if (webappState.equalsIgnoreCase("stopped")) {
            return this.getPagedWebapps(pageNumber, this.getStoppedWebapps(webappType, webappSearchString), webappType);
        }
        if (webappState.equalsIgnoreCase("all")) {
            Map<String, VersionedWebappMetadata> startedWebapps = this.getStartedWebapps(webappType, webappSearchString);
            Map<String, VersionedWebappMetadata> stoppedWebapps = this.getStoppedWebapps(webappType, webappSearchString);
            ConcurrentHashMap<String, VersionedWebappMetadata> webapps = new ConcurrentHashMap<String, VersionedWebappMetadata>(startedWebapps);
            for (String versionGroup : stoppedWebapps.keySet()) {
                if (webapps.containsKey(versionGroup)) {
                    for (WebappMetadata webappMetadata : stoppedWebapps.get(versionGroup).getVersionGroups()) {
                        ((VersionedWebappMetadata)webapps.get(versionGroup)).addWebappVersion(webappMetadata);
                    }
                    continue;
                }
                webapps.put(versionGroup, stoppedWebapps.get(versionGroup));
            }
            return this.getPagedWebapps(pageNumber, webapps, webappType);
        }
        throw new AxisFault("Invalid webapp state: ", webappState);
    }

    public WebappMetadata getStartedWebapp(String webappFileName, String hostName) {
        Map<String, WebApplicationsHolder> webApplicationsHolderMap = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        WebappMetadata webappMetadata = null;
        for (WebApplicationsHolder webApplicationsHolder : webApplicationsHolderMap.values()) {
            WebApplication webApplication = webApplicationsHolder.getStartedWebapps().get(webappFileName);
            if (webApplication == null || !webApplication.getHostName().equals(hostName)) continue;
            webappMetadata = this.getWebapp(webApplication);
            webappMetadata.setStarted(true);
            break;
        }
        return webappMetadata;
    }

    public WebappMetadata getStoppedWebapp(String webappFileName, String hostName) {
        Map<String, WebApplicationsHolder> webApplicationsHolderMap = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        WebappMetadata webappMetadata = null;
        for (WebApplicationsHolder webApplicationsHolder : webApplicationsHolderMap.values()) {
            WebApplication webApplication = webApplicationsHolder.getStoppedWebapps().get(webappFileName);
            if (webApplication == null || !webApplication.getHostName().equals(hostName)) continue;
            webappMetadata = this.getWebapp(webApplication);
            webappMetadata.setStarted(false);
            break;
        }
        return webappMetadata;
    }

    private void setServiceListPath(WebApplication webApplication) {
        String serviceListPathParamName = "service-list-path";
        String serviceListPathParam = webApplication.getContext().getServletContext().getInitParameter(serviceListPathParamName);
        if (serviceListPathParam == null || "".equals(serviceListPathParam)) {
            ServletRegistration servletReg;
            Map servletRegs = webApplication.getContext().getServletContext().getServletRegistrations();
            Iterator iterator = servletRegs.values().iterator();
            while (iterator.hasNext() && (serviceListPathParam = (servletReg = (ServletRegistration)iterator.next()).getInitParameter(serviceListPathParamName)) == null && "".equals(serviceListPathParam)) {
            }
        }
        serviceListPathParam = serviceListPathParam == null || "".equals(serviceListPathParam) ? "/services" : "";
        webApplication.setServiceListPath(serviceListPathParam);
    }

    private boolean checkFaultyWebappParam(Context context) {
        String param = context.findParameter("faulty.webapp");
        return param != null && !"".equals(param) && Boolean.parseBoolean(param);
    }

    private WebappMetadata getWebapp(WebApplication webApplication) {
        WebappMetadata webappMetadata = new WebappMetadata();
        String appContext = WebAppUtils.checkJaxApplication(webApplication);
        boolean isFaulty = this.checkFaultyWebappParam(webApplication.getContext());
        if (appContext != null && !isFaulty && "STARTED".equalsIgnoreCase(webApplication.getContext().getStateName())) {
            webApplication.setProperty("webappFilter", "jaxWebapp");
            this.setServiceListPath(webApplication);
        }
        if (appContext == null) {
            appContext = "/";
        } else if (appContext.endsWith("/*")) {
            appContext = appContext.substring(0, appContext.indexOf("/*"));
        }
        Path webAppPath = Paths.get(webApplication.getWebappFile().getAbsolutePath(), new String[0]);
        if (webAppPath != null) {
            String tenantId = AppDeployerUtils.getTenantIdString();
            ArrayList appList = DataHolder.getApplicationManager().getCarbonApps(tenantId);
            for (CarbonApplication application : appList) {
                Path cappPath = Paths.get(application.getExtractedPath(), new String[0]);
                if (!webAppPath.startsWith(cappPath)) continue;
                webappMetadata.setCAppArtifact(true);
                break;
            }
        }
        webappMetadata.setDisplayName(webApplication.getDisplayName());
        webappMetadata.setContext(webApplication.getContextName());
        webappMetadata.setHostName(webApplication.getHostName());
        webappMetadata.setWebappKey(WebAppUtils.getWebappKey(webApplication.getWebappFile()));
        webappMetadata.setServletContext(appContext);
        webappMetadata.setLastModifiedTime(webApplication.getLastModifiedTime());
        webappMetadata.setWebappFile(webApplication.getWebappFile().getName());
        webappMetadata.setState(webApplication.getState());
        webappMetadata.setServiceListPath(webApplication.getServiceListPath());
        webappMetadata.setAppVersion(webApplication.getVersion());
        webappMetadata.setContextPath(webApplication.getContext().getPath());
        WebApplication.Statistics statistics = webApplication.getStatistics();
        WebappStatistics stats = new WebappStatistics();
        stats.setActiveSessions(statistics.getActiveSessions());
        stats.setAvgSessionLifetime(statistics.getAvgSessionLifetime());
        stats.setExpiredSessions(statistics.getExpiredSessions());
        stats.setMaxActiveSessions(statistics.getMaxActiveSessions());
        stats.setMaxSessionInactivityInterval(statistics.getMaxSessionInactivityInterval());
        stats.setMaxSessionLifetime(statistics.getMaxSessionLifetime());
        stats.setRejectedSessions(statistics.getRejectedSessions());
        webappMetadata.setStatistics(stats);
        webappMetadata.setWebappType((String)webApplication.getProperty("webappFilter"));
        return webappMetadata;
    }

    public WebappsWrapper getPagedFaultyWebappsSummary(String webappSearchString, String webappType, int pageNumber) throws AxisFault {
        return this.getPagedWebapps(pageNumber, this.getFaultyWebapps(webappSearchString), webappType);
    }

    private WebappsWrapper getPagedWebapps(int pageNumber, Map<String, VersionedWebappMetadata> webapps, String webappType) {
        ArrayList<VersionedWebappMetadata> webappsList = new ArrayList<VersionedWebappMetadata>(webapps.values());
        Map<String, WebApplicationsHolder> webApplicationsHolderMap = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        WebappsWrapper webappsWrapper = this.getWebappsWrapper(webApplicationsHolderMap, webappsList, webappType);
        try {
            webappsWrapper.setHostName(NetworkUtils.getLocalHostname());
        }
        catch (SocketException e) {
            log.error((Object)"Error occurred while getting local hostname", (Throwable)e);
        }
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        String httpProxyPortString = serverConfiguration.getFirstProperty("Ports.WorkerHttpProxyPort");
        int httpProxyPort = -1;
        if (httpProxyPortString != null) {
            httpProxyPort = Integer.parseInt(httpProxyPortString);
            webappsWrapper.setHttpPort(httpProxyPort);
        }
        if (httpProxyPort == -1 && this.getConfigContext().getAxisConfiguration().getTransportIn("http") != null) {
            httpProxyPort = CarbonUtils.getTransportProxyPort((ConfigurationContext)this.getConfigContext(), (String)"http");
            if (httpProxyPort != -1) {
                webappsWrapper.setHttpPort(httpProxyPort);
            } else {
                int httpPort = CarbonUtils.getTransportPort((ConfigurationContext)this.getConfigContext(), (String)"http");
                webappsWrapper.setHttpPort(httpPort);
            }
        }
        String httpsProxyPortString = serverConfiguration.getFirstProperty("Ports.WorkerHttpsProxyPort");
        int httpsProxyPort = -1;
        if (httpsProxyPortString != null) {
            httpsProxyPort = Integer.parseInt(httpsProxyPortString);
            webappsWrapper.setHttpsPort(httpsProxyPort);
        }
        if (httpsProxyPort == -1 && this.getConfigContext().getAxisConfiguration().getTransportIn("https") != null) {
            httpsProxyPort = CarbonUtils.getTransportProxyPort((ConfigurationContext)this.getConfigContext(), (String)"https");
            if (httpsProxyPort != -1) {
                webappsWrapper.setHttpsPort(httpsProxyPort);
            } else {
                int httpsPort = CarbonUtils.getTransportPort((ConfigurationContext)this.getConfigContext(), (String)"https");
                webappsWrapper.setHttpsPort(httpsPort);
            }
        }
        this.sortWebapps(webappsList);
        DataPaginator.doPaging((int)pageNumber, webappsList, (Pageable)webappsWrapper);
        return webappsWrapper;
    }

    private void sortWebapps(List<VersionedWebappMetadata> webapps) {
        if (webapps.size() > 0) {
            Collections.sort(webapps, new Comparator<VersionedWebappMetadata>(){

                @Override
                public int compare(VersionedWebappMetadata arg0, VersionedWebappMetadata arg1) {
                    return arg0.getAppVersionRoot().compareToIgnoreCase(arg1.getAppVersionRoot());
                }
            });
        }
        for (VersionedWebappMetadata versionedWebappMetadata : webapps) {
            versionedWebappMetadata.sort();
        }
    }

    private Map<String, VersionedWebappMetadata> getStartedWebapps(String webappType, String webappSearchString) {
        Map<String, WebApplicationsHolder> webApplicationsHolderMap = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        ArrayList<WebApplication> allwebapps = new ArrayList<WebApplication>();
        for (WebApplicationsHolder webApplicationsHolder : webApplicationsHolderMap.values()) {
            allwebapps.addAll(webApplicationsHolder.getStartedWebapps().values());
        }
        return this.getWebapps(allwebapps, webappType, webappSearchString);
    }

    private Map<String, VersionedWebappMetadata> getStoppedWebapps(String webappType, String webappSearchString) {
        Map<String, WebApplicationsHolder> webApplicationsHolderMap = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        ArrayList<WebApplication> allStoppedWebapps = new ArrayList<WebApplication>();
        for (WebApplicationsHolder webApplicationsHolder : webApplicationsHolderMap.values()) {
            allStoppedWebapps.addAll(webApplicationsHolder.getStoppedWebapps().values());
        }
        return this.getWebapps(allStoppedWebapps, webappType, webappSearchString);
    }

    private Map<String, VersionedWebappMetadata> getWebapps(Collection<WebApplication> allWebapps, String webappType, String webappsSearchString) {
        ConcurrentHashMap<String, VersionedWebappMetadata> webapps = new ConcurrentHashMap<String, VersionedWebappMetadata>();
        for (WebApplication webapp : allWebapps) {
            VersionedWebappMetadata versionedWebappMetadata;
            if (!this.doesWebappSatisfySearchString(webapp, webappsSearchString) || !this.isWebappRelevant(webapp, webappType)) continue;
            WebappMetadata webappMetadata = this.getWebapp(webapp);
            WebappStatistics stats = webappMetadata.getStatistics();
            String appVersionRoot = webappMetadata.getContext();
            String webappKey = webappMetadata.getWebappKey();
            if (!"/default".equals(webapp.getVersion())) {
                appVersionRoot = appVersionRoot.substring(0, appVersionRoot.lastIndexOf(webappMetadata.getAppVersion()));
            }
            if (webapps.containsKey(webappKey)) {
                versionedWebappMetadata = (VersionedWebappMetadata)webapps.get(webappKey);
            } else {
                versionedWebappMetadata = new VersionedWebappMetadata(appVersionRoot);
                webapps.put(webappKey, versionedWebappMetadata);
            }
            versionedWebappMetadata.addWebappVersion(webappMetadata);
        }
        return webapps;
    }

    private Map<String, VersionedWebappMetadata> getFaultyWebapps(String webappsSearchString) {
        Map<String, WebApplicationsHolder> webApplicationsHolderMap = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        if (webApplicationsHolderMap == null) {
            return null;
        }
        String faultyAppVersionRoot = "/faulty";
        ConcurrentHashMap<String, VersionedWebappMetadata> webapps = new ConcurrentHashMap<String, VersionedWebappMetadata>();
        VersionedWebappMetadata versionedWebappMetadata = new VersionedWebappMetadata(faultyAppVersionRoot);
        webapps.put(faultyAppVersionRoot, versionedWebappMetadata);
        for (WebApplicationsHolder webApplicationsHolder : webApplicationsHolderMap.values()) {
            for (WebApplication webapp : webApplicationsHolder.getFaultyWebapps().values()) {
                if (!this.doesWebappSatisfySearchString(webapp, webappsSearchString)) continue;
                WebappMetadata webappMetadata = new WebappMetadata();
                webappMetadata.setContext(webapp.getContextName());
                webappMetadata.setHostName(webapp.getHostName());
                webappMetadata.setWebappKey(WebAppUtils.getWebappKey(webapp.getWebappFile()));
                webappMetadata.setLastModifiedTime(webapp.getLastModifiedTime());
                webappMetadata.setWebappFile(webapp.getWebappFile().getName());
                webappMetadata.setStarted(false);
                webappMetadata.setRunning(false);
                webappMetadata.setFaulty(true);
                StringWriter sw = new StringWriter();
                webapp.getFaultReason().printStackTrace(new PrintWriter(sw));
                String faultException = sw.toString();
                webappMetadata.setFaultException(faultException);
                versionedWebappMetadata.addWebappVersion(webappMetadata);
            }
        }
        return webapps;
    }

    protected boolean doesWebappSatisfySearchString(WebApplication webapp, String searchString) {
        if (searchString != null) {
            String regex = searchString.toLowerCase().replace("..?", ".?").replace("..*", ".*").replaceAll("\\?", ".?").replaceAll("\\*", ".*?");
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(webapp.getContextName().toLowerCase());
            return regex.trim().length() == 0 || matcher.find();
        }
        return false;
    }

    private WebappsWrapper getWebappsWrapper(Map<String, WebApplicationsHolder> webappsHolderList, List<VersionedWebappMetadata> webapps, String webappType) {
        HashMap<String, ArrayList<WebApplication>> allwebapps = new HashMap<String, ArrayList<WebApplication>>();
        HashMap<String, ArrayList<WebApplication>> allFaultyWebapps = new HashMap<String, ArrayList<WebApplication>>();
        WebappsWrapper webappsWrapper = new WebappsWrapper();
        for (WebApplicationsHolder webApplicationsHolder : webappsHolderList.values()) {
            for (WebApplication webApplication : webApplicationsHolder.getStartedWebapps().values()) {
                this.addValuetoMap(allwebapps, webApplication.getWebappFile().getName(), webApplication);
            }
            for (WebApplication webApplication : webApplicationsHolder.getFaultyWebapps().values()) {
                this.addValuetoMap(allFaultyWebapps, webApplication.getWebappFile().getName(), webApplication);
            }
        }
        webappsWrapper.setWebapps(webapps.toArray(new VersionedWebappMetadata[webapps.size()]));
        webappsWrapper.setNumberOfCorrectWebapps(this.getNumberOfWebapps(allwebapps, webappType));
        webappsWrapper.setNumberOfFaultyWebapps(this.getNumberOfWebapps(allFaultyWebapps, webappType));
        return webappsWrapper;
    }

    private void addValuetoMap(Map<String, ArrayList<WebApplication>> map, String key, WebApplication webApplication) {
        ArrayList<WebApplication> list = map.get(key);
        if (list == null) {
            list = new ArrayList();
            map.put(key, list);
        }
        list.add(webApplication);
    }

    private int getNumberOfWebapps(Map<String, ArrayList<WebApplication>> webappMap, String webappType) {
        int number = 0;
        for (Map.Entry<String, ArrayList<WebApplication>> webappEntry : webappMap.entrySet()) {
            for (WebApplication webApplication : webappEntry.getValue()) {
                if (!this.isWebappRelevant(webApplication, webappType)) continue;
                ++number;
            }
        }
        return number;
    }

    protected boolean isWebappRelevant(WebApplication webapp, String webappType) {
        if (webapp.getContextName().contains("STRATOS_ROOT")) {
            return false;
        }
        String filterProp = (String)webapp.getProperty("webappFilter");
        if ("all".equalsIgnoreCase(webappType)) {
            return true;
        }
        if ("jaxWebapp".equalsIgnoreCase(webappType)) {
            return filterProp != null && "jaxWebapp".equalsIgnoreCase(filterProp);
        }
        if ("jaggeryWebapp".equalsIgnoreCase(webappType)) {
            return filterProp != null && "jaggeryWebapp".equalsIgnoreCase(filterProp);
        }
        return filterProp == null || "webapp".equalsIgnoreCase(filterProp);
    }

    public void deleteStartedWebapps(String[] webappKey) throws AxisFault {
        Map<String, WebApplicationsHolder> webappsHolders = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        for (WebApplicationsHolder webApplicationsHolder : webappsHolders.values()) {
            this.deleteWebapps(webappKey, webApplicationsHolder.getStartedWebapps());
        }
    }

    public void deleteStoppedWebapps(String[] webappKey) throws AxisFault {
        Map<String, WebApplicationsHolder> webappsHolders = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        for (WebApplicationsHolder webApplicationsHolder : webappsHolders.values()) {
            this.deleteWebapps(webappKey, webApplicationsHolder.getStoppedWebapps());
        }
    }

    public void deleteFaultyWebapps(String[] webappKey) throws AxisFault {
        Map<String, WebApplicationsHolder> webappsHolders = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        for (WebApplicationsHolder webApplicationsHolder : webappsHolders.values()) {
            this.deleteWebapps(webappKey, webApplicationsHolder.getFaultyWebapps());
        }
    }

    public void deleteAllWebApps(String[] webappKey) throws AxisFault {
        Map<String, WebApplicationsHolder> webappsHolders = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        for (WebApplicationsHolder webApplicationsHolder : webappsHolders.values()) {
            this.deleteWebapps(webappKey, webApplicationsHolder.getStartedWebapps());
            this.deleteWebapps(webappKey, webApplicationsHolder.getStoppedWebapps());
            this.deleteWebapps(webappKey, webApplicationsHolder.getFaultyWebapps());
        }
    }

    private void deleteWebapps(String[] webappKey, Map<String, WebApplication> webapps) throws AxisFault {
        for (String key : webappKey) {
            WebApplication webApplication = null;
            webApplication = key.contains(":") ? webapps.get(this.getProperty("WebappName", key)) : webapps.get(key);
            if (webApplication == null || !this.getProperty("HostName", key).equals(webApplication.getHostName())) continue;
            try {
                webapps.remove(webApplication.getWebappFile().getName());
                webApplication.delete();
            }
            catch (CarbonException e) {
                this.handleException("Could not delete webapp " + webApplication, (Exception)((Object)e));
            }
        }
    }

    private String getProperty(String propertyName, String keyvalue) {
        if (propertyName.equals("HostName")) {
            return keyvalue.split(":")[0];
        }
        if (propertyName.equals("WebappName")) {
            return keyvalue.split(":")[1];
        }
        return "";
    }

    private void undeployWebapps(String[] webappFileNames, Map<String, WebApplication> webapps) throws AxisFault {
        for (String webappFileName : webappFileNames) {
            WebApplication webapp = webapps.get(webappFileName);
            try {
                webapp.undeploy();
                webapps.remove(webappFileName);
            }
            catch (CarbonException e) {
                this.handleException("Could not delete webapp " + webapp, (Exception)((Object)e));
            }
        }
    }

    public void deleteAllStartedWebapps() throws AxisFault {
        Map<String, WebApplicationsHolder> webappsHolders = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        for (WebApplicationsHolder webApplicationsHolder : webappsHolders.values()) {
            this.deleteAllWebapps(webApplicationsHolder.getStartedWebapps());
        }
    }

    public void deleteAllStoppedWebapps() throws AxisFault {
        Map<String, WebApplicationsHolder> webappsHolders = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        for (WebApplicationsHolder webApplicationsHolder : webappsHolders.values()) {
            this.deleteAllWebapps(webApplicationsHolder.getStoppedWebapps());
        }
    }

    public void deleteAllFaultyWebapps() throws AxisFault {
        Map<String, WebApplicationsHolder> webappsHolders = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        for (WebApplicationsHolder webApplicationsHolder : webappsHolders.values()) {
            this.deleteAllWebapps(webApplicationsHolder.getFaultyWebapps());
        }
    }

    private void deleteAllWebapps(Map<String, WebApplication> webapps) throws AxisFault {
        for (WebApplication webapp : webapps.values()) {
            try {
                webapp.delete();
            }
            catch (CarbonException e) {
                this.handleException("Could not delete started webapp " + webapp, (Exception)((Object)e));
            }
        }
        webapps.clear();
    }

    public void reloadAllWebapps() {
        Map<String, WebApplicationsHolder> webApplicationsHolderMap = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        ArrayList<WebapplicationHelper> webapplicationHelperList = new ArrayList<WebapplicationHelper>();
        for (WebApplicationsHolder webApplicationsHolder : webApplicationsHolderMap.values()) {
            Map<String, WebApplication> startedWebapps = webApplicationsHolder.getStartedWebapps();
            for (WebApplication webapp : startedWebapps.values()) {
                webapp.reload();
                webapplicationHelperList.add(new WebapplicationHelper(webapp.getHostName(), webapp.getWebappFile().getName()));
            }
            this.sendClusterSyncMessage(WebappsConstants.ApplicationOpType.RELOAD, webapplicationHelperList);
        }
    }

    public void reloadWebapps(String[] webappKey) {
        Map<String, WebApplicationsHolder> webappsHolders = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        ArrayList<WebapplicationHelper> webapplicationHelperList = new ArrayList<WebapplicationHelper>();
        for (WebApplicationsHolder webApplicationsHolder : webappsHolders.values()) {
            for (String key : webappKey) {
                WebApplication webApplication = key.contains(":") ? webApplicationsHolder.getStartedWebapps().get(this.getProperty("WebappName", key)) : webApplicationsHolder.getStartedWebapps().get(key);
                if ((webApplication == null || !this.getProperty("HostName", key).equals(webApplication.getHostName())) && (webApplication == null || !WebAppUtils.getServerConfigHostName().equals(webApplication.getHostName()))) continue;
                webApplication.reload();
                webapplicationHelperList.add(new WebapplicationHelper(webApplication.getHostName(), webApplication.getWebappFile().getName()));
            }
        }
        this.sendClusterSyncMessage(WebappsConstants.ApplicationOpType.RELOAD, webapplicationHelperList);
    }

    public void setBamConfiguration(String webappFileName, String value, String hostName) {
        Map<String, WebApplicationsHolder> webappsHolders = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        for (WebApplicationsHolder webApplicationsHolder : webappsHolders.values()) {
            WebApplication webApplication = webApplicationsHolder.getStartedWebapps().get(webappFileName);
            if (webApplication == null || !webApplication.getHostName().equals(hostName)) continue;
            webApplication.updateWebappMetaDataforBam(value);
            break;
        }
    }

    public String getBamConfiguration(String webappFileName, String hostName) {
        Map<String, WebApplicationsHolder> webappsHolders = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        String metadata = null;
        for (WebApplicationsHolder webApplicationsHolder : webappsHolders.values()) {
            try {
                WebApplication webApplication = webApplicationsHolder.getStartedWebapps().get(webappFileName);
                if (webApplication == null || !webApplication.getHostName().equals(hostName)) continue;
                metadata = webApplication.getBamEnableFromWebappMetaData();
                break;
            }
            catch (Exception e) {
                log.error((Object)"Unable to read bam configurations", (Throwable)e);
                return null;
            }
        }
        return metadata;
    }

    public void stopAllWebapps() throws AxisFault {
        Map<String, WebApplicationsHolder> webappsHolders = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        ArrayList<WebapplicationHelper> webapplicationHelperList = new ArrayList<WebapplicationHelper>();
        for (WebApplicationsHolder webApplicationsHolder : webappsHolders.values()) {
            Map<String, WebApplication> startedWebapps = webApplicationsHolder.getStartedWebapps();
            for (WebApplication webapp : startedWebapps.values()) {
                webapplicationHelperList.add(new WebapplicationHelper(webapp.getHostName(), webapp.getWebappFile().getName()));
                try {
                    webapp.stop();
                    this.persistWebappStoppedState(webapp);
                }
                catch (CarbonException e) {
                    this.handleException("Error occurred while undeploying all webapps", (Exception)((Object)e));
                }
            }
            startedWebapps.clear();
        }
        this.sendClusterSyncMessage(WebappsConstants.ApplicationOpType.STOP, webapplicationHelperList);
    }

    public void stopWebapps(String[] webappKeys) throws AxisFault {
        Map<String, WebApplicationsHolder> webappsHolders = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        ArrayList<WebapplicationHelper> webapplicationHelperList = new ArrayList<WebapplicationHelper>();
        for (WebApplicationsHolder webApplicationsHolder : webappsHolders.values()) {
            Map<String, WebApplication> startedWebapps = webApplicationsHolder.getStartedWebapps();
            for (String key : webappKeys) {
                WebApplication webApplication = key.contains(":") ? startedWebapps.get(this.getProperty("WebappName", key)) : startedWebapps.get(key);
                try {
                    if ((webApplication == null || !this.getProperty("HostName", key).equals(webApplication.getHostName())) && (webApplication == null || !WebAppUtils.getServerConfigHostName().equals(webApplication.getHostName()))) continue;
                    webApplicationsHolder.stopWebapp(webApplication);
                    this.persistWebappStoppedState(webApplication);
                    webapplicationHelperList.add(new WebapplicationHelper(webApplication.getHostName(), webApplication.getWebappFile().getName()));
                }
                catch (CarbonException e) {
                    this.handleException("Error occurred while undeploying webapps", (Exception)((Object)e));
                }
            }
        }
        this.sendClusterSyncMessage(WebappsConstants.ApplicationOpType.STOP, webapplicationHelperList);
    }

    public void startAllWebapps() throws AxisFault {
        Map<String, WebApplicationsHolder> webappsHolders = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        ArrayList<WebapplicationHelper> webapplicationHelperList = new ArrayList<WebapplicationHelper>();
        for (WebApplicationsHolder webApplicationsHolder : webappsHolders.values()) {
            Map<String, WebApplication> stoppedWebapps = webApplicationsHolder.getStoppedWebapps();
            Deployer webappDeployer = ((DeploymentEngine)this.getAxisConfig().getConfigurator()).getDeployer(webApplicationsHolder.getWebappsDir().getName(), "war");
            for (WebApplication webapp : stoppedWebapps.values()) {
                this.startWebapp(stoppedWebapps, webapp, webApplicationsHolder);
                this.persistWebappStoppedState(webapp);
                webapplicationHelperList.add(new WebapplicationHelper(webapp.getHostName(), webapp.getWebappFile().getName()));
            }
            stoppedWebapps.clear();
        }
        this.sendClusterSyncMessage(WebappsConstants.ApplicationOpType.START, webapplicationHelperList);
    }

    public void startWebapps(String[] webappKeys) throws AxisFault {
        Map<String, WebApplicationsHolder> webappsHolders = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        ArrayList<WebapplicationHelper> webapplicationHelperList = new ArrayList<WebapplicationHelper>();
        for (WebApplicationsHolder webApplicationsHolder : webappsHolders.values()) {
            Map<String, WebApplication> stoppedWebapps = webApplicationsHolder.getStoppedWebapps();
            Deployer webappDeployer = ((DeploymentEngine)this.getAxisConfig().getConfigurator()).getDeployer(webApplicationsHolder.getWebappsDir().getName(), "war");
            for (String key : webappKeys) {
                WebApplication webApplication = key.contains(":") ? stoppedWebapps.get(this.getProperty("WebappName", key)) : stoppedWebapps.get(key);
                if ((webApplication == null || !this.getProperty("HostName", key).equals(webApplication.getHostName())) && (webApplication == null || !WebAppUtils.getServerConfigHostName().equals(webApplication.getHostName()))) continue;
                this.startWebapp(stoppedWebapps, webApplication, webApplicationsHolder);
                this.persistWebappStoppedState(webApplication);
                webapplicationHelperList.add(new WebapplicationHelper(webApplication.getHostName(), webApplication.getWebappFile().getName()));
            }
        }
        this.sendClusterSyncMessage(WebappsConstants.ApplicationOpType.START, webapplicationHelperList);
    }

    private void startWebapp(Map<String, WebApplication> stoppedWebapps, WebApplication webapp, WebApplicationsHolder webappsHolder) throws AxisFault {
        try {
            boolean started = webapp.start();
            if (started) {
                String webappFileName = webapp.getWebappFile().getName();
                stoppedWebapps.remove(webappFileName);
                Map<String, WebApplication> startedWebapps = webappsHolder.getStartedWebapps();
                startedWebapps.put(webappFileName, webapp);
            }
        }
        catch (CarbonException e) {
            String msg = "Cannot start webapp " + webapp;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public SessionsWrapper getActiveSessions(String webappFileName, int pageNumber, String hostName) {
        Map<String, WebApplicationsHolder> webappsHolders = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        ArrayList<SessionMetadata> sessionMetadataList = new ArrayList<SessionMetadata>();
        int numOfActiveSessions = 0;
        for (WebApplicationsHolder webApplicationsHolder : webappsHolders.values()) {
            WebApplication webapp = webApplicationsHolder.getStartedWebapps().get(webappFileName);
            if (webapp == null || !webapp.getHostName().equals(hostName)) continue;
            List<WebApplication.HttpSession> sessions = webapp.getSessions();
            numOfActiveSessions = sessions.size();
            for (WebApplication.HttpSession session : sessions) {
                sessionMetadataList.add(new SessionMetadata(session));
            }
        }
        this.sortSessions(sessionMetadataList);
        SessionsWrapper sessionsWrapper = new SessionsWrapper(sessionMetadataList);
        DataPaginator.doPaging((int)pageNumber, sessionMetadataList, (Pageable)sessionsWrapper);
        sessionsWrapper.setWebappFileName(webappFileName);
        sessionsWrapper.setNumberOfActiveSessions(numOfActiveSessions);
        return sessionsWrapper;
    }

    private void sortSessions(List<SessionMetadata> sessions) {
        if (sessions.size() > 0) {
            Collections.sort(sessions, new Comparator<SessionMetadata>(){

                @Override
                public int compare(SessionMetadata arg0, SessionMetadata arg1) {
                    return (int)(arg0.getLastAccessedTime() - arg1.getLastAccessedTime());
                }
            });
        }
    }

    public void expireSessionsInAllWebapps() {
        for (WebApplicationsHolder webApplicationsHolder : WebAppUtils.getAllWebappHolders(this.getConfigContext()).values()) {
            Map<String, WebApplication> webapps = webApplicationsHolder.getStartedWebapps();
            for (WebApplication webapp : webapps.values()) {
                webapp.expireAllSessions();
            }
        }
    }

    public void expireSessionsInWebapps(String[] webappKeySet) {
        for (WebApplicationsHolder webApplicationsHolder : WebAppUtils.getAllWebappHolders(this.getConfigContext()).values()) {
            Map<String, WebApplication> webapps = webApplicationsHolder.getStartedWebapps();
            for (String key : webappKeySet) {
                WebApplication webapp = key.contains(":") ? webapps.get(this.getProperty("WebappName", key)) : webapps.get(key);
                if ((webapp == null || !this.getProperty("HostName", key).equals(webapp.getHostName())) && (webapp == null || !WebAppUtils.getServerConfigHostName().equals(webapp.getHostName()))) continue;
                webapp.expireAllSessions();
            }
        }
    }

    public void expireSessionsInWebapp(String webappKey, long maxSessionLifetimeMillis) {
        for (WebApplicationsHolder webApplicationsHolder : WebAppUtils.getAllWebappHolders(this.getConfigContext()).values()) {
            Map<String, WebApplication> webapps = webApplicationsHolder.getStartedWebapps();
            WebApplication webapp = webappKey.contains(":") ? webapps.get(this.getProperty("WebappName", webappKey)) : webapps.get(webappKey);
            if ((webapp == null || !this.getProperty("HostName", webappKey).equals(webapp.getHostName())) && (webapp == null || !WebAppUtils.getServerConfigHostName().equals(webapp.getHostName()))) continue;
            webapp.expireSessions(maxSessionLifetimeMillis);
            break;
        }
    }

    public void expireSessions(String webappFileName, String[] sessionIDs, String hostName) throws AxisFault {
        for (WebApplicationsHolder webApplicationsHolder : WebAppUtils.getAllWebappHolders(this.getConfigContext()).values()) {
            Map<String, WebApplication> webapps = webApplicationsHolder.getStartedWebapps();
            WebApplication webapp = webapps.get(webappFileName);
            if (webapp == null || !webapp.getHostName().equals(hostName)) continue;
            try {
                webapp.expireSessions(sessionIDs);
            }
            catch (CarbonException e) {
                this.handleException("Cannot expire specified sessions in webapp " + webappFileName, (Exception)((Object)e));
            }
            break;
        }
    }

    public void expireAllSessions(String webappKey) {
        for (WebApplicationsHolder webApplicationsHolder : WebAppUtils.getAllWebappHolders(this.getConfigContext()).values()) {
            Map<String, WebApplication> webapps = webApplicationsHolder.getStartedWebapps();
            WebApplication webapp = webappKey.contains(":") ? webapps.get(this.getProperty("WebappName", webappKey)) : webapps.get(webappKey);
            if ((webapp == null || !this.getProperty("HostName", webappKey).equals(webapp.getHostName())) && (webapp == null || !WebAppUtils.getServerConfigHostName().equals(webapp.getHostName()))) continue;
            webapp.expireAllSessions();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadWebapp(WebappUploadData[] webappUploadDataList) throws AxisFault {
        AxisConfiguration axisConfig = this.getAxisConfig();
        for (WebappUploadData uploadData : webappUploadDataList) {
            File webappsDir;
            String hostname = uploadData.getHostName();
            if (uploadData.getHostName() == null) {
                hostname = WebAppUtils.getServerConfigHostName();
            }
            if (!(webappsDir = new File(this.getWebappDeploymentDirPath("webapp", hostname))).exists() && !webappsDir.mkdirs()) {
                log.warn((Object)("Could not create directory " + webappsDir.getAbsolutePath()));
            }
            String fileName = uploadData.getFileName();
            String version = uploadData.getVersion();
            if (version != "" && version != null) {
                if (fileName.contains(".war")) {
                    fileName = fileName.replace(".war", "#" + version + ".war");
                } else if (fileName.contains(".zip")) {
                    fileName = fileName.replace(".zip", "#" + version + ".zip");
                }
            }
            if (WebAppUtils.validateWebappFileName(fileName)) {
                String msg = "Web app file name consists unsupported characters  - " + fileName;
                log.error((Object)msg);
                throw new AxisFault(msg);
            }
            fileName = fileName.substring(fileName.lastIndexOf(System.getProperty("file.separator")) + 1);
            File destFile = new File(webappsDir, fileName);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(destFile);
                uploadData.getDataHandler().writeTo((OutputStream)fos);
            }
            catch (IOException e) {
                this.handleException("Error occured while uploading the webapp " + fileName, e);
            }
            finally {
                try {
                    if (fos != null) {
                        fos.flush();
                        fos.close();
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Could not close file " + destFile.getAbsolutePath()));
                }
            }
        }
        return true;
    }

    protected String getWebappDeploymentDirPath(String webappType, String hostName) {
        if ("jaggeryWebapp".equalsIgnoreCase(webappType)) {
            String webappDeploymentDir = "jaggeryapps";
            return this.getAxisConfig().getRepository().getPath() + File.separator + webappDeploymentDir;
        }
        String appBase = WebAppUtils.getAppbase(hostName);
        if (appBase.endsWith(File.separator)) {
            appBase = appBase.substring(0, appBase.length() - 1);
        }
        String webappDeploymentDir = appBase.substring(appBase.lastIndexOf(File.separator), appBase.length());
        return this.getAxisConfig().getRepository().getPath() + webappDeploymentDir;
    }

    protected String getWebappDeploymentDirPath(String webappType) {
        String webappDeploymentDir = "jaggeryWebapp".equalsIgnoreCase(webappType) ? "jaggeryapps" : "webapps";
        return this.getAxisConfig().getRepository().getPath() + File.separator + webappDeploymentDir;
    }

    protected String getWebappDeploymentFile(String fileName, String hostName, String webappType) {
        String webappFilepath = null;
        Map<String, WebApplicationsHolder> webApplicationsHolderMap = WebAppUtils.getAllWebappHolders(this.getConfigContext());
        for (WebApplicationsHolder webApplicationsHolder : webApplicationsHolderMap.values()) {
            WebApplication webApplication = webApplicationsHolder.getAllWebapps().get(fileName);
            if (webApplication == null || !webApplication.getHostName().equals(hostName)) continue;
            File webappFile = webApplicationsHolder.getAllWebapps().get(fileName).getWebappFile();
            if (webappFile.getAbsolutePath().contains("carbonapps")) {
                webappFilepath = webappFile.getAbsolutePath();
                break;
            }
            if ("jaggeryWebapp".equalsIgnoreCase(webappType)) {
                String webappDeploymentDir = "jaggeryapps";
                webappFilepath = this.getAxisConfig().getRepository().getPath() + webappDeploymentDir + File.separator + fileName;
                break;
            }
            webappFilepath = this.getAxisConfig().getRepository().getPath() + WebAppUtils.getWebappDir(webappFile.getAbsolutePath()) + File.separator + fileName;
            break;
        }
        return webappFilepath;
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataHandler downloadWarFileHandler(String fileName, String hostName, String webappType) {
        String repoPath = this.getAxisConfig().getRepository().getPath();
        String appsPath = this.getWebappDeploymentFile(fileName, hostName, webappType);
        File webAppFile = new File(appsPath);
        DataHandler handler = null;
        if (webAppFile.isDirectory()) {
            String zipTo = "tmp" + File.separator + fileName + ".zip";
            File fDownload = new File(zipTo);
            ArchiveManipulator archiveManipulator = new ArchiveManipulator();
            WebappAdmin webappAdmin = this;
            synchronized (webappAdmin) {
                try {
                    archiveManipulator.archiveDir(zipTo, webAppFile.getAbsolutePath());
                    FileDataSource datasource = new FileDataSource(fDownload);
                    handler = new DataHandler((DataSource)datasource);
                }
                catch (IOException e) {
                    log.error((Object)"Error downloading WAR file.", (Throwable)e);
                }
            }
        }
        FileDataSource datasource = new FileDataSource(new File(appsPath));
        handler = new DataHandler((DataSource)datasource);
        return handler;
    }

    public boolean isUnpackWARs() {
        return TomcatUtil.checkUnpackWars();
    }

    private void sendClusterSyncMessage(WebappsConstants.ApplicationOpType applicationOpType, List<WebapplicationHelper> webapplicationHelperList) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        ClusteringAgent clusteringAgent = DataHolder.getServerConfigContext().getAxisConfiguration().getClusteringAgent();
        if (clusteringAgent != null) {
            int numberOfRetries = 0;
            UUID messageId = UUID.randomUUID();
            ApplicationSynchronizeRequest request = new ApplicationSynchronizeRequest(tenantId, tenantDomain, messageId, applicationOpType, webapplicationHelperList);
            while (numberOfRetries < 60) {
                try {
                    clusteringAgent.sendMessage((ClusteringMessage)request, true);
                    log.info((Object)("Sent [" + (Object)((Object)request) + "]"));
                    break;
                }
                catch (ClusteringFault e) {
                    if (++numberOfRetries < 60) {
                        log.warn((Object)("Could not send SynchronizeRepositoryRequest for tenant " + tenantId + ". Retry will be attempted in 2s. Request: " + (Object)((Object)request)), (Throwable)e);
                    } else {
                        log.error((Object)("Could not send SynchronizeRepositoryRequest for tenant " + tenantId + ". Several retries failed. Request:" + (Object)((Object)request)), (Throwable)e);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    public void changeDefaultAppVersion(String appGroupName, String fileName, String hostName) throws AxisFault, ArtifactMetadataException {
        String appGroup = "";
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        if ("carbon.super".equals(tenantDomain)) {
            appGroup = appGroupName.replace("/", "");
        } else {
            String[] parts = appGroupName.split("/");
            appGroup = parts[parts.length - 1];
        }
        if (appGroup != null && fileName != null && this.isDefaultVersionManagementEnabled()) {
            boolean proceed = false;
            boolean noCurrentDefaultApp = false;
            AxisConfiguration axisConfig = this.getAxisConfig();
            String webappsDirPath = this.getWebappDeploymentDirPath("webapp", hostName);
            if (new File(webappsDirPath).exists()) {
                proceed = true;
            }
            if (proceed) {
                String originalNameOfCurrentDefaultApp = this.getOriginalNameOfCurrentDefaultApp(appGroup);
                File currentAppFile = new File(webappsDirPath, appGroup.concat(".war"));
                File currentAppOriginalFile = new File(webappsDirPath, originalNameOfCurrentDefaultApp);
                if (currentAppFile.exists() && !currentAppOriginalFile.exists()) {
                    this.handleWebappMetaDetaFile(appGroup.concat(".war"), originalNameOfCurrentDefaultApp, 1, hostName);
                    proceed = currentAppFile.renameTo(currentAppOriginalFile);
                }
            }
            if (proceed) {
                File newAppOriginalFile = new File(webappsDirPath, fileName);
                File newAppFile = new File(webappsDirPath, appGroup.concat(".war"));
                if (newAppOriginalFile.exists() && !newAppFile.exists()) {
                    proceed = newAppOriginalFile.renameTo(newAppFile);
                    if (proceed && log.isWarnEnabled()) {
                        this.setOriginalNameOfCurrentDefaultApp(appGroup, fileName);
                        log.info((Object)(fileName + " is marked as new default version "));
                    } else if (log.isWarnEnabled()) {
                        log.info((Object)("Error occurred making " + fileName + " as the default version"));
                    }
                }
            }
            if (!proceed && log.isWarnEnabled()) {
                log.info((Object)("Error occurred making " + fileName + " as the default version"));
            }
        }
    }

    private void setOriginalNameOfCurrentDefaultApp(String appName, String fileName) throws AxisFault, ArtifactMetadataException {
        AppVersionGroupPersister.persistWebappGroupMetadata(appName, fileName, this.getAxisConfig());
    }

    private void handleWebappMetaDetaFile(String originalFileName, String newFileName, int handlingStrategy, String hostName) {
        block0 : switch (handlingStrategy) {
            case 1: {
                for (WebApplicationsHolder webApplicationsHolder : WebAppUtils.getAllWebappHolders(this.getConfigContext()).values()) {
                    WebApplication webApplication = webApplicationsHolder.getStartedWebapps().get(originalFileName);
                    if (webApplication == null || !webApplication.getHostName().equals(hostName)) continue;
                    webApplication.addParameter("keepWebappMetadataHistory", Boolean.TRUE.toString());
                    break block0;
                }
                break;
            }
        }
    }

    private String getOriginalNameOfCurrentDefaultApp(String appName) throws AxisFault, ArtifactMetadataException {
        String originalName = AppVersionGroupPersister.readWebappGroupMetadata(appName, this.getAxisConfig());
        if (originalName == null) {
            StringBuilder builder = new StringBuilder(appName);
            builder.append("#").append("0").append(".war");
            return builder.toString();
        }
        return originalName;
    }

    private String getVhostAppbase(String hostName) {
        return WebAppUtils.getAppbase(hostName);
    }

    public boolean isDefaultVersionManagementEnabled() {
        return defaultVersionManagement == null ? Boolean.parseBoolean(System.getProperty("webapp.defaultversion")) : defaultVersionManagement;
    }

    public VhostHolder getVhostHolder() {
        List<String> vhostNames = WebAppUtils.getVhostNames();
        VhostHolder vhostHolder = new VhostHolder();
        vhostHolder.setVhosts(vhostNames.toArray(new String[vhostNames.size()]));
        vhostHolder.setDefaultHostName(WebAppUtils.getServerConfigHostName());
        return vhostHolder;
    }

    private void persistWebappStoppedState(WebApplication webApplication) {
        if (DataHolder.getRegistryService() != null) {
            try {
                UserRegistry configSystemRegistry = DataHolder.getRegistryService().getConfigSystemRegistry(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
                String webappResourcePath = WebAppUtils.getWebappResourcePath(webApplication);
                String webappStatus = webApplication.getState();
                Object webappResource = configSystemRegistry.resourceExists(webappResourcePath) ? configSystemRegistry.get(webappResourcePath) : configSystemRegistry.newCollection();
                webappResource.setProperty("Status", webappStatus);
                configSystemRegistry.put(webappResourcePath, (Resource)webappResource);
            }
            catch (RegistryException e) {
                log.error((Object)("Failed to persist webapp stopped state for: " + webApplication.getContext()));
            }
        }
    }
}

