/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

@WebFilter(value={"/AuthorizationHeaderFilter"})
public class AuthorizationHeaderFilter
implements Filter {
    private static final String AUTH_TYPE_BASIC = "Basic";
    private static final int AUTH_TYPE_BASIC_LENGTH = 5;
    private static final int MINIMUM_CREDENTIAL_SIZE = 4;
    private ServletContext context;

    public void init(FilterConfig fConfig) throws ServletException {
        this.context = fConfig.getServletContext();
        this.context.log("AuthorizationHeaderFilter initialized");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        final HttpServletRequest req = (HttpServletRequest)request;
        final String authHeader = req.getHeader("Authorization");
        if (StringUtils.isEmpty((String)authHeader)) {
            chain.doFilter(request, response);
            return;
        }
        String authType = null;
        if (authHeader.length() >= 5) {
            authType = authHeader.trim().substring(0, 5);
        }
        if (AUTH_TYPE_BASIC.equals(authType)) {
            final String authCredentials = authHeader.trim().substring(5).trim();
            if (StringUtils.isBlank((String)authCredentials) || authCredentials.indexOf(32) >= 0 || authCredentials.length() < 4) {
                String errorMsg = "Invalid credentials";
                this.handleErrorResponse((HttpServletResponse)response, 401, errorMsg);
            } else if (authHeader.substring("Basic ".length()).startsWith(" ")) {
                HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(req){

                    public Enumeration<String> getHeaders(String name) {
                        if (StringUtils.equalsIgnoreCase((String)name, (String)"Authorization")) {
                            Enumeration headerValues = req.getHeaders(name);
                            ArrayList<String> newHeaderValues = new ArrayList<String>();
                            while (headerValues.hasMoreElements()) {
                                String value = (String)headerValues.nextElement();
                                if (StringUtils.equals((String)value, (String)authHeader)) {
                                    value = "Basic " + authCredentials;
                                    newHeaderValues.add(value);
                                    continue;
                                }
                                newHeaderValues.add(value);
                            }
                            return Collections.enumeration(newHeaderValues);
                        }
                        return super.getHeaders(name);
                    }
                };
                chain.doFilter((ServletRequest)wrapper, response);
            } else {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private void handleErrorResponse(HttpServletResponse response, int error, String errorMsg) throws IOException {
        response.sendError(error, errorMsg);
    }
}

